/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.examples.cloudio.snippets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.zest.cloudio.ICloudLabelProvider;
import org.eclipse.zest.cloudio.TagCloud;
import org.eclipse.zest.cloudio.TagCloudViewer;
import org.eclipse.zest.examples.cloudio.application.Messages;

public class TagCloudViewerSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        TagCloud cloud = new TagCloud((Composite)shell, 0);
        TagCloudViewer viewer = new TagCloudViewer(cloud);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new CustomLabelProvider(cloud.getFont()));
        viewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            System.out.println(Messages.TagCloudViewerSnippet_Selection + String.valueOf(selection));
        });
        ArrayList<String> data = new ArrayList<String>();
        data.add(Messages.TagCloudViewerSnippet_Hello);
        data.add(Messages.TagCloudViewerSnippet_World);
        data.add(Messages.TagCloudViewerSnippet_HelloCloudio);
        shell.setBounds(50, 50, 300, 300);
        cloud.setBounds(0, 0, shell.getBounds().width, shell.getBounds().height);
        viewer.setInput(data);
        viewer.setSelection((ISelection)new StructuredSelection(Arrays.asList(Messages.TagCloudViewerSnippet_HelloCloudio)));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    static class CustomLabelProvider
    extends BaseLabelProvider
    implements ICloudLabelProvider {
        private final Font font;

        public CustomLabelProvider(Font font) {
            this.font = font;
        }

        public String getLabel(Object element) {
            return element.toString();
        }

        public double getWeight(Object element) {
            return Math.random();
        }

        public Color getColor(Object element) {
            return Display.getDefault().getSystemColor(5);
        }

        public FontData[] getFontData(Object element) {
            return this.font.getFontData();
        }

        public float getAngle(Object element) {
            return (float)(-90.0 + Math.random() * 180.0);
        }

        public String getToolTip(Object element) {
            return element.toString();
        }
    }
}

