/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.Style;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;

public class ApplyMultiStyle
extends MiniEdit {
    private int oldValue;
    private int newValue = -1;
    private String styleID;
    private Style style;

    public ApplyMultiStyle(Container c, String property, Object value) {
        this.style = c.getStyle();
        this.styleID = property;
        this.newValue = (Integer)value;
    }

    @Override
    public boolean canApply() {
        return this.newValue != -1;
    }

    @Override
    public void apply() {
        if ("alignment".equals(this.styleID)) {
            this.oldValue = this.style.getAlignment();
            this.style.setAlignment(this.newValue);
        } else if ("orientation".equals(this.styleID)) {
            this.oldValue = this.style.getOrientation();
            this.style.setOrientation(this.newValue);
        }
    }

    @Override
    public ModelLocation getResultingLocation() {
        return null;
    }

    @Override
    public void rollback() {
        if ("alignment".equals(this.styleID)) {
            this.style.setAlignment(this.oldValue);
        } else if ("orientation".equals(this.styleID)) {
            this.style.setOrientation(this.oldValue);
        }
    }
}

