/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionModel {
    private final SelectionRange selectionRange;
    private final EditPart selectionContainer;
    private final List<EditPart> constantSelection;

    public SelectionModel(ISelection selection) {
        List list;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)selection;
            list = structSel.toList();
        } else {
            list = null;
        }
        this(null, list, null);
    }

    public SelectionModel(SelectionRange range, List<EditPart> selectedParts, EditPart container) {
        this.selectionRange = range;
        this.selectionContainer = container;
        this.constantSelection = selectedParts == null ? Collections.emptyList() : Collections.unmodifiableList(selectedParts);
    }

    protected void applySelectedParts() {
        if (!this.constantSelection.isEmpty()) {
            Iterator<EditPart> itr = this.constantSelection.iterator();
            while (true) {
                EditPart part = itr.next();
                if (!itr.hasNext()) {
                    part.setSelected(2);
                    break;
                }
                part.setSelected(1);
            }
        }
    }

    protected void applySelectionRange() {
        SelectionRange range = this.getSelectionRange();
        if (range != null) {
            List<EditPart> currentSelection = range.getSelectedParts();
            for (EditPart element : currentSelection) {
                TextEditPart textpart = (TextEditPart)element;
                textpart.setSelection(0, textpart.getLength());
            }
            if (range.begin.part == range.end.part) {
                range.begin.part.setSelection(range.begin.offset, range.end.offset);
            } else {
                range.begin.part.setSelection(range.begin.offset, range.begin.part.getLength());
                range.end.part.setSelection(0, range.end.offset);
            }
        }
    }

    public void deselect() {
        this.deselectSelectedParts();
        this.deselectSelectionRange();
    }

    protected void deselectSelectedParts() {
        this.constantSelection.forEach(ep -> ep.setSelected(0));
    }

    protected void deselectSelectionRange() {
        SelectionRange range = this.getSelectionRange();
        if (range != null) {
            range.getSelectedParts().forEach(ep -> ((TextEditPart)ep).setSelection(-1, -1));
        }
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj instanceof SelectionModel) {
            SelectionModel other = (SelectionModel)obj;
            EditPart otherContainer = other.getSelectionContainer();
            SelectionRange otherRange = other.getSelectionRange();
            result = this.constantSelection.equals(other.getSelectedEditParts()) && (this.selectionContainer == otherContainer || this.selectionContainer != null && this.selectionContainer.equals(otherContainer)) && (this.selectionRange == otherRange || this.selectionRange != null && this.selectionRange.equals(otherRange));
        }
        return result;
    }

    public SelectionModel getAppendedSelection(EditPart newPart) {
        ArrayList<EditPart> list = new ArrayList<EditPart>(this.constantSelection);
        list.remove(newPart);
        list.add(newPart);
        return new SelectionModel(this.selectionRange, list, this.selectionContainer);
    }

    public SelectionModel getExcludedSelection(EditPart exclude) {
        ArrayList<EditPart> list = new ArrayList<EditPart>(this.constantSelection);
        list.remove(exclude);
        return new SelectionModel(this.selectionRange, list, this.selectionContainer);
    }

    public EditPart getFocusPart() {
        if (this.constantSelection.isEmpty()) {
            return null;
        }
        return this.constantSelection.get(this.constantSelection.size() - 1);
    }

    public List<EditPart> getSelectedEditParts() {
        return this.constantSelection;
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.constantSelection);
    }

    public EditPart getSelectionContainer() {
        return this.selectionContainer;
    }

    public SelectionRange getSelectionRange() {
        return this.selectionRange;
    }

    public void applySelection(SelectionModel old) {
        if (old == null) {
            this.applySelectedParts();
            this.applySelectionRange();
            return;
        }
        if (!old.getSelectedEditParts().isEmpty()) {
            HashSet<EditPart> editparts = new HashSet<EditPart>(this.constantSelection);
            old.getSelectedEditParts().stream().filter(part -> !editparts.contains(part)).forEach(part -> part.setSelected(0));
        }
        this.applySelectedParts();
        old.deselectSelectionRange();
        this.applySelectionRange();
    }

    public boolean isTextSelected() {
        return this.selectionRange != null;
    }
}

