/*******************************************************************************
 * Copyright (c) 2004, 2023 IBM Corporation and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.gef.examples.text.figures;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

/**
 * @since 3.1
 */
public class BulletBorder extends ListItemBorder {

	private static final String BULLET = " \u25cf "; //$NON-NLS-1$

	@Override
	public Insets getInsets(IFigure figure) {
		FigureUtilities.getTextExtents(BULLET, figure.getFont(), Dimension.SINGLETON);
		return new Insets(0, Dimension.SINGLETON.width, 0, 0);
	}

	@Override
	public void paintBorder(IFigure figure, Graphics graphics, Insets insets) {
		Rectangle r = getPaintRectangle(figure, insets);
		graphics.drawString(BULLET, r.x, r.y);
	}

}
