/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.timers;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelForeground;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.cdt.examples.dsf.DsfExamplesPlugin;
import org.eclipse.cdt.examples.dsf.timers.TimerService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.swt.graphics.RGB;

class TimersVMNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementPropertiesProvider {
    private static final String PROP_TIMER_NUMBER = "alarmNumber";
    private static final String PROP_TIMER_VALUE = "alarmTriggerValue";
    private static final PropertiesBasedLabelProvider fgLabelProvider = new PropertiesBasedLabelProvider();

    static {
        LabelColumnInfo idCol = new LabelColumnInfo(new LabelAttribute[]{new LabelText("Timer #{0}", new String[]{PROP_TIMER_NUMBER}), new LabelForeground(new RGB(0, 0, 255)), new LabelImage(DsfExamplesPlugin.getDefault().getImageRegistry().getDescriptor("icons/timer.gif"))});
        fgLabelProvider.setColumnInfo("org.eclipse.cdt.examples.dsf.TIMER_COLUMN_PRESENTATION_ID.COL_ID", idCol);
        LabelColumnInfo valueCol = new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0}", new String[]{PROP_TIMER_VALUE})});
        fgLabelProvider.setColumnInfo("org.eclipse.cdt.examples.dsf.TIMER_COLUMN_PRESENTATION_ID.COL_VALUE", valueCol);
    }

    public TimersVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, TimerService.TimerDMContext.class);
    }

    public String toString() {
        return "TimersVMNode(" + this.getSession().getId() + ")";
    }

    public void update(ILabelUpdate[] updates) {
        fgLabelProvider.update(updates);
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        TimerService timerService = (TimerService)((Object)this.getServicesTracker().getService(TimerService.class, null));
        if (timerService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        TimerService.TimerDMContext[] timers = timerService.getTimers();
        this.fillUpdateWithVMCs(update, (IDMContext[])timers);
        update.done();
    }

    /*
     * Unable to fully structure code
     */
    public void update(final IPropertiesUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
                        int n = updates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
                            TimersVMNode.this.updatePropertiesInSessionThread(update);
                            ++n2;
                        }
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException e) {
                var6_3 = updates;
                var5_4 = updates.length;
                var4_5 = 0;
                ** while (var4_5 < var5_4)
            }
lbl-1000:
            // 1 sources

            {
                update = var6_3[var4_5];
                this.handleFailedUpdate((IViewerUpdate)update);
                ++var4_5;
                continue;
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession#getExecutor")
    private void updatePropertiesInSessionThread(IPropertiesUpdate update) {
        TimerService.TimerDMContext dmc = (TimerService.TimerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), TimerService.TimerDMContext.class);
        TimerService timerService = (TimerService)((Object)this.getServicesTracker().getService(TimerService.class, null));
        if (dmc == null || timerService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        int value = timerService.getTimerValue(dmc);
        if (value == -1) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        update.setProperty(PROP_TIMER_NUMBER, (Object)dmc.getTimerNumber());
        update.setProperty(PROP_TIMER_VALUE, (Object)value);
        update.done();
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof TimerService.TimerTickDMEvent) {
            return 2048;
        }
        if (e instanceof TimerService.TimersChangedEvent) {
            return 1024;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof TimerService.TimerTickDMEvent) {
            parentDelta.addNode((Object)this.createVMContext(((TimerService.TimerTickDMEvent)((Object)e)).getDMContext()), 2048);
        } else if (e instanceof TimerService.TimersChangedEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        requestMonitor.done();
    }
}

