/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.pda.ui.viewmodel.launch;

import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractThreadVMNode;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.examples.dsf.pda.service.PDAThreadDMContext;
import org.eclipse.cdt.examples.dsf.pda.ui.PDAUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.ui.IMemento;

public class PDAThreadsVMNode
extends AbstractThreadVMNode
implements IElementMementoProvider {
    private static final String MEMENTO_NAME = "THREAD_MEMENTO_NAME";

    public PDAThreadsVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public String toString() {
        return "PDAThreadVMNode(" + this.getSession().getId() + ")";
    }

    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            PDAThreadDMContext dmc = (PDAThreadDMContext)this.findDmcInPath(updates[i].getViewerInput(), updates[i].getElementPath(), PDAThreadDMContext.class);
            if (dmc != null) {
                updates[i].setProperty("id", (Object)Integer.toString(dmc.getID()));
            } else {
                updates[i].setStatus((IStatus)new Status(4, PDAUIPlugin.PLUGIN_ID, 10002, "Invalid context", null));
            }
            ++i;
        }
        super.updatePropertiesInSessionThread(updates);
    }

    private String produceThreadElementName(String viewName, PDAThreadDMContext execCtx) {
        return "Thread." + execCtx.getID();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString(MEMENTO_NAME);
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof PDAThreadDMContext) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (PDAThreadDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof PDAThreadDMContext) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (PDAThreadDMContext)dmc);
                memento.putString(MEMENTO_NAME, elementName);
            }
            request.done();
            ++n2;
        }
    }
}

