/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.server.SystemServiceManager;

public class MemoryManager {
    private Object mbean;
    private static MemoryManager _instance;
    private DataStore _dataStore;

    private MemoryManager(DataStore dataStore) {
        this.init();
        this._dataStore = dataStore;
    }

    public static MemoryManager getInstance(DataStore dataStore) {
        if (_instance == null) {
            _instance = new MemoryManager(dataStore);
        }
        return _instance;
    }

    private void init() {
        String thresholdString = System.getProperty("search.threshold");
        double threshold = 0.8;
        if (thresholdString != null && thresholdString.length() > 0) {
            threshold = (double)Integer.parseInt(thresholdString) / 100.0;
        }
        try {
            Class<?> factoryClass = Class.forName("java.lang.management.ManagementFactory");
            Method method = factoryClass.getDeclaredMethod("getMemoryPoolMXBeans", new Class[0]);
            List list = (List)method.invoke(null, null);
            int i = 0;
            while (i < list.size()) {
                Object mbObj = list.get(i);
                Class<?> mbClass = mbObj.getClass();
                Method getSupportedMethod = mbClass.getDeclaredMethod("isUsageThresholdSupported", new Class[0]);
                getSupportedMethod.setAccessible(true);
                Boolean usageThresholdSupported = (Boolean)getSupportedMethod.invoke(mbObj, null);
                if (usageThresholdSupported.booleanValue()) {
                    Method getTypeMethod = mbClass.getDeclaredMethod("getType", new Class[0]);
                    getTypeMethod.setAccessible(true);
                    Object typeObj = getTypeMethod.invoke(mbObj, null);
                    Class<?> memoryType = Class.forName("java.lang.management.MemoryType");
                    Field field = memoryType.getField("HEAP");
                    Object fieldObj = field.get(typeObj);
                    if (fieldObj.equals(typeObj)) {
                        Method getUsageMethod = mbClass.getDeclaredMethod("getUsage", new Class[0]);
                        getUsageMethod.setAccessible(true);
                        Object usageObj = getUsageMethod.invoke(mbObj, null);
                        Class<?> usageClass = usageObj.getClass();
                        Method getMaxMethod = usageClass.getDeclaredMethod("getMax", new Class[0]);
                        getMaxMethod.setAccessible(true);
                        Long maxObj = (Long)getMaxMethod.invoke(usageObj, null);
                        Method setThresholdMethod = mbClass.getDeclaredMethod("setUsageThreshold", Long.TYPE);
                        Object[] args = new Object[]{new Long((long)((double)maxObj.longValue() * threshold))};
                        setThresholdMethod.setAccessible(true);
                        setThresholdMethod.invoke(mbObj, args);
                        this.mbean = mbObj;
                        break;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public boolean isThresholdExceeded() {
        if (this.mbean != null) {
            try {
                Method method = this.mbean.getClass().getMethod("isUsageThresholdExceeded", new Class[0]);
                Boolean exceeded = (Boolean)method.invoke(this.mbean, null);
                return exceeded;
            }
            catch (Exception exception) {
                return false;
            }
        }
        Runtime runtime = Runtime.getRuntime();
        long freeMem = runtime.freeMemory();
        return freeMem < 10000L;
    }

    public void checkAndClearupMemory() {
        int count = 0;
        while (count < 5 && this.isThresholdExceeded()) {
            System.gc();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            ++count;
            this._dataStore.trace("CLEAN free mem=" + Runtime.getRuntime().freeMemory());
        }
        if (count == 5) {
            this._dataStore.trace("Out of memory - shutting down");
            Exception e = new Exception();
            this._dataStore.trace(e);
            if (SystemServiceManager.getInstance().getSystemService() == null) {
                System.exit(-1);
            }
        }
    }
}

