/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterContainerReference;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolWrapperInformation;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ILabeledObject;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISubSystemConfigurator;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.references.IRSEBaseReferencingObject;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.core.subsystems.RemoteServerLauncher;
import org.eclipse.rse.core.subsystems.ServerLaunchType;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.core.filters.SystemFilterPoolManager;
import org.eclipse.rse.internal.core.filters.SystemFilterPoolWrapperInformation;
import org.eclipse.rse.internal.core.filters.SystemFilterStartHere;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.ui.SystemPropertyResources;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.services.IService;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.messages.SystemMessageDialog;

public abstract class SubSystemConfiguration
implements ISubSystemConfiguration {
    private Hashtable subSystemsRestoredFlags = new Hashtable();
    private ISubSystemConfigurationProxy proxy = null;
    private ISubSystem[] subsystems = null;
    private Hashtable subsystemsByConnection = new Hashtable();
    private boolean allSubSystemsRestored = false;
    private static final ISubSystem[] EMPTY_SUBSYSTEM_ARRAY = new ISubSystem[0];
    protected ISystemFilterPoolManager[] filterPoolManagers = null;
    protected Hashtable filterPoolManagersPerProfile = new Hashtable();
    private String translatedFilterType = null;
    private static Hashtable brokenReferenceWarningsIssued = new Hashtable();
    protected IHost currentlySelectedConnection;
    protected Object[] currentlySelected;
    protected static IHost currentlyProcessingConnection;
    protected static SubSystemConfiguration currentlyProcessingSubSystemConfiguration;
    protected List subSystemList = new ArrayList();
    protected List filterPoolManagerList = new ArrayList();

    public SubSystemConfiguration() {
        SystemBasePlugin.logDebugMessage(this.getClass().getName(), "STARTED SSFACTORY");
    }

    public void reset() {
        this.subSystemsRestoredFlags = new Hashtable();
        this.subsystems = null;
        this.subsystemsByConnection = new Hashtable();
        this.allSubSystemsRestored = false;
        this.filterPoolManagersPerProfile = new Hashtable();
        this.filterPoolManagers = null;
        brokenReferenceWarningsIssued = new Hashtable();
    }

    public boolean supportsEncoding(IHost host) {
        boolean rv = true;
        if (host.getSystemType().testProperty("supportsEncoding", false)) {
            rv = false;
        }
        return rv;
    }

    public boolean supportsSubSystemConnect() {
        return true;
    }

    public boolean isPortEditable() {
        return true;
    }

    public boolean supportsCommands() {
        return false;
    }

    public boolean supportsProperties() {
        return false;
    }

    public boolean supportsFilters() {
        return true;
    }

    public boolean supportsFilterChildren() {
        return true;
    }

    public boolean supportsFilterCaching() {
        return true;
    }

    public boolean supportsMultipleFilterStrings() {
        return true;
    }

    public boolean supportsNestedFilters() {
        return this.supportsFilters();
    }

    public boolean supportsQuickFilters() {
        return this.supportsFilters();
    }

    public boolean supportsDropInFilters() {
        return false;
    }

    public boolean providesCustomDropInFilters() {
        return false;
    }

    public boolean supportsFileTypes() {
        return false;
    }

    public boolean supportsMultiStringFilters() {
        return true;
    }

    public boolean supportsFilterStringExport() {
        return true;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean supportsDuplicateFilterStrings() {
        return false;
    }

    public boolean supportsTargets() {
        return false;
    }

    public boolean supportsServerLaunchProperties(IHost host) {
        return false;
    }

    public boolean supportsServerLaunchType(ServerLaunchType serverLaunchType) {
        return true;
    }

    public boolean isFactoryFor(Class subSystemType) {
        return false;
    }

    public boolean showFilterPools() {
        return SystemPreferencesManager.getShowFilterPools();
    }

    public void setShowFilterPools(boolean show) {
        ISubSystem[] subsystems = this.getSubSystems(false);
        int idx = 0;
        while (idx < subsystems.length) {
            ISubSystem ss = subsystems[idx];
            RSECorePlugin.getTheSystemRegistry().fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)ss, 95, (Object)ss));
            ++idx;
        }
    }

    public void setSubSystemConfigurationProxy(ISubSystemConfigurationProxy proxy) {
        this.proxy = proxy;
    }

    public ISubSystemConfigurationProxy getSubSystemConfigurationProxy() {
        return this.proxy;
    }

    public String getVendor() {
        return this.proxy.getVendor();
    }

    public String getName() {
        return this.proxy.getName();
    }

    public String getDescription() {
        return this.proxy.getDescription();
    }

    public String getId() {
        return this.proxy.getId();
    }

    public String getCategory() {
        return this.proxy.getCategory();
    }

    public IRSESystemType[] getSystemTypes() {
        return this.proxy.getSystemTypes();
    }

    public ISystemProfile getSystemProfile(String name) {
        return SystemProfileManager.getDefault().getSystemProfile(name);
    }

    protected ISystemProfile getSystemProfile(ISystemFilterPoolManager poolMgr) {
        return this.getSystemProfile(this.getSystemProfileName(poolMgr));
    }

    public ISystemProfile getSystemProfile(ISystemFilterPool pool) {
        return this.getSystemProfile(pool.getSystemFilterPoolManager());
    }

    protected ISystemProfile getSystemProfile(ISystemFilter filter) {
        return this.getSystemProfile(filter.getParentFilterPool());
    }

    public void deletingSystemProfile(ISystemProfile profile) {
        this.deleteFilterPoolManager(profile);
    }

    public void changingSystemProfileActiveStatus(ISystemProfile profile, boolean newStatus) {
        if (newStatus) {
            this.allSubSystemsRestored = false;
        }
    }

    public void renameSubSystemProfile(String oldProfileName, String newProfileName) {
        ISystemProfile profile = this.getSystemProfile(newProfileName);
        this.renameFilterPoolManager(profile);
        ISystemFilterPool defaultPoolForThisProfile = this.getDefaultFilterPool(profile, oldProfileName);
        if (defaultPoolForThisProfile != null) {
            try {
                this.getFilterPoolManager(profile).renameSystemFilterPool(defaultPoolForThisProfile, SubSystemConfiguration.getDefaultFilterPoolName(newProfileName, this.getId()));
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Unexpected error renaming default filter pool " + SubSystemConfiguration.getDefaultFilterPoolName(newProfileName, this.getId()), exc);
                System.out.println("Unexpected error renaming default filter pool " + SubSystemConfiguration.getDefaultFilterPoolName(newProfileName, this.getId()) + ": " + exc);
            }
        }
    }

    public void renameSubSystemProfile(ISubSystem subsystem, String oldProfileName, String newProfileName) {
        subsystem.renamingProfile(oldProfileName, newProfileName);
        ISystemFilterPoolReferenceManager sfprm = subsystem.getSystemFilterPoolReferenceManager();
        if (sfprm != null) {
            sfprm.regenerateReferencedSystemFilterPoolNames();
        }
        try {
            this.saveSubSystem(subsystem);
        }
        catch (Exception exc) {
            RSECorePlugin.getDefault().getLogger().logError("Unexpected error saving subsystem.", (Throwable)exc);
        }
    }

    public void preTestRenameSubSystemProfile(String oldProfileName) throws Exception {
        ISystemFilterPool defaultPoolForThisProfile;
        ISystemProfile profile = this.getSystemProfile(oldProfileName);
        if (profile.isDefaultPrivate() && (defaultPoolForThisProfile = this.getDefaultFilterPool(profile, oldProfileName)) != null) {
            this.getFilterPoolManager(profile).preTestRenameFilterPool(defaultPoolForThisProfile);
        }
    }

    public ISystemFilterPool getDefaultFilterPool(ISystemProfile profile, String oldProfileName) {
        ISystemFilterPool pool = null;
        ISystemFilterPoolManager mgr = this.getFilterPoolManager(profile);
        ISystemFilterPool[] pools = mgr.getSystemFilterPools();
        if (pools != null) {
            int idx = 0;
            while (pool == null && idx < pools.length) {
                if (pools[idx].isDefault() && pools[idx].getName().equals(SubSystemConfiguration.getDefaultFilterPoolName(oldProfileName, this.getId()))) {
                    pool = pools[idx];
                }
                ++idx;
            }
            if (pool == null) {
                pool = mgr.getFirstDefaultSystemFilterPool();
            }
        }
        return pool;
    }

    public void renameSubSystemsByConnection(IHost conn, String newConnectionName) {
        ISubSystem[] subsystems = this.getSubSystems(conn, true);
        if (subsystems != null) {
            int idx = 0;
            while (idx < subsystems.length) {
                subsystems[idx].renamingConnection(newConnectionName);
                ++idx;
            }
        } else {
            SystemBasePlugin.logInfo("renameSubSystemsByConnection for " + conn.getAliasName() + " has no subsystems");
        }
        try {
            this.saveSubSystems(conn);
        }
        catch (Exception exception) {}
    }

    public void deleteSubSystemsByConnection(IHost conn) {
        ISubSystem[] subsystems = conn.getSubSystems();
        int idx = 0;
        while (idx < subsystems.length) {
            if (subsystems[idx].isConnected()) {
                try {
                    subsystems[idx].disconnect();
                }
                catch (Exception exception) {}
            }
            subsystems[idx].deletingConnection();
            this.deleteSubSystem(subsystems[idx]);
            ++idx;
        }
        this.invalidateSubSystemCache(conn);
        try {
            this.saveSubSystems(conn);
        }
        catch (Exception exception) {}
    }

    protected void invalidateSubSystemCache(IHost conn) {
        this.subsystems = null;
        if (conn != null) {
            this.subsystemsByConnection.remove(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISubSystem[] getSubSystems(boolean force) {
        List subSysList;
        if (force && !this.allSubSystemsRestored) {
            IHost[] allActiveConnections = RSECorePlugin.getTheSystemRegistry().getHosts();
            if (allActiveConnections != null) {
                int idx = 0;
                while (idx < allActiveConnections.length) {
                    if (this.proxy.appliesToSystemType(allActiveConnections[idx].getSystemType())) {
                        this.getSubSystems(allActiveConnections[idx], force);
                    }
                    ++idx;
                }
            }
            this.allSubSystemsRestored = true;
            this.subsystems = null;
        }
        ISubSystem[] result = this.subsystems;
        List list = subSysList = this.getSubSystemList();
        synchronized (list) {
            if (result == null || result.length != subSysList.size()) {
                if (SystemProfileManager.getDefault().getSize() <= 0) {
                    return EMPTY_SUBSYSTEM_ARRAY;
                }
                this.subsystems = result = subSysList.toArray(new ISubSystem[subSysList.size()]);
            }
        }
        return result;
    }

    public ISubSystem[] getSubSystems(IHost conn, boolean force) {
        ISubSystem[] subsystemArray = (ISubSystem[])this.subsystemsByConnection.get(conn);
        if (subsystemArray == null || subsystemArray.length == 0) {
            boolean subsystemsRestored = this.subSystemsHaveBeenRestored(conn);
            if (!subsystemsRestored && force) {
                SystemBasePlugin.logInfo("in SubSystemConfiguration.getSubSystems(conn, force) - not restored");
            } else {
                if (!subsystemsRestored && !force) {
                    SystemBasePlugin.logInfo("in SubSystemConfiguration.getSubSytems(conn, force) - returning empty array");
                    return EMPTY_SUBSYSTEM_ARRAY;
                }
                subsystemArray = this.internalGetSubSystems(conn);
                this.subsystemsByConnection.put(conn, subsystemArray);
            }
        }
        return subsystemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISubSystem[] internalGetSubSystems(IHost conn) {
        List subSysList;
        List list = subSysList = this.getSubSystemList();
        synchronized (list) {
            ArrayList<ISubSystem> result = new ArrayList<ISubSystem>();
            Iterator i = subSysList.iterator();
            while (i.hasNext()) {
                ISubSystem subsys = (ISubSystem)i.next();
                if (subsys.getHost() != conn) continue;
                result.add(subsys);
            }
            return result.toArray(new ISubSystem[result.size()]);
        }
    }

    public ISubSystem[] getSubSystems(ISystemProfile profile) {
        ISubSystem[] allSubSystems = this.getSubSystems(true);
        ArrayList<ISubSystem> l = new ArrayList<ISubSystem>();
        int idx = 0;
        while (idx < allSubSystems.length) {
            ISubSystem ss = allSubSystems[idx];
            if (ss.getSystemProfile() == profile) {
                l.add(ss);
            }
            ++idx;
        }
        ISubSystem[] subsystems = l.toArray(new ISubSystem[l.size()]);
        return subsystems;
    }

    public ISubSystem[] getSubSystems(ISystemFilterPool pool) {
        ISubSystem[] allSubSystems = this.getSubSystems(false);
        ArrayList<ISubSystem> l = new ArrayList<ISubSystem>();
        int idx = 0;
        while (idx < allSubSystems.length) {
            ISystemFilterPoolReferenceManager mgr = allSubSystems[idx].getSystemFilterPoolReferenceManager();
            if (mgr != null && mgr.isSystemFilterPoolReferenced(pool)) {
                l.add(allSubSystems[idx]);
            }
            ++idx;
        }
        ISubSystem[] subsystems = l.toArray(new ISubSystem[l.size()]);
        return subsystems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubSystem(ISubSystem subsys) {
        List subSysList;
        List list = subSysList = this.getSubSystemList();
        synchronized (list) {
            subSysList.add(subsys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubSystem(ISubSystem subsys) {
        List subSysList;
        List list = subSysList = this.getSubSystemList();
        synchronized (list) {
            subSysList.remove(subsys);
        }
    }

    public ISubSystem createSubSystem(IHost conn, boolean creatingConnection, ISubSystemConfigurator[] configurators) {
        this.invalidateSubSystemCache(conn);
        if (creatingConnection) {
            if (this.subSystemsRestoredFlags == null) {
                this.reset();
            }
            this.subSystemsRestoredFlags.put(conn, Boolean.TRUE);
        }
        ISubSystem subsys = null;
        try {
            subsys = this.createSubSystemInternal(conn);
        }
        catch (RuntimeException e) {
            RSECorePlugin.getDefault().getLogger().logError("Error creating subsystem", (Throwable)e);
        }
        if (subsys != null) {
            IServerLauncherProperties sl;
            this.internalInitializeNewSubSystem(subsys, conn);
            if (this.supportsFilters()) {
                ISystemFilterPoolReferenceManager fprMgr = SystemFilterStartHere.getInstance().createSystemFilterPoolReferenceManager((ISystemFilterPoolReferenceManagerProvider)subsys, (ISystemFilterPoolManagerProvider)this, subsys.getName());
                subsys.setFilterPoolReferenceManager(fprMgr);
                ISystemFilterPoolManager defaultFilterPoolManager = this.getFilterPoolManager(conn.getSystemProfile());
                fprMgr.setDefaultSystemFilterPoolManager(defaultFilterPoolManager);
            }
            IConnectorService connectorService = subsys.getConnectorService();
            if (this.supportsServerLaunchProperties(conn) && (sl = connectorService.getRemoteServerLauncherProperties()) == null && (sl = this.createServerLauncher(connectorService)) != null) {
                connectorService.setRemoteServerLauncherProperties(sl);
            }
            this.initializeSubSystem(subsys, configurators);
            try {
                this.saveSubSystem(subsys);
                RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(1, 4, (Object)subsys, null);
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Error saving new subsystem " + subsys.getName(), exc);
            }
            this.addSubSystem(subsys);
        }
        return subsys;
    }

    public ISubSystem cloneSubSystem(ISubSystem oldSubsystem, IHost newConnection, boolean copyProfileOperation) throws Exception {
        Exception lastExc = null;
        this.invalidateSubSystemCache(newConnection);
        this.subSystemsRestoredFlags.put(newConnection, Boolean.TRUE);
        ISubSystem subsys = this.createSubSystemInternal(newConnection);
        if (subsys != null) {
            IServerLauncherProperties newSL;
            this.internalInitializeNewSubSystem(subsys, newConnection);
            subsys.setName(oldSubsystem.getName());
            oldSubsystem.clonePropertySets((IPropertySetContainer)subsys);
            subsys.setHidden(oldSubsystem.isHidden());
            IConnectorService oldConnectorService = oldSubsystem.getConnectorService();
            IConnectorService newConnectorService = subsys.getConnectorService();
            if (oldConnectorService != null && newConnectorService != null) {
                newConnectorService.setPort(oldConnectorService.getPort());
                newConnectorService.setUserId(oldConnectorService.getUserId());
                newConnectorService.setIsUsingSSL(oldConnectorService.isUsingSSL());
            }
            IServerLauncherProperties sl = null;
            if (oldConnectorService != null) {
                sl = oldConnectorService.getRemoteServerLauncherProperties();
            }
            if (sl != null && this.supportsServerLaunchProperties(newConnection) && (newSL = this.createServerLauncher(newConnectorService)) != null && newConnectorService != null) {
                newConnectorService.setRemoteServerLauncherProperties(sl.cloneServerLauncher(newSL));
            }
            this.copySubSystemData(oldSubsystem, subsys);
            if (this.supportsFilters()) {
                ISystemFilterPoolReferenceManager newRefMgr = SystemFilterStartHere.getInstance().createSystemFilterPoolReferenceManager((ISystemFilterPoolReferenceManagerProvider)subsys, (ISystemFilterPoolManagerProvider)this, subsys.getName());
                ISystemFilterPoolManager defaultFilterPoolManager = null;
                defaultFilterPoolManager = copyProfileOperation ? this.getFilterPoolManager(newConnection.getSystemProfile()) : oldSubsystem.getFilterPoolReferenceManager().getDefaultSystemFilterPoolManager();
                newRefMgr.setDefaultSystemFilterPoolManager(defaultFilterPoolManager);
                subsys.setFilterPoolReferenceManager(newRefMgr);
                ISystemFilterPoolReferenceManager oldRefMgr = oldSubsystem.getSystemFilterPoolReferenceManager();
                newRefMgr.setProviderEventNotification(false);
                ISystemFilterPoolReference[] oldReferences = oldRefMgr.getSystemFilterPoolReferences();
                String oldSubSystemProfileName = oldSubsystem.getSystemProfileName();
                if (oldReferences != null && oldReferences.length > 0) {
                    int idx = 0;
                    while (idx < oldReferences.length) {
                        ISystemFilterPoolReference poolRef = oldReferences[idx];
                        ISystemFilterPool pool = poolRef.getReferencedFilterPool();
                        if (pool != null) {
                            if (!copyProfileOperation) {
                                newRefMgr.addReferenceToSystemFilterPool(pool);
                            } else {
                                ISystemFilterPoolManager poolMgr = pool.getSystemFilterPoolManager();
                                String poolProfileName = this.getSystemProfileName(poolMgr);
                                if (poolProfileName.equals(oldSubSystemProfileName)) {
                                    ISystemFilterPoolManager newPoolMgr = this.getFilterPoolManager(newConnection.getSystemProfile());
                                    ISystemFilterPool newPool = newPoolMgr.getSystemFilterPool(pool.getName());
                                    newRefMgr.addReferenceToSystemFilterPool(newPool);
                                } else {
                                    newRefMgr.addReferenceToSystemFilterPool(pool);
                                }
                            }
                        }
                        ++idx;
                    }
                }
                newRefMgr.setProviderEventNotification(true);
            }
            try {
                this.saveSubSystem(subsys);
                RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(1, 4, (Object)subsys, null);
            }
            catch (Exception exc) {
                lastExc = exc;
                SystemBasePlugin.logError("Error saving cloned subsystem " + subsys.getName(), exc);
            }
            this.addSubSystem(subsys);
            if (lastExc != null) {
                throw lastExc;
            }
        }
        return subsys;
    }

    private void internalInitializeNewSubSystem(ISubSystem subsys, IHost conn) {
        subsys.setSubSystemConfiguration((ISubSystemConfiguration)this);
        subsys.setHost(conn);
        subsys.setName(this.internalGetSubSystemName(subsys));
        subsys.setConfigurationId(this.getId());
    }

    protected String internalGetSubSystemName(ISubSystem subsys) {
        return this.getName();
    }

    public abstract ISubSystem createSubSystemInternal(IHost var1);

    protected void initializeSubSystem(ISubSystem ss, ISubSystemConfigurator[] configurators) {
        ISystemFilterPool pool;
        if (this.supportsFilters() && (pool = this.getDefaultSystemFilterPool(ss)) != null) {
            ISystemFilterPoolReferenceManager refMgr = ss.getSystemFilterPoolReferenceManager();
            refMgr.setProviderEventNotification(false);
            refMgr.addReferenceToSystemFilterPool(pool);
            refMgr.setProviderEventNotification(true);
        }
        if (configurators != null) {
            ISubSystemConfigurator ourPage = null;
            int idx = 0;
            while (ourPage == null && idx < configurators.length) {
                ourPage = configurators[idx];
                ourPage.applyValues(ss);
                ++idx;
            }
        }
    }

    protected void copySubSystemData(ISubSystem oldSubSystem, ISubSystem newSubSystem) {
    }

    public void updateSubSystem(ISubSystem subsystem, boolean updateUserId, String userId, boolean updatePort, int port) {
        if (!this.needsUpdate(subsystem, updateUserId, userId, updatePort, port)) {
            return;
        }
        IConnectorService connectorService = subsystem.getConnectorService();
        if (connectorService != null) {
            if (updateUserId) {
                if (userId != null && userId.trim().length() > 0) {
                    connectorService.setUserId(userId);
                } else {
                    connectorService.setUserId(null);
                }
            }
            if (updatePort) {
                connectorService.setPort(port);
            }
            if (connectorService.isDirty()) {
                this.setDirty(true);
                subsystem.setDirty(true);
            }
        }
        this.fireEvent(subsystem, 86, subsystem.getHost());
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(4, 4, (Object)subsystem, null);
    }

    public void setSubSystemPort(ISubSystem subsystem, int port) {
        this.updateSubSystem(subsystem, false, null, true, port);
    }

    public void setSubSystemUserId(ISubSystem subsystem, String userId) {
        this.updateSubSystem(subsystem, true, userId, false, 0);
    }

    protected boolean needsUpdate(ISubSystem subsystem, boolean updateUserId, String userId, boolean updatePort, int port) {
        IConnectorService connectorService = subsystem.getConnectorService();
        if (connectorService != null) {
            if (updatePort) {
                int oldPort = connectorService.getPort();
                boolean bl = updatePort = oldPort != port;
            }
            if (!updatePort && updateUserId) {
                if (userId == null || userId.trim().length() == 0) {
                    updateUserId = connectorService.getUserId() != null;
                } else {
                    String oldUserId = connectorService.getUserId();
                    if (oldUserId != null) {
                        if (subsystem.forceUserIdToUpperCase()) {
                            updateUserId = !userId.equalsIgnoreCase(oldUserId);
                        } else {
                            boolean bl = updateUserId = !userId.equals(oldUserId);
                        }
                    }
                }
            }
        }
        return updatePort || updateUserId;
    }

    public boolean isSubSystemsDeletable() {
        return false;
    }

    public boolean deleteSubSystem(ISubSystem subsystem) {
        ISystemFilterPoolReference[] fpRefs;
        if (subsystem.isConnected()) {
            try {
                subsystem.disconnect();
            }
            catch (Exception exception) {}
        }
        this.removeSubSystem(subsystem);
        ISystemFilterPoolReferenceManager fpRefMgr = subsystem.getSystemFilterPoolReferenceManager();
        if (fpRefMgr != null && (fpRefs = fpRefMgr.getSystemFilterPoolReferences()) != null) {
            int idx = 0;
            while (idx < fpRefs.length) {
                fpRefs[idx].removeReference();
                ++idx;
            }
        }
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(2, 4, (Object)subsystem, null);
        return true;
    }

    public void renameSubSystem(ISubSystem subsystem, String newName) {
        subsystem.setName(newName);
        try {
            subsystem.commit();
        }
        catch (Exception exception) {}
    }

    protected ISystemFilterPoolWrapperInformation getNewFilterWizardPoolWrapperInformation() {
        return new SystemFilterPoolWrapperInformation(SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_LABEL, SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_TOOLTIP, SystemResources.RESID_NEWFILTER_PAGE2_PROFILE_VERBIAGE);
    }

    public void disconnectAllSubSystems() throws Exception {
        ISubSystem[] subsystems = this.getSubSystems(false);
        if (subsystems != null) {
            int idx = 0;
            while (idx < subsystems.length) {
                ISubSystem ss = subsystems[idx];
                if (ss.isConnected()) {
                    try {
                        ss.getConnectorService().disconnect((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception exception) {}
                }
                ++idx;
            }
        }
    }

    protected ISystemFilterPool createDefaultFilterPool(ISystemFilterPoolManager mgr) {
        ISystemFilterPool pool = null;
        try {
            pool = mgr.createSystemFilterPool(SubSystemConfiguration.getDefaultFilterPoolName(mgr.getName(), this.getId()), true);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Error creating default filter pool in default subsystem configuration", exc);
        }
        return pool;
    }

    protected boolean isUserPrivateProfile(ISystemFilterPoolManager mgr) {
        ISystemProfile profile = mgr.getSystemProfile();
        boolean result = profile.isDefaultPrivate() || mgr.getName().equalsIgnoreCase("private");
        return result;
    }

    public ISystemFilterPool getDefaultSystemFilterPool(ISubSystem subsys) {
        ISystemFilterPool pool = this.getDefaultSystemFilterPool(subsys.getSystemProfile());
        return pool;
    }

    public ISystemFilterPool getDefaultSystemFilterPool(ISystemProfile profile) {
        ISystemFilterPool pool = null;
        ISystemFilterPoolManager mgr = this.getFilterPoolManager(profile);
        pool = mgr.getFirstDefaultSystemFilterPool();
        return pool;
    }

    public void invalidateFilterCache() {
        this.filterPoolManagers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISystemFilterPoolManager[] getFilterPoolManagers() {
        List fpManagers;
        List list = fpManagers = this.getFilterPoolManagerList();
        synchronized (list) {
            if (this.filterPoolManagers == null || this.filterPoolManagers.length != fpManagers.size()) {
                this.filterPoolManagers = fpManagers.toArray(new ISystemFilterPoolManager[fpManagers.size()]);
            }
        }
        return this.filterPoolManagers;
    }

    public ISystemFilterPoolManager[] getActiveFilterPoolManagers() {
        ISystemProfile[] activeProfiles = RSECorePlugin.getTheSystemRegistry().getActiveSystemProfiles();
        ISystemFilterPoolManager[] activeManagers = new ISystemFilterPoolManager[activeProfiles.length];
        int idx = 0;
        while (idx < activeProfiles.length) {
            activeManagers[idx] = this.getFilterPoolManager(activeProfiles[idx]);
            ++idx;
        }
        return activeManagers;
    }

    public ISystemFilterPoolManager getFilterPoolManager(ISystemProfile profile) {
        return this.getFilterPoolManager(profile, false);
    }

    public ISystemFilterPoolManager getFilterPoolManager(ISystemProfile profile, boolean force) {
        ISystemFilterPoolManager mgr = (ISystemFilterPoolManager)this.filterPoolManagersPerProfile.get(profile);
        if (mgr == null) {
            try {
                Logger logger = RSECorePlugin.getDefault().getLogger();
                String managerName = this.getFilterPoolManagerName(profile);
                boolean supportsNested = this.supportsNestedFilters();
                mgr = SystemFilterPoolManager.createSystemFilterPoolManager((ISystemProfile)profile, (Logger)logger, (ISystemFilterPoolManagerProvider)this, (String)managerName, (boolean)supportsNested);
                mgr.setSingleFilterStringOnly(!this.supportsMultipleFilterStrings());
                mgr.setWasRestored(false);
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Restore/Creation of SystemFilterPoolManager " + this.getFilterPoolManagerName(profile) + " failed!", exc);
                SystemMessageDialog.displayExceptionMessage(null, exc);
                return null;
            }
            this.addFilterPoolManager(profile, mgr);
        }
        boolean initialized = mgr.wasRestored();
        if (force && !initialized) {
            String defaultPoolName = SubSystemConfiguration.getDefaultFilterPoolName(profile.getName(), this.getId());
            ISystemFilterPool defaultPool = mgr.getSystemFilterPool(defaultPoolName);
            if (defaultPool == null) {
                defaultPool = this.createDefaultFilterPool(mgr);
            }
            if (defaultPool != null) {
                defaultPool.setDefault(true);
                defaultPool.commit();
            }
            if (this.supportsDuplicateFilterStrings()) {
                mgr.setSupportsDuplicateFilterStrings(true);
            }
            if (this.isCaseSensitive()) {
                mgr.setStringsCaseSensitive(true);
            }
            mgr.setWasRestored(true);
        }
        return mgr;
    }

    protected boolean doPostRestoreProcessing(ISystemFilterPoolManager restoredFilterPoolMgr) {
        return false;
    }

    public ISystemFilterPoolManager copyFilterPoolManager(ISystemProfile oldProfile, ISystemProfile newProfile) throws Exception {
        ISystemFilterPoolManager oldMgr = this.getFilterPoolManager(oldProfile);
        ISystemFilterPoolManager mgr = SystemFilterPoolManager.createSystemFilterPoolManager((ISystemProfile)newProfile, (Logger)RSECorePlugin.getDefault().getLogger(), (ISystemFilterPoolManagerProvider)this, (String)this.getFilterPoolManagerName(newProfile), (boolean)this.supportsNestedFilters());
        mgr.setStringsCaseSensitive(oldMgr.areStringsCaseSensitive());
        mgr.setSupportsDuplicateFilterStrings(oldMgr.supportsDuplicateFilterStrings());
        this.addFilterPoolManager(newProfile, mgr);
        oldMgr.copySystemFilterPools(mgr);
        return mgr;
    }

    public ISystemFilterPoolManager getSystemFilterPoolManager(String mgrName) {
        ISystemProfile profile = this.getSystemProfile(mgrName);
        if (profile != null) {
            return this.getFilterPoolManager(profile);
        }
        return null;
    }

    public ISystemFilterPoolManager[] getSystemFilterPoolManagers() {
        return this.getActiveFilterPoolManagers();
    }

    public ISystemFilterPoolManager[] getReferencableSystemFilterPoolManagers(ISystemFilterPoolReferenceManager refMgr) {
        return this.getActiveFilterPoolManagers();
    }

    public ISystemFilterPool getSystemFilterPoolForBrokenReference(ISystemFilterPoolReferenceManager callingRefMgr, String missingPoolMgrName, String missingPoolName) {
        ISubSystem ss;
        ISystemFilterPool match = null;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISystemProfile profile = sr.getSystemProfile(missingPoolMgrName);
        if (profile != null) {
            match = this.getFilterPoolManager(profile).getSystemFilterPool(missingPoolName);
        }
        if (match != null && (ss = (ISubSystem)callingRefMgr.getProvider()).getSystemProfile() != profile) {
            IHost conn = ss.getHost();
            String connectionName = String.valueOf(conn.getSystemProfileName()) + "." + conn.getAliasName();
            String msgTxt = NLS.bind((String)RSECoreMessages.MSG_LOADING_PROFILE_SHOULDBE_ACTIVATED, (Object)missingPoolMgrName, (Object)connectionName);
            SimpleSystemMessage sysMsg = new SimpleSystemMessage("org.eclipse.rse.core", "RSEG1068", 4, msgTxt);
            SystemBasePlugin.logWarning(String.valueOf(sysMsg.getFullMessageID()) + ": " + sysMsg.getLevelOneText());
            if (brokenReferenceWarningsIssued.get(missingPoolMgrName) == null) {
                SystemMessageDialog msgDlg = new SystemMessageDialog(null, (SystemMessage)sysMsg);
                msgDlg.open();
                brokenReferenceWarningsIssued.put(missingPoolMgrName, Boolean.TRUE);
            }
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFilterPoolManager(ISystemProfile profile, ISystemFilterPoolManager mgr) {
        List fpManagers;
        List list = fpManagers = this.getFilterPoolManagerList();
        synchronized (list) {
            this.filterPoolManagersPerProfile.put(profile, mgr);
            fpManagers.add(mgr);
        }
        this.invalidateFilterCache();
    }

    protected ISystemFilterPoolManager getFilterPoolManager(ISystemFilterPool pool) {
        return pool.getSystemFilterPoolManager();
    }

    protected ISystemFilterPoolManager getFilterPoolManager(ISystemFilterContainer poolOrFilter) {
        return poolOrFilter.getSystemFilterPoolManager();
    }

    protected ISystemFilterPoolManager getFilterPoolManager(ISystemFilterContainerReference poolOrFilterReference) {
        return this.getFilterPoolManager(poolOrFilterReference.getReferencedSystemFilterContainer());
    }

    protected ISystemFilterPoolManager getFilterPoolManager(IHost conn) {
        return this.getFilterPoolManager(conn.getSystemProfile());
    }

    protected String getFilterPoolManagerName(ISystemProfile profile) {
        return profile.getName();
    }

    protected String getSystemProfileName(ISystemFilterPoolManager manager) {
        return manager.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteFilterPoolManager(ISystemProfile profile) {
        ISystemFilterPoolManager mgr = (ISystemFilterPoolManager)this.filterPoolManagersPerProfile.get(profile);
        if (mgr != null) {
            List fpManagers;
            mgr.deleteAllSystemFilterPools();
            List list = fpManagers = this.getFilterPoolManagerList();
            synchronized (list) {
                this.filterPoolManagersPerProfile.remove(profile);
                fpManagers.remove(mgr);
            }
            this.invalidateFilterCache();
        }
    }

    public void renameFilterPoolManager(ISystemProfile profile) {
        ISystemFilterPoolManager mgr = (ISystemFilterPoolManager)this.filterPoolManagersPerProfile.get(profile);
        if (mgr != null) {
            mgr.setName(this.getFilterPoolManagerName(profile));
        }
    }

    protected void fireEvent(SystemResourceChangeEvent event) {
        RSECorePlugin.getTheSystemRegistry().fireEvent((ISystemResourceChangeEvent)event);
    }

    protected void fireEvent(Object src, int eventId, Object parent) {
        this.fireEvent(this.createEvent(src, eventId, parent));
    }

    protected void fireEvent(Object[] multiSrc, int eventId, Object parent, int delta) {
        this.fireEvent(this.createEvent(multiSrc, eventId, parent, delta));
    }

    protected SystemResourceChangeEvent createEvent(Object src, int eventId, Object parent) {
        return new SystemResourceChangeEvent(src, eventId, parent);
    }

    protected SystemResourceChangeEvent createEvent(Object[] src, int eventId, Object parent) {
        return new SystemResourceChangeEvent(src, eventId, parent);
    }

    protected SystemResourceChangeEvent createEvent(Object[] src, int eventId, Object parent, int delta) {
        SystemResourceChangeEvent event = new SystemResourceChangeEvent(src, eventId, parent);
        event.setPosition(delta);
        return event;
    }

    protected void fireSubSystemEvent(SystemResourceChangeEvent event, ISubSystem subsystem) {
        event.setGrandParent((Object)subsystem);
        this.fireEvent(event);
    }

    protected void fireSubSystemEvent(SystemResourceChangeEvent event) {
        ISubSystem[] subsystems = this.getSubSystems(false);
        int idx = 0;
        while (idx < subsystems.length) {
            this.fireSubSystemEvent(event, subsystems[idx]);
            ++idx;
        }
    }

    protected void fireSubSystemEvent(SystemResourceChangeEvent event, ISystemProfile profile) {
        String profileName = profile.getName();
        ISubSystem[] allSubSystems = this.getSubSystems(false);
        int idx = 0;
        while (idx < allSubSystems.length) {
            if (allSubSystems[idx].getSystemProfile().getName().equals(profileName)) {
                this.fireSubSystemEvent(event, allSubSystems[idx]);
            }
            ++idx;
        }
    }

    protected void fireSubSystemFilterEvent(int eventId, ISystemFilter filter) {
        SystemResourceChangeEvent event = this.createEvent(filter, eventId, null);
        this.fireSubSystemFilterEvent(event, filter);
    }

    protected void fireSubSystemFilterEvent(int eventId, ISystemFilter[] filters) {
        if (filters.length > 0) {
            SystemResourceChangeEvent event = this.createEvent(filters, eventId, (Object)null);
            this.fireSubSystemFilterEvent(event, filters[0]);
        }
    }

    protected void fireSubSystemFilterEvent(SystemResourceChangeEvent event, ISystemFilter filter) {
        ISystemFilterPool pool = filter.getParentFilterPool();
        ISubSystem[] subsystems = this.getSubSystems(pool);
        if (subsystems != null && subsystems.length > 0) {
            ISystemFilterContainer parent = filter.getParentFilterContainer();
            boolean nested = !(parent instanceof ISystemFilterPool);
            ISystemFilter nestedParentFilter = nested ? (ISystemFilter)parent : null;
            int idx = 0;
            while (idx < subsystems.length) {
                Object parentObj = null;
                parentObj = !nested ? (this.showFilterPools() ? subsystems[idx].getSystemFilterPoolReferenceManager().getReferenceToSystemFilterPool(pool) : subsystems[idx]) : nestedParentFilter;
                event = this.cloneEvent(event, parentObj);
                event.setParent(parentObj);
                this.fireSubSystemEvent(event, subsystems[idx]);
                ++idx;
            }
        }
    }

    protected SystemResourceChangeEvent cloneEvent(SystemResourceChangeEvent event, Object parent) {
        SystemResourceChangeEvent result = event.getMultiSource() != null ? new SystemResourceChangeEvent(event.getMultiSource(), event.getType(), parent) : new SystemResourceChangeEvent(event.getSource(), event.getType(), parent);
        result.setPosition(event.getPosition());
        return result;
    }

    protected void fireSubSystemFilterEvent(int eventId, ISystemFilterString filterString) {
        SystemResourceChangeEvent event = this.createEvent(filterString, eventId, null);
        this.fireSubSystemFilterEvent(event, filterString);
    }

    protected void fireSubSystemFilterEvent(int eventId, ISystemFilterString[] filterStrings, int delta) {
        if (filterStrings.length > 0) {
            SystemResourceChangeEvent event = this.createEvent(filterStrings, eventId, null, delta);
            this.fireSubSystemFilterEvent(event, filterStrings[0]);
        }
    }

    protected void fireSubSystemFilterEvent(SystemResourceChangeEvent event, ISystemFilterString filterString) {
        ISystemFilter filter = filterString.getParentSystemFilter();
        ISystemFilterPool pool = filter.getParentFilterPool();
        ISubSystem[] subsystems = this.getSubSystems(pool);
        if (subsystems != null && subsystems.length > 0) {
            event.setParent((Object)filter);
            int idx = 0;
            while (idx < subsystems.length) {
                this.fireSubSystemEvent(event, subsystems[idx]);
                ++idx;
            }
        }
    }

    public void filterEventFilterPoolCreated(ISystemFilterPool newPool) {
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(1, 8, (Object)newPool, null);
    }

    public void filterEventFilterPoolDeleted(ISystemFilterPool oldPool) {
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(2, 8, (Object)oldPool, null);
    }

    public void filterEventFilterPoolRenamed(ISystemFilterPool pool, String oldName) {
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(8, 8, (Object)pool, oldName);
    }

    public void filterEventFilterPoolsRePositioned(ISystemFilterPool[] pools, int delta) {
        this.fireEvent(pools, 75, this, delta);
        if (pools != null) {
            int idx = 0;
            while (idx < pools.length) {
                RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(16, 8, (Object)pools[idx], null);
                ++idx;
            }
        }
    }

    public void filterEventFilterCreated(ISystemFilter newFilter) {
        this.fireSubSystemFilterEvent(10, newFilter);
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(1, 32, (Object)newFilter, null);
    }

    public void filterEventFilterDeleted(ISystemFilter oldFilter) {
        this.fireSubSystemFilterEvent(20, oldFilter);
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(2, 32, (Object)oldFilter, null);
    }

    public void filterEventFilterRenamed(ISystemFilter filter, String oldName) {
        this.fireSubSystemFilterEvent(15, filter);
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(8, 32, (Object)filter, oldName);
    }

    public void filterEventFilterUpdated(ISystemFilter filter) {
        this.fireSubSystemFilterEvent(25, filter);
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(4, 32, (Object)filter, null);
    }

    public void filterEventFiltersRePositioned(ISystemFilter[] filters, int delta) {
        if (filters != null && filters.length > 0) {
            SystemResourceChangeEvent event = this.createEvent(filters, 30, (Object)null);
            event.setPosition(delta);
            this.fireSubSystemFilterEvent(event, filters[0]);
            int idx = 0;
            while (idx < filters.length) {
                RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(16, 32, (Object)filters[idx], null);
                ++idx;
            }
        }
    }

    public void filterEventFilterStringCreated(ISystemFilterString newFilterString) {
        this.fireSubSystemFilterEvent(41, newFilterString);
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(4, 32, (Object)newFilterString.getParentSystemFilter(), null);
    }

    public void filterEventFilterStringDeleted(ISystemFilterString oldFilterString) {
        this.fireSubSystemFilterEvent(42, oldFilterString);
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(4, 32, (Object)oldFilterString.getParentSystemFilter(), null);
    }

    public void filterEventFilterStringUpdated(ISystemFilterString filterString) {
        this.fireSubSystemFilterEvent(43, filterString);
        RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(4, 32, (Object)filterString.getParentSystemFilter(), null);
    }

    public void filterEventFilterStringsRePositioned(ISystemFilterString[] filterStrings, int delta) {
        this.fireSubSystemFilterEvent(44, filterStrings, delta);
        if (filterStrings != null && filterStrings.length > 0) {
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(4, 32, (Object)filterStrings[0].getParentSystemFilter(), null);
        }
    }

    public ISystemFilterPool getFilterPool(ISystemProfile profile, String name) {
        return this.getFilterPoolManager(profile).getSystemFilterPool(name);
    }

    public ISystemFilterPool[] getFilterPools(ISystemProfile profile) {
        return this.getFilterPoolManager(profile).getSystemFilterPools();
    }

    public boolean showChangeFilterStringsPropertyPage(ISystemFilter filter) {
        return true;
    }

    public ISubSystem[] testForActiveReferences(ISystemProfile profile) {
        ISystemFilterPool[] pools;
        ArrayList<ISubSystem> l = new ArrayList<ISubSystem>();
        SystemProfileManager profileMgr = SystemProfileManager.getDefault();
        ISystemFilterPoolManager sfpm = this.getFilterPoolManager(profile);
        String profileName = profile.getName();
        if (sfpm != null && (pools = sfpm.getSystemFilterPools()) != null && pools.length > 0) {
            int idx = 0;
            while (idx < pools.length) {
                IRSEBaseReferencingObject[] refs = pools[idx].getReferencingObjects();
                if (refs != null && refs.length > 0) {
                    int jdx = 0;
                    while (jdx < refs.length) {
                        ISystemFilterPoolReference fpRef;
                        ISubSystem subsystem;
                        String ssProfileName;
                        if (refs[jdx] instanceof ISystemFilterPoolReference && !(ssProfileName = (subsystem = (ISubSystem)(fpRef = (ISystemFilterPoolReference)refs[jdx]).getProvider()).getSystemProfileName()).equals(profileName) && profileMgr.isSystemProfileActive(ssProfileName)) {
                            l.add(subsystem);
                        }
                        ++jdx;
                    }
                }
                ++idx;
            }
        }
        ISubSystem[] referencingSubSystems = null;
        if (l.size() > 0) {
            referencingSubSystems = l.toArray(new ISubSystem[l.size()]);
        }
        return referencingSubSystems;
    }

    public String getTranslatedFilterTypeProperty(ISystemFilter selectedFilter) {
        if (this.translatedFilterType == null) {
            this.translatedFilterType = SystemPropertyResources.RESID_PROPERTY_FILTERTYPE_VALUE;
        }
        return this.translatedFilterType;
    }

    public boolean showRefreshOnFilter() {
        return true;
    }

    public boolean showGenericShowInTableOnFilter() {
        return true;
    }

    public IServerLauncherProperties createServerLauncher(IConnectorService connectorService) {
        IRSESystemType systemType;
        String systemTypeId;
        RemoteServerLauncher sl = new RemoteServerLauncher("Remote Server Launcher", connectorService);
        if (sl instanceof ILabeledObject) {
            ((ILabeledObject)sl).setLabel(RSECoreMessages.RESID_PROPERTYSET_REMOTE_SERVER_LAUNCHER);
        }
        if ((systemTypeId = (systemType = connectorService.getHost().getSystemType()).getId()).equals("org.eclipse.rse.systemtype.linux") || systemTypeId.equals("org.eclipse.rse.systemtype.linux.power") || systemTypeId.equals("org.eclipse.rse.systemtype.linux.zSeries")) {
            sl.setServerScript("sh -c \"PATH=/opt/j2sdk1.4.2/bin:$PATH; export PATH; perl ./server.pl\"");
        } else if (systemTypeId.equals("org.eclipse.rse.systemtype.unix") || systemTypeId.equals("org.eclipse.rse.systemtype.aix")) {
            sl.setServerScript("sh -c \"PATH=/opt/j2sdk1.4.2/bin:$PATH; export PATH; sh server.sh\"");
        }
        sl.saveToProperties();
        return sl;
    }

    public boolean commit() {
        boolean ok = false;
        try {
            this.saveSubSystems();
            this.saveFilterPools();
            ok = true;
        }
        catch (Exception exception) {}
        return ok;
    }

    public void saveSubSystems() throws Exception {
        this.saveSubSystems(null);
    }

    public void saveSubSystems(IHost conn) throws Exception {
        Exception lastException = null;
        ISubSystem[] subsystems = null;
        subsystems = conn != null ? this.getSubSystems(conn, false) : this.getSubSystems(false);
        if (subsystems == null) {
            return;
        }
        int idx = 0;
        while (idx < subsystems.length) {
            try {
                this.saveSubSystem(subsystems[idx]);
            }
            catch (Exception exc) {
                lastException = exc;
            }
            ++idx;
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    public void saveSubSystem(ISubSystem subsys) throws Exception {
        subsys.commit();
    }

    public boolean saveFilterPools() throws Exception {
        boolean ok = true;
        ISystemFilterPoolManager[] poolManagers = this.getFilterPoolManagers();
        Exception lastException = null;
        if (poolManagers != null) {
            int idx = 0;
            while (idx < poolManagers.length) {
                try {
                    this.saveFilterPools(poolManagers[idx]);
                }
                catch (Exception exc) {
                    ok = false;
                    lastException = exc;
                }
                ++idx;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return ok;
    }

    public void saveFilterPools(ISystemFilterPoolManager mgr) throws Exception {
        try {
            mgr.commit();
        }
        catch (Exception exc) {
            this.handleException("Exception saving filter pools for manager " + mgr.getName(), exc);
            throw exc;
        }
    }

    public ISubSystem createSubSystemAfterTheFact(IHost conn) {
        ISubSystem subsys = null;
        try {
            subsys = this.createSubSystemInternal(conn);
        }
        catch (RuntimeException e) {
            RSECorePlugin.getDefault().getLogger().logError("Error creating subsystem", (Throwable)e);
        }
        if (subsys != null) {
            this.internalInitializeNewSubSystem(subsys, conn);
            if (this.supportsFilters()) {
                ISystemFilterPoolReferenceManager fprMgr = SystemFilterStartHere.getInstance().createSystemFilterPoolReferenceManager((ISystemFilterPoolReferenceManagerProvider)subsys, (ISystemFilterPoolManagerProvider)this, subsys.getName());
                subsys.setFilterPoolReferenceManager(fprMgr);
                ISystemFilterPoolManager defaultFilterPoolManager = this.getFilterPoolManager(conn.getSystemProfile());
                fprMgr.setDefaultSystemFilterPoolManager(defaultFilterPoolManager);
            }
            this.initializeSubSystem(subsys, null);
            try {
                this.saveSubSystem(subsys);
            }
            catch (Exception exc) {
                SystemBasePlugin.logError("Error saving new subsystem " + subsys.getName(), exc);
            }
            this.addSubSystem(subsys);
        }
        return subsys;
    }

    protected boolean subSystemsHaveBeenRestored(IHost connection) {
        return this.subSystemsRestoredFlags.get(connection) != null;
    }

    public ISystemFilterPoolManager[] getAllSystemFilterPoolManagers() {
        ISystemProfile[] profiles = RSECorePlugin.getTheSystemProfileManager().getSystemProfiles();
        ISystemFilterPoolManager[] allMgrs = new ISystemFilterPoolManager[profiles.length];
        int idx = 0;
        while (idx < profiles.length) {
            allMgrs[idx] = this.getFilterPoolManager(profiles[idx]);
            ++idx;
        }
        return allMgrs;
    }

    public void setConnection(IHost connection) {
        this.currentlySelectedConnection = connection;
    }

    public void setCurrentSelection(Object[] selection) {
        this.currentlySelected = selection;
    }

    protected void handleException(String msg, Exception exc) {
        SystemBasePlugin.logError(msg, exc);
    }

    public static String getConnectingMessage(String hostName, int port) {
        String msgTxt = null;
        msgTxt = port > 0 ? NLS.bind((String)CommonMessages.MSG_CONNECTWITHPORT_PROGRESS, (Object)hostName, (Object)Integer.toString(port)) : NLS.bind((String)CommonMessages.MSG_CONNECT_PROGRESS, (Object)hostName);
        return msgTxt;
    }

    public static String getDisconnectingMessage(String hostName, int port) {
        String msgTxt = null;
        msgTxt = port > 0 ? NLS.bind((String)CommonMessages.MSG_DISCONNECTWITHPORT_PROGRESS, (Object)hostName, (Object)Integer.toString(port)) : NLS.bind((String)CommonMessages.MSG_DISCONNECT_PROGRESS, (Object)hostName);
        return msgTxt;
    }

    public static String getDefaultFilterPoolName(String profileName, String factoryId) {
        StringBuffer nameBuf = new StringBuffer();
        nameBuf.append(profileName);
        nameBuf.append(":");
        nameBuf.append(factoryId);
        return nameBuf.toString();
    }

    public String toString() {
        return this.proxy.toString();
    }

    public List getSubSystemList() {
        return this.subSystemList;
    }

    public List getFilterPoolManagerList() {
        return this.filterPoolManagerList;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public boolean isDirty() {
        return false;
    }

    public void setDirty(boolean flag) {
    }

    public boolean isTainted() {
        return false;
    }

    public void setTainted(boolean flag) {
    }

    public boolean wasRestored() {
        return false;
    }

    public void setWasRestored(boolean flag) {
    }

    public void beginRestore() {
    }

    public void endRestore() {
    }

    public IRSEPersistableContainer getPersistableParent() {
        return null;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        return IRSEPersistableContainer.NO_CHILDREN;
    }

    public boolean supportsDeferredQueries() {
        return true;
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
    }

    public IConnectorService getConnectorService(IHost host) {
        return null;
    }

    public Class getServiceType() {
        return null;
    }

    public Class getServiceImplType() {
        return null;
    }

    public IService getService(IHost host) {
        return null;
    }
}

