/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.thread;

import java.util.concurrent.TimeoutException;

public class TestThread
extends Thread {
    private final Runnable runnable;
    private volatile Throwable uncaught;

    public Runnable getRunnable() {
        return this.runnable;
    }

    public TestThread(Runnable target, String name) {
        super(target, name);
        this.runnable = target;
    }

    public TestThread(Runnable target) {
        super(target);
        this.runnable = target;
    }

    public TestThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
        this.runnable = target;
    }

    public TestThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
        this.runnable = target;
    }

    public TestThread(ThreadGroup group, Runnable target) {
        super(group, target);
        this.runnable = target;
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        catch (Throwable t) {
            this.uncaught = t;
        }
    }

    public Throwable getUncaught() {
        return this.uncaught;
    }

    public void joinAndThrow() throws InterruptedException, Throwable {
        this.join();
        if (this.uncaught != null) {
            throw this.uncaught;
        }
    }

    public void joinAndThrow(long timeout) throws InterruptedException, Throwable {
        this.join(timeout);
        if (this.isAlive()) {
            throw new TimeoutException();
        }
        if (this.uncaught != null) {
            throw this.uncaught;
        }
    }

    public Throwable joinAndReturn() throws InterruptedException {
        this.join();
        if (this.uncaught != null) {
            return this.uncaught;
        }
        return null;
    }

    public Throwable joinAndReturn(long timeout) throws InterruptedException {
        this.join(timeout);
        if (this.isAlive()) {
            return new TimeoutException();
        }
        if (this.uncaught != null) {
            return this.uncaught;
        }
        return null;
    }
}

