/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.process;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;

public final class StreamPumper
implements Runnable {
    private static final int BUF_SIZE = 256;
    private final InputStream in;
    private final Set<OutputStream> outStreams = new HashSet<OutputStream>();
    private final Set<LinePump> linePumps = new HashSet<LinePump>();
    private final AtomicBoolean processing = new AtomicBoolean(false);

    public StreamPumper(InputStream in) {
        this.in = in;
    }

    public StreamPumper(InputStream in, OutputStream out) {
        this(in);
        this.addOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block38: {
            try (BufferedInputStream is5 = new BufferedInputStream(this.in);
                 ByteArrayOutputStream lineBos = new ByteArrayOutputStream();){
                byte[] buf = new byte[256];
                int len = 0;
                int linelen = 0;
                while ((len = is5.read(buf)) > 0 && !Thread.interrupted()) {
                    for (OutputStream out : this.outStreams) {
                        out.write(buf, 0, len);
                    }
                    if (this.linePumps.isEmpty()) continue;
                    int lastcrlf = -1;
                    for (int i = 0; i < len; ++i) {
                        if (buf[i] != 10 && buf[i] != 13) continue;
                        int bufLinelen = i - lastcrlf - 1;
                        if (bufLinelen > 0) {
                            lineBos.write(buf, lastcrlf + 1, bufLinelen);
                        }
                        if ((linelen += bufLinelen) > 0) {
                            lineBos.flush();
                            String line = lineBos.toString();
                            this.linePumps.forEach(lp -> lp.processLine(line));
                            lineBos.reset();
                            linelen = 0;
                        }
                        lastcrlf = i;
                    }
                    if (lastcrlf == -1) {
                        lineBos.write(buf, 0, len);
                        linelen += len;
                        continue;
                    }
                    if (lastcrlf >= len - 1) continue;
                    lineBos.write(buf, lastcrlf + 1, len - lastcrlf - 1);
                    linelen += len - lastcrlf - 1;
                }
                String line = lineBos.toString();
                if (!line.isEmpty()) {
                    this.linePumps.forEach(lp -> lp.processLine(line));
                }
            }
            for (OutputStream out : this.outStreams) {
                try {
                    out.flush();
                }
                catch (IOException iOException) {}
            }
            try {
                this.in.close();
            }
            catch (IOException is5) {}
            break block38;
            catch (IOException e) {
                if (!e.getMessage().equalsIgnoreCase("stream closed")) {
                    e.printStackTrace();
                }
                break block38;
            }
            finally {
                for (OutputStream out : this.outStreams) {
                    try {
                        out.flush();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    final void addOutputStream(OutputStream out) {
        this.outStreams.add(out);
    }

    final void addLineProcessor(LinePump lp) {
        this.linePumps.add(lp);
    }

    public final StreamPumper addPump(Pump ... pump) {
        if (this.processing.get()) {
            throw new IllegalStateException("Can not modify pumper while processing is in progress");
        }
        for (Pump p : pump) {
            p.register(this);
        }
        return this;
    }

    public final Future<Void> process() {
        if (!this.processing.compareAndSet(false, true)) {
            throw new IllegalStateException("Can not re-run the processing");
        }
        FutureTask<Object> result = new FutureTask<Object>(this, null);
        Thread t = new Thread(result);
        t.setDaemon(true);
        t.start();
        return result;
    }

    public static abstract class Pump {
        abstract void register(StreamPumper var1);
    }

    public static abstract class LinePump
    extends Pump {
        @Override
        final void register(StreamPumper sp) {
            sp.addLineProcessor(this);
        }

        protected abstract void processLine(String var1);
    }

    public static final class StreamPump
    extends Pump {
        private final OutputStream out;

        public StreamPump(OutputStream out) {
            this.out = out;
        }

        @Override
        void register(StreamPumper sp) {
            sp.addOutputStream(this.out);
        }
    }
}

