/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.verifier;

import java.net.URL;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;

public class URLVerifier
extends AbstractFormattedVerifier {
    protected static final String ERROR_REASON = "$ERROR_REASON$";
    protected static String ERROR_MESSAGE_SHORT;
    protected static String ERROR_MESSAGE_FULL;
    private static final int IPV4_SIZE = 4;
    private static final int IPV6_SIZE = 16;
    private static final int INT16_SIZE = 2;

    public URLVerifier(String fieldName) {
        super(fieldName);
        ERROR_MESSAGE_SHORT = BaseMessages.format((String)SVNUIMessages.Verifier_URL_Short, (Object[])new String[]{"$FIELD_NAME$"});
        ERROR_MESSAGE_FULL = BaseMessages.format((String)SVNUIMessages.Verifier_URL_Full, (Object[])new String[]{"$FIELD_NAME$", ERROR_REASON});
    }

    @Override
    protected String getErrorMessageImpl(Control input) {
        String url = this.getText(input);
        try {
            URL svnUrl = SVNUtility.getSVNUrl((String)url);
            String host = svnUrl.getHost();
            if (!this.isIPAddress(host) && !host.matches("[a-zA-Z0-9_\\-]+(?:\\.[a-zA-Z0-9_\\-]+)*") && host.length() > 0 || host.length() == 0 && !"file".equals(svnUrl.getProtocol())) {
                this.setPlaceHolder(ERROR_REASON, SVNUIMessages.Verifier_URL_NoHost);
                return ERROR_MESSAGE_FULL;
            }
            return null;
        }
        catch (Exception ex) {
            this.setPlaceHolder(ERROR_REASON, ex.getMessage());
            return ex.getMessage() == null ? ERROR_MESSAGE_SHORT : ERROR_MESSAGE_FULL;
        }
    }

    @Override
    protected String getWarningMessageImpl(Control input) {
        return null;
    }

    protected boolean isIPAddress(String host) {
        int idx = host.indexOf(93);
        return idx != -1 && URLVerifier.isIPv6Address(host.substring(1, idx)) || URLVerifier.isIPv4Address(host);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean isIPv4Address(String address) {
        String[] s = address.split("\\.", -1);
        try {
            if (s.length == 1) {
                long val = Long.parseLong(s[0]);
                if (val < 0L) return false;
                if (val <= 0xFFFFFFFFL) return true;
                return false;
            }
            if (s.length == 2) {
                long val = Long.parseLong(s[0]);
                long val1 = Long.parseLong(s[1]);
                if (val < 0L) return false;
                if (val > 255L) return false;
                if (val1 < 0L) return false;
                if (val1 <= 0xFFFFFFL) return true;
                return false;
            }
            if (s.length == 3) {
                long val = Long.parseLong(s[0]);
                long val1 = Long.parseLong(s[1]);
                long val2 = Long.parseLong(s[2]);
                if (val < 0L) return false;
                if (val > 255L) return false;
                if (val1 < 0L) return false;
                if (val1 > 255L) return false;
                if (val2 < 0L) return false;
                if (val2 <= 65535L) return true;
                return false;
            }
            if (s.length != 4) return false;
            String[] stringArray = s;
            int n = s.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String p = stringArray[n2];
                long val = Long.parseLong(p);
                if (val < 0L) return false;
                if (val > 255L) {
                    return false;
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected static boolean isIPv6Address(String address) {
        if (address.length() < 2) {
            return false;
        }
        char[] addressChars = address.toCharArray();
        int addressLength = addressChars.length;
        int scopePos = address.indexOf("%");
        if (scopePos == addressLength - 1) {
            return false;
        }
        if (scopePos != -1) {
            addressLength = scopePos;
        }
        int lastColonPosition = -1;
        int i = 0;
        int j = 0;
        if (addressChars[i] == ':' && addressChars[++i] != ':') {
            return false;
        }
        int currentTokenPointer = i;
        boolean hadNumTokenBefore = false;
        int val = 0;
        while (i < addressLength) {
            char ch;
            int chval;
            if ((chval = Character.digit(ch = addressChars[i++], 16)) != -1) {
                val <<= 4;
                if ((val |= chval) > 65535) {
                    return false;
                }
                hadNumTokenBefore = true;
                continue;
            }
            if (ch == ':') {
                currentTokenPointer = i;
                if (!hadNumTokenBefore) {
                    if (lastColonPosition != -1) {
                        return false;
                    }
                    lastColonPosition = j;
                    continue;
                }
                if (i == addressLength) {
                    return false;
                }
                if (j + 2 > 16) {
                    return false;
                }
                j += 2;
                hadNumTokenBefore = false;
                val = 0;
                continue;
            }
            if (ch == '.' && j + 4 <= 16) {
                String ia4 = address.substring(currentTokenPointer, addressLength);
                int dotCount = 0;
                int index = 0;
                while ((index = ia4.indexOf(46, index)) != -1) {
                    ++dotCount;
                    ++index;
                }
                if (dotCount != 3 || !URLVerifier.isIPv4Address(ia4)) {
                    return false;
                }
                j += 4;
                hadNumTokenBefore = false;
                break;
            }
            return false;
        }
        if (hadNumTokenBefore) {
            if (j + 2 > 16) {
                return false;
            }
            j += 2;
        }
        if (lastColonPosition != -1) {
            if (j == 16) {
                return false;
            }
            j = 16;
        }
        return j == 16;
    }
}

