/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.ResolvedStructurePath;

public class StructurePath
extends ArtifactAccessorResultWithoutGammas {
    public static final StructurePath SENTINEL = new StructurePath();
    private final LinkedList<ResolvedStructurePath> paths = new LinkedList();
    private final InterfaceStructureToken structure;

    public StructurePath(Long id, String name) {
        super(id, name);
        this.structure = InterfaceStructureToken.SENTINEL;
    }

    public StructurePath(InterfaceStructureToken structure) {
        super(structure.getId(), (String)structure.getName().getValue());
        this.structure = structure;
    }

    public StructurePath() {
        this.structure = InterfaceStructureToken.SENTINEL;
    }

    @JsonIgnore
    public Long getId() {
        return super.getId();
    }

    public List<ResolvedStructurePath> getPaths() {
        return this.paths;
    }

    public void addPath(ResolvedStructurePath path) {
        this.paths.add(path);
    }

    @JsonIgnore
    public InterfaceStructureToken getStructure() {
        return this.structure;
    }
}

