/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithGammas;
import org.eclipse.osee.accessor.types.AttributePojo;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.types.InterfaceEnumOrdinalType;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class InterfaceEnumeration
extends ArtifactAccessorResultWithGammas {
    public static final InterfaceEnumeration SENTINEL = new InterfaceEnumeration();
    private ApplicabilityToken applicability = ApplicabilityToken.SENTINEL;
    private AttributePojo<Long> ordinal = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinal, (GammaId)GammaId.SENTINEL, (Object)0L, (String)"");
    private AttributePojo<String> ordinalType = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinalType, (GammaId)GammaId.SENTINEL, (Object)InterfaceEnumOrdinalType.LONG.toString(), (String)"");

    public InterfaceEnumeration(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceEnumeration(ArtifactReadable art) {
        super(art);
        this.setOrdinal((AttributePojo<Long>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinal, (Object)0L)));
        this.setOrdinalType((AttributePojo<String>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinalType, (Object)InterfaceEnumOrdinalType.LONG.toString())));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public InterfaceEnumeration(Long id, String name) {
        super(id, AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Name, (GammaId)GammaId.SENTINEL, (Object)name, (String)name));
    }

    public InterfaceEnumeration() {
        this(Id.SENTINEL, "");
    }

    @JsonIgnore
    public String getFormattedOrdinal() {
        if (InterfaceEnumOrdinalType.HEX.toString().equals(this.getOrdinalType().getValue())) {
            return "0x" + Long.toHexString((Long)this.getOrdinal().getValue()).toUpperCase();
        }
        return ((Long)this.getOrdinal().getValue()).toString();
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public AttributePojo<Long> getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Long ordinal) {
        AttributePojo<Long> oldOrdinal = this.getOrdinal();
        this.ordinal = AttributePojo.valueOf((Long)oldOrdinal.getId(), (AttributeTypeToken)oldOrdinal.getTypeId(), (GammaId)oldOrdinal.getGammaId(), (Object)ordinal, (String)oldOrdinal.getDisplayableString());
    }

    @JsonProperty
    public void setOrdinal(AttributePojo<Long> ordinal) {
        this.ordinal = ordinal;
    }

    public AttributePojo<String> getOrdinalType() {
        return this.ordinalType;
    }

    public void setOrdinalType(AttributePojo<String> ordinalType) {
        this.ordinalType = ordinalType;
    }

    public void setOrdinalType(InterfaceEnumOrdinalType ordinalType) {
        this.ordinalType = AttributePojo.valueOf((Long)this.ordinalType.getId(), (AttributeTypeToken)this.ordinalType.getTypeId(), (GammaId)this.ordinalType.getGammaId(), (Object)ordinalType.toString(), (String)this.ordinalType.getDisplayableString());
    }

    public String toString() {
        return String.valueOf(this.getFormattedOrdinal()) + " = " + this.getName();
    }

    public CreateArtifact createArtifact(String key, ApplicabilityId applicId) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.InterfaceEnumOrdinal, ((Long)this.getOrdinal().getValue()).toString());
        values.put(CoreAttributeTypes.InterfaceEnumOrdinalType, this.getOrdinalType().toString());
        CreateArtifact art = new CreateArtifact();
        art.setName((String)this.getName().getValue());
        art.setTypeId(CoreArtifactTypes.InterfaceEnum.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.InterfaceEnum.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setApplicabilityId(applicId.getIdString());
        art.setkey(key);
        return art;
    }
}

