/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.UnreferencedICDArtifactsEndpoint;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class UnreferencedICDArtifactsEndpointImpl
implements UnreferencedICDArtifactsEndpoint {
    private final BranchId branch;
    private final InterfacePlatformTypeApi platformTypeApi;
    private final InterfaceElementApi elementApi;
    private final InterfaceStructureApi structureApi;
    private final InterfaceSubMessageApi submessageApi;
    private final InterfaceMessageApi messageApi;

    public UnreferencedICDArtifactsEndpointImpl(BranchId branch, InterfacePlatformTypeApi platformTypeApi, InterfaceElementApi elementApi, InterfaceStructureApi structureApi, InterfaceSubMessageApi submessageApi, InterfaceMessageApi messageApi) {
        this.branch = branch;
        this.platformTypeApi = platformTypeApi;
        this.elementApi = elementApi;
        this.structureApi = structureApi;
        this.submessageApi = submessageApi;
        this.messageApi = messageApi;
    }

    @Override
    public Collection<PlatformTypeToken> getPlatformTypes(String filter, long pageNum, long pageSize) {
        return this.platformTypeApi.getAllwithNoElementRelations(this.branch, filter, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElements(String filter, long pageNum, long pageSize) {
        return this.elementApi.getAllwithNoStructureRelations(this.branch, filter, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceStructureToken> getStructures(String filter, long pageNum, long pageSize) {
        return this.structureApi.getAllwithNoSubMessageRelations(this.branch, filter, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getSubmessages(String filter, long pageNum, long pageSize) {
        return this.submessageApi.getAllwithNoMessageRelations(this.branch, filter, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceMessageToken> getMessages(String filter, long pageNum, long pageSize) {
        return this.messageApi.getAllwithNoConnectionRelations(this.branch, filter, pageNum, pageSize);
    }

    @Override
    public int getPlatformTypesCount(String filter) {
        return this.platformTypeApi.getAllwithNoElementRelationsCount(this.branch, filter);
    }

    @Override
    public int getElementsCount(String filter) {
        return this.elementApi.getAllwithNoStructureRelationsCount(this.branch, filter);
    }

    @Override
    public int getStructuresCount(String filter) {
        return this.structureApi.getAllwithNoSubMessageRelationsCount(this.branch, filter);
    }

    @Override
    public int getSubmessagesCount(String filter) {
        return this.submessageApi.getAllwithNoMessageRelationsCount(this.branch, filter);
    }

    @Override
    public int getMessagesCount(String filter) {
        return this.messageApi.getAllwithNoConnectionRelationsCount(this.branch, filter);
    }
}

