/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceMessageEndpoint;
import org.eclipse.osee.mim.types.InterfaceMessageToken;

public class InterfaceMessageEndpointImpl
implements InterfaceMessageEndpoint {
    private final BranchId branch;
    private final ArtifactId connectionId;
    private final InterfaceMessageApi messageApi;

    public InterfaceMessageEndpointImpl(BranchId branch, ArtifactId connectionId, InterfaceMessageApi interfaceMessageApi) {
        this.branch = branch;
        this.messageApi = interfaceMessageApi;
        this.connectionId = connectionId;
    }

    @Override
    public Collection<InterfaceMessageToken> getAllMessages(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeTypeId) {
        if (Strings.isValid((String)filter)) {
            return this.messageApi.getAllForConnectionAndFilter(this.branch, this.connectionId, filter, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeTypeId);
        }
        return this.messageApi.getAllForConnection(this.branch, this.connectionId, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeTypeId);
    }

    @Override
    public InterfaceMessageToken getInterfaceMessage(ArtifactId messageId, ArtifactId viewId) {
        return this.messageApi.getRelatedToConnection(this.branch, this.connectionId, messageId, viewId);
    }

    @Override
    public int getAllMessagesCount(String filter, ArtifactId viewId) {
        if (Strings.isValid((String)filter)) {
            return this.messageApi.getAllForConnectionAndFilterCount(this.branch, this.connectionId, filter);
        }
        return this.messageApi.getAllForConnectionAndCount(this.branch, this.connectionId);
    }
}

