/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.ArtifactAccessor;
import org.eclipse.osee.accessor.types.ArtifactMatch;
import org.eclipse.osee.accessor.types.AttributeQuery;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.internal.InterfaceElementAccessor;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureElementTokenWithPath;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.ds.FollowRelation;

public class InterfaceElementApiImpl
implements InterfaceElementApi {
    private ArtifactAccessor<InterfaceStructureElementToken> accessor;
    private final InterfacePlatformTypeApi platformApi;
    private final List<AttributeTypeId> elementAttributeList;
    private final List<FollowRelation> relations;
    private final List<RelationTypeSide> affectedRelations;

    InterfaceElementApiImpl(OrcsApi orcsApi, InterfacePlatformTypeApi platformTypeApi) {
        this.setAccessor((ArtifactAccessor<InterfaceStructureElementToken>)new InterfaceElementAccessor(orcsApi));
        this.platformApi = platformTypeApi;
        this.elementAttributeList = this.createElementAttributeList();
        this.relations = this.createRelationTypeSideList();
        this.affectedRelations = this.createAffectedRelationTypeSideList();
    }

    private List<AttributeTypeId> createElementAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Notes);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementAlterable);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexEnd);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexStart);
        return attributes;
    }

    private List<FollowRelation> createRelationTypeSideList() {
        LinkedList<FollowRelation> followRelations = new LinkedList<FollowRelation>();
        followRelations.add(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceElementArrayElement_ArrayElement, (FollowRelation[])new FollowRelation[]{FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType)}));
        followRelations.add(FollowRelation.follow((RelationTypeSide)CoreRelationTypes.InterfaceElementPlatformType_PlatformType));
        return followRelations;
    }

    private List<RelationTypeSide> createAffectedRelationTypeSideList() {
        LinkedList<RelationTypeSide> relations = new LinkedList<RelationTypeSide>();
        relations.add(CoreRelationTypes.InterfaceStructureContent_DataElement);
        return relations;
    }

    private ArtifactAccessor<InterfaceStructureElementToken> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ArtifactAccessor<InterfaceStructureElementToken> accessor) {
        this.accessor = accessor;
    }

    @Override
    public List<InterfaceStructureElementToken> getAll(BranchId branch) {
        return this.getAll(branch, 0L, 0L);
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelated(BranchId branch, ArtifactId structureId, ArtifactId viewId) {
        return this.getAllRelated(branch, structureId, viewId, 0L, 0L);
    }

    @Override
    public InterfaceStructureElementToken getRelated(BranchId branch, ArtifactId structureId, ArtifactId elementId) {
        try {
            InterfaceStructureElementToken element = (InterfaceStructureElementToken)((Object)this.getAccessor().getByRelation(branch, elementId, CoreRelationTypes.InterfaceStructureContent_Structure, structureId, this.getFollowRelationDetails()));
            element = this.defaultSetUpElement(branch, element, InterfaceStructureElementToken.SENTINEL);
            return element;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceStructureElementToken.SENTINEL;
        }
    }

    @Override
    public InterfaceStructureElementToken get(BranchId branch, ArtifactId elementId) {
        try {
            InterfaceStructureElementToken element = (InterfaceStructureElementToken)((Object)this.getAccessor().get(branch, elementId, this.getFollowRelationDetails()));
            if (element.isValid()) {
                element = this.defaultSetUpElement(branch, element, InterfaceStructureElementToken.SENTINEL);
                return element;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
        }
        return InterfaceStructureElementToken.SENTINEL;
    }

    @Override
    public Collection<InterfaceStructureElementToken> get(BranchId branch, Collection<ArtifactId> elementIds, Collection<FollowRelation> followRelations) {
        try {
            List elements = (List)this.getAccessor().get(branch, elementIds, followRelations);
            elements.stream().forEach(element -> {
                InterfaceStructureElementToken interfaceStructureElementToken = this.defaultSetUpElement(branch, (InterfaceStructureElementToken)((Object)element), InterfaceStructureElementToken.SENTINEL);
            });
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    private InterfaceStructureElementToken defaultSetUpElement(BranchId branch, InterfaceStructureElementToken element, InterfaceStructureElementToken previousElement) {
        return this.defaultSetUpElement(branch, element, previousElement, PlatformTypeToken.SENTINEL);
    }

    private InterfaceStructureElementToken defaultSetUpElement(BranchId branch, InterfaceStructureElementToken element, InterfaceStructureElementToken previousElement, PlatformTypeToken defaultPlatformType) {
        try {
            PlatformTypeToken platformType;
            if (element.getInterfaceElementArrayHeader().isValid() && ((Boolean)element.getInterfaceElementArrayHeader().getValue()).booleanValue()) {
                platformType = element.getPlatformType();
            } else if (defaultPlatformType.isInvalid()) {
                ArtifactReadable platformTypeReadable = (ArtifactReadable)element.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceElementPlatformType_PlatformType).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
                platformType = new PlatformTypeToken(platformTypeReadable);
            } else {
                platformType = defaultPlatformType;
            }
            if (previousElement.isInvalid()) {
                element.setBeginByte(0.0);
                element.setBeginWord(0.0);
            } else {
                element.setBeginByte((previousElement.getEndByte() + 1.0) % 4.0);
                element.setBeginWord(Math.floor((previousElement.getEndWord() * 4.0 + previousElement.getEndByte() + 1.0) / 4.0));
            }
            element.setPlatformType(platformType);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        return element;
    }

    private List<InterfaceStructureElementToken> parseElements(BranchId branch, List<InterfaceStructureElementToken> elements) {
        return this.parseElements(branch, elements, PlatformTypeToken.SENTINEL);
    }

    private List<InterfaceStructureElementToken> parseElements(BranchId branch, List<InterfaceStructureElementToken> elements, PlatformTypeToken defaultPlatformType) {
        Iterator<InterfaceStructureElementToken> elementIterator = elements.iterator();
        LinkedList<InterfaceStructureElementToken> tempElements = new LinkedList<InterfaceStructureElementToken>();
        if (elements.size() >= 2) {
            InterfaceStructureElementToken previousElement = elementIterator.next();
            InterfaceStructureElementToken currentElement = elementIterator.next();
            this.defaultSetUpElement(branch, previousElement, InterfaceStructureElementToken.SENTINEL, previousElement.getPlatformType().isValid() ? previousElement.getPlatformType() : defaultPlatformType);
            tempElements.add(previousElement);
            if (!elementIterator.hasNext()) {
                currentElement = this.defaultSetUpElement(branch, currentElement, previousElement, currentElement.getPlatformType().isValid() ? currentElement.getPlatformType() : defaultPlatformType);
            }
            while (elementIterator.hasNext()) {
                InterfaceStructureElementToken nextElement = elementIterator.next();
                currentElement = this.defaultSetUpElement(branch, currentElement, previousElement, currentElement.getPlatformType().isValid() ? currentElement.getPlatformType() : defaultPlatformType);
                tempElements.add(currentElement);
                previousElement = currentElement;
                currentElement = nextElement;
            }
            currentElement = this.defaultSetUpElement(branch, currentElement, previousElement, currentElement.getPlatformType().isValid() ? currentElement.getPlatformType() : defaultPlatformType);
            tempElements.add(currentElement);
            elements = tempElements;
        } else {
            for (InterfaceStructureElementToken element : elements) {
                element = this.defaultSetUpElement(branch, element, InterfaceStructureElementToken.SENTINEL, element.getPlatformType().isValid() ? element.getPlatformType() : defaultPlatformType);
            }
        }
        return elements;
    }

    @Override
    public List<InterfaceStructureElementToken> getFiltered(BranchId branch, String filter) {
        return this.getFiltered(branch, filter, 0L, 0L);
    }

    @Override
    public List<InterfaceStructureElementToken> getElementsByType(BranchId branch, ArtifactId platformTypeId) {
        try {
            PlatformTypeToken platformType = this.platformApi.getWithRelations(branch, platformTypeId, FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceElementPlatformType_Element}));
            List<InterfaceStructureElementToken> elements = platformType.getArtifactReadable().getRelatedList(CoreRelationTypes.InterfaceElementPlatformType_Element).stream().map(a -> new InterfaceStructureElementToken((ArtifactReadable)a)).collect(Collectors.toList());
            elements = this.parseElements(branch, elements, platformType);
            return elements;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getElementsByName(BranchId branch, String name, long pageNum, long pageSize) {
        try {
            return (List)this.getAccessor().getAll(branch, (Collection)FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceElementPlatformType_PlatformType}), name, Arrays.asList(CoreAttributeTypes.Name), pageNum, pageSize, (AttributeTypeId)CoreAttributeTypes.Name);
        }
        catch (Exception ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public int getElementsByNameCount(BranchId branch, String name) {
        return this.getAccessor().getAllByFilterAndCount(branch, name, Arrays.asList(CoreAttributeTypes.Name));
    }

    @Override
    public List<InterfaceStructureElementTokenWithPath> getElementsByType(BranchId branch) {
        return this.platformApi.getAllWithElementRelations(branch).stream().map(type -> type.getArtifactReadable().getRelatedList(CoreRelationTypes.InterfaceElementPlatformType_Element).stream().map(element -> new InterfaceStructureElementTokenWithPath((ArtifactReadable)element)).collect(Collectors.toList())).collect(Collectors.toList()).stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Override
    public List<InterfaceStructureElementTokenWithPath> getElementsByTypeFilter(BranchId branch, String filter) {
        return this.platformApi.getFilteredWithElementRelations(branch, filter).stream().map(type -> type.getArtifactReadable().getRelatedList(CoreRelationTypes.InterfaceElementPlatformType_Element).stream().map(element -> new InterfaceStructureElementTokenWithPath((ArtifactReadable)element)).collect(Collectors.toList())).collect(Collectors.toList()).stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelatedAndFilter(BranchId branch, ArtifactId structureId, String filter) {
        return this.getAllRelatedAndFilter(branch, structureId, filter, 0L, 0L);
    }

    @Override
    public Collection<InterfaceStructureElementToken> query(BranchId branch, AttributeQuery query) {
        return this.query(branch, query, false);
    }

    @Override
    public List<FollowRelation> getFollowRelationDetails() {
        return this.relations;
    }

    @Override
    public InterfaceStructureElementToken getWithAllParentRelations(BranchId branch, ArtifactId elementId) {
        try {
            List parentRelations = FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceStructureContent_Structure, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection, CoreRelationTypes.InterfaceConnectionTransportType_TransportType});
            return (InterfaceStructureElementToken)((Object)this.getAccessor().get(branch, elementId, (Collection)parentRelations));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceStructureElementToken.SENTINEL;
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getAllFromPlatformType(PlatformTypeToken pType) {
        return pType.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceElementPlatformType_Element).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceStructureElementToken((ArtifactReadable)a)).collect(Collectors.toList());
    }

    @Override
    public Collection<InterfaceStructureElementToken> queryExact(BranchId branch, AttributeQuery query) {
        return this.query(branch, query, true);
    }

    @Override
    public Collection<InterfaceStructureElementToken> query(BranchId branch, AttributeQuery query, boolean isExact) {
        return this.query(branch, query, isExact, 0L, 0L);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedArtifacts(BranchId branch, ArtifactId relatedId) {
        try {
            return this.getAccessor().getAffectedArtifacts(branch, relatedId, this.affectedRelations);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<ArtifactMatch>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getAll(BranchId branch, long pageNum, long pageSize) {
        return this.getAll(branch, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelated(BranchId branch, ArtifactId structureId, long pageNum, long pageSize) {
        return this.getAllRelated(branch, structureId, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelated(BranchId branch, ArtifactId structureId, ArtifactId viewId, long pageNum, long pageSize) {
        return this.getAllRelated(branch, structureId, viewId, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelatedAndFilter(BranchId branch, ArtifactId structureId, String filter, long pageNum, long pageSize) {
        return this.getAllRelatedAndFilter(branch, structureId, filter, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public List<InterfaceStructureElementToken> getFiltered(BranchId branch, String filter, long pageNum, long pageSize) {
        return this.getFiltered(branch, filter, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<InterfaceStructureElementToken> query(BranchId branch, AttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, false, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceStructureElementToken> queryExact(BranchId branch, AttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, true, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceStructureElementToken> query(BranchId branch, AttributeQuery query, boolean isExact, long pageNum, long pageSize) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByQuery(branch, query, this.getFollowRelationDetails(), isExact, pageNum, pageSize);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getAll(BranchId branch, AttributeTypeId orderByAttribute) {
        return this.getAll(branch, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelated(BranchId branch, ArtifactId structureId, AttributeTypeId orderByAttribute) {
        return this.getAllRelated(branch, structureId, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureElementToken> getAll(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAll(branch, this.getFollowRelationDetails(), pageNum, pageSize, orderByAttribute);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelated(BranchId branch, ArtifactId structureId, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        return this.getAllRelated(branch, structureId, ArtifactId.SENTINEL, pageNum, pageSize, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelated(BranchId branch, ArtifactId structureId, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceStructureContent_Structure, structureId, this.getFollowRelationDetails(), pageNum, pageSize, orderByAttribute, viewId);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelatedAndFilter(BranchId branch, ArtifactId structureId, String filter, AttributeTypeId orderByAttribute) {
        return this.getAllRelatedAndFilter(branch, structureId, filter, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelatedAndFilter(BranchId branch, ArtifactId structureId, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByRelationAndFilter(branch, CoreRelationTypes.InterfaceStructureContent_Structure, structureId, filter, this.elementAttributeList, this.getFollowRelationDetails(), pageNum, pageSize, orderByAttribute);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getFiltered(BranchId branch, String filter, AttributeTypeId orderByAttribute) {
        return this.getFiltered(branch, filter, 0L, 0L, orderByAttribute);
    }

    @Override
    public List<InterfaceStructureElementToken> getFiltered(BranchId branch, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByFilter(branch, filter, this.elementAttributeList, this.relations, pageNum, pageSize, orderByAttribute);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public Collection<InterfaceStructureElementToken> getAllwithNoStructureRelations(BranchId branch, String filter, long pageNum, long pageSize) {
        LinkedList<RelationTypeSide> rel = new LinkedList<RelationTypeSide>();
        rel.add(CoreRelationTypes.InterfaceStructureContent_DataElement);
        rel.add(CoreRelationTypes.InterfaceElementArrayElement_ArrayElement);
        try {
            return this.getAccessor().getAllLackingRelationByFilter(branch, filter, this.elementAttributeList, rel, pageNum, pageSize);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public int getAllwithNoStructureRelationsCount(BranchId branch, String filter) {
        LinkedList<RelationTypeSide> rel = new LinkedList<RelationTypeSide>();
        rel.add(CoreRelationTypes.InterfaceStructureContent_DataElement);
        rel.add(CoreRelationTypes.InterfaceElementArrayElement_ArrayElement);
        return this.getAccessor().getAllLackingRelationByFilterAndCount(branch, filter, this.elementAttributeList, rel);
    }
}

