/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.ArtifactAccessor;
import org.eclipse.osee.accessor.types.ArtifactMatch;
import org.eclipse.osee.accessor.types.AttributeQuery;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.internal.InterfaceConnectionAccessor;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.ds.FollowRelation;

public class InterfaceConnectionViewApiImpl
implements InterfaceConnectionViewApi {
    private ArtifactAccessor<InterfaceConnection> accessor;
    private final List<RelationTypeSide> affectedRelations;
    private final List<FollowRelation> relations;

    InterfaceConnectionViewApiImpl(OrcsApi orcsApi) {
        this.setAccessor((ArtifactAccessor<InterfaceConnection>)new InterfaceConnectionAccessor(orcsApi));
        this.affectedRelations = this.createAffectedRelationTypeSideList();
        this.relations = this.createRelationTypeSideList();
    }

    private List<FollowRelation> createRelationTypeSideList() {
        LinkedList<FollowRelation> relations = new LinkedList<FollowRelation>();
        relations.add(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceConnectionNode_Node));
        relations.add(FollowRelation.fork((RelationTypeSide)CoreRelationTypes.InterfaceConnectionTransportType_TransportType));
        return relations;
    }

    private List<AttributeTypeId> getConnectionSearchAttributes() {
        List<AttributeTypeId> attributes = CoreArtifactTypes.InterfaceConnection.getValidAttributeTypes().stream().map(a -> AttributeTypeId.valueOf((Long)a.getId())).collect(Collectors.toList());
        List excluded = CoreArtifactTypes.Artifact.getValidAttributeTypes();
        excluded.removeAll(Arrays.asList(CoreAttributeTypes.Name, CoreAttributeTypes.Description));
        attributes.removeAll(excluded);
        return attributes;
    }

    @Override
    public ArtifactAccessor<InterfaceConnection> getAccessor() {
        return this.accessor;
    }

    private List<RelationTypeSide> createAffectedRelationTypeSideList() {
        LinkedList<RelationTypeSide> relations = new LinkedList<RelationTypeSide>();
        relations.add(CoreRelationTypes.InterfaceConnectionNode_Node);
        return relations;
    }

    public void setAccessor(ArtifactAccessor<InterfaceConnection> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Collection<InterfaceConnection> query(BranchId branch, AttributeQuery query) {
        return this.query(branch, query, false);
    }

    @Override
    public InterfaceConnection get(BranchId branch, ArtifactId connectionId) {
        try {
            return (InterfaceConnection)((Object)this.getAccessor().get(branch, connectionId, this.relations));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return InterfaceConnection.SENTINEL;
        }
    }

    @Override
    public InterfaceConnection get(BranchId branch, ArtifactId viewId, ArtifactId connectionId, Collection<FollowRelation> followRelations) {
        try {
            return (InterfaceConnection)((Object)this.getAccessor().get(branch, connectionId, followRelations, viewId));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return InterfaceConnection.SENTINEL;
        }
    }

    @Override
    public Collection<InterfaceConnection> get(BranchId branch, Collection<ArtifactId> connectionIds) {
        try {
            List connection = (List)this.getAccessor().get(branch, connectionIds, this.relations);
            return connection;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceConnection>();
        }
    }

    @Override
    public Collection<InterfaceConnection> queryExact(BranchId branch, AttributeQuery query) {
        return this.query(branch, query, true);
    }

    @Override
    public Collection<InterfaceConnection> query(BranchId branch, AttributeQuery query, boolean isExact) {
        return this.query(branch, query, isExact, 0L, 0L);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedArtifacts(BranchId branch, ArtifactId relatedId) {
        try {
            return this.getAccessor().getAffectedArtifacts(branch, relatedId, this.affectedRelations);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<ArtifactMatch>();
        }
    }

    @Override
    public Collection<InterfaceConnection> getAll(BranchId branch) {
        return this.getAll(branch, 0L, 0L);
    }

    @Override
    public Collection<InterfaceConnection> getAll(BranchId branch, ArtifactId viewId) {
        return this.getAll(branch, 0L, 0L, AttributeTypeId.SENTINEL, viewId);
    }

    @Override
    public Collection<InterfaceConnection> getAll(BranchId branch, long pageNum, long pageSize) {
        return this.getAll(branch, 0L, 0L, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<InterfaceConnection> query(BranchId branch, AttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, false, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceConnection> queryExact(BranchId branch, AttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, true, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceConnection> query(BranchId branch, AttributeQuery query, boolean isExact, long pageNum, long pageSize) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, this.relations, isExact, pageNum, pageSize);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceConnection>();
        }
    }

    @Override
    public Collection<InterfaceConnection> getAll(BranchId branch, AttributeTypeId orderByAttribute) {
        return this.getAll(branch, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<InterfaceConnection> getAll(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        return this.getAll(branch, pageNum, pageSize, orderByAttribute, ArtifactId.SENTINEL);
    }

    @Override
    public Collection<InterfaceConnection> getAll(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute, ArtifactId viewId) {
        try {
            return this.getAccessor().getAll(branch, this.relations, pageNum, pageSize, orderByAttribute, viewId);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceConnection>();
        }
    }

    @Override
    public Collection<InterfaceConnection> getAll(BranchId branch, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute, ArtifactId viewId) {
        try {
            return this.getAccessor().getAll(branch, this.relations, filter, this.getConnectionSearchAttributes(), pageNum, pageSize, orderByAttribute, viewId);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceConnection>();
        }
    }

    @Override
    public int getCount(BranchId branch, String filter, ArtifactId viewId) {
        return this.getAccessor().getAllByFilterAndCount(branch, filter, this.getConnectionSearchAttributes(), viewId);
    }
}

