/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.hooks;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsWriteDiffWhenCompleteHook
implements IAtsTransitionHook {
    public String getName() {
        return AtsWriteDiffWhenCompleteHook.class.getSimpleName();
    }

    public String getDescription() {
        return "When the Workflow is transitioned to Completed, write an attribute with the requirements diff information if there were changes";
    }

    public boolean isBackgroundTask(Collection<IAtsWorkItem> workItems, Map<IAtsWorkItem, String> workItemFromStateMap, String toStateName, AtsUser transitionUser, AtsApi atsApi) {
        for (IAtsWorkItem workItem : workItems) {
            StateDefinition toStateDef = workItem.getStateDefinition();
            if (!workItem.isTeamWorkflow() || !workItem.isWorkType(WorkType.Requirements) || !toStateDef.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public void transitionPersistedBackground(Collection<? extends IAtsWorkItem> workItems, Map<IAtsWorkItem, String> workItemFromStateMap, String toStateName, AtsUser asUser, AtsApi atsApi) {
        try {
            IAtsChangeSet changes = null;
            for (IAtsWorkItem iAtsWorkItem : workItems) {
                StateDefinition toStateDef = iAtsWorkItem.getStateDefinition();
                if (!iAtsWorkItem.isTeamWorkflow() || !iAtsWorkItem.isWorkType(WorkType.Requirements) || !toStateDef.isCompleted()) continue;
                BranchToken branch = atsApi.getBranchService().getWorkingBranch((IAtsTeamWorkflow)iAtsWorkItem, true);
                if (!atsApi.getBranchService().branchExists((BranchId)branch) || branch == null || !branch.isValid()) continue;
                IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)iAtsWorkItem;
                List changeItems = atsApi.getBranchService().getChangeData((BranchId)branch);
                if (changeItems.isEmpty()) continue;
                String changeItemJson = JsonUtil.toJson((Object)changeItems);
                if (atsApi.getAttributeResolver().getAttributeCount((IAtsWorkItem)teamWf, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData) == 0) {
                    changes = this.getOrCreateChanges(changes, atsApi);
                    changes.addAttribute((IAtsObject)iAtsWorkItem, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData, (Object)changeItemJson);
                    continue;
                }
                if (((String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData, (Object)"")).equals(changeItemJson)) continue;
                changes = this.getOrCreateChanges(changes, atsApi);
                changes.setSoleAttributeFromString((IAtsObject)iAtsWorkItem, (AttributeTypeGeneric)CoreAttributeTypes.BranchDiffData, changeItemJson);
                atsApi.getAttributeResolver().setSoleAttributeValue((IAtsObject)iAtsWorkItem, (AttributeTypeId)CoreAttributeTypes.BranchDiffData, (Object)changeItemJson);
            }
            if (changes != null) {
                changes.executeIfNeeded();
            }
        }
        catch (Exception ex) {
            OseeLog.log(AtsWriteDiffWhenCompleteHook.class, (Level)Level.WARNING, (String)"Error setting Branch Diff Data JSON", (Throwable)ex);
        }
    }

    private IAtsChangeSet getOrCreateChanges(IAtsChangeSet changes, AtsApi atsApi) {
        if (changes != null) {
            return changes;
        }
        return atsApi.createChangeSet(this.getClass().getSimpleName());
    }
}

