/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class AtsObjects {
    public static String toIdsString(String separator, Collection<? extends Id> idOjs) {
        return Collections.toString((String)separator, AtsObjects.toIds(idOjs));
    }

    public static List<Long> toIds(Collection<? extends Id> idObjs) {
        ArrayList<Long> ids = new ArrayList<Long>(idObjs.size());
        for (Id id : idObjs) {
            ids.add(id.getId());
        }
        return ids;
    }

    public static List<ArtifactId> toArtifactIds(Collection<? extends IAtsObject> atsObjects) {
        ArrayList<ArtifactId> ids = new ArrayList<ArtifactId>(atsObjects.size());
        for (IAtsObject iAtsObject : atsObjects) {
            ids.add((ArtifactId)iAtsObject.getStoreObject());
        }
        return ids;
    }

    public static List<String> toAtsIds(Collection<? extends IAtsWorkItem> workItem) {
        ArrayList<String> ids = new ArrayList<String>(workItem.size());
        for (IAtsWorkItem iAtsWorkItem : workItem) {
            ids.add(iAtsWorkItem.getAtsId());
        }
        return ids;
    }

    public static String toString(String separator, Collection<? extends Object> objects) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            if (object instanceof IAtsObject) {
                sb.append(((IAtsObject)object).getName());
            } else {
                sb.append(object.toString());
            }
            sb.append(separator);
        }
        if (sb.length() > separator.length()) {
            return sb.substring(0, sb.length() - separator.length());
        }
        return "";
    }

    public static String toAtsIdsFromActions(Collection<IAtsAction> actions) {
        ArrayList<String> atsIds = new ArrayList<String>(actions.size());
        for (IAtsAction action : actions) {
            atsIds.add(action.getAtsId());
        }
        return Collections.toString((String)", ", atsIds);
    }

    public static Collection<ArtifactId> getArtifacts(Collection<?> objects) {
        LinkedList<ArtifactId> artifacts = new LinkedList<ArtifactId>();
        for (Object object : objects) {
            if (object instanceof ArtifactId) {
                artifacts.add((ArtifactId)object);
                continue;
            }
            if (!(object instanceof IAtsObject)) continue;
            artifacts.add((ArtifactId)((IAtsObject)object).getStoreObject());
        }
        return artifacts;
    }

    public static Collection<ArtifactId> getTeamWfArtifacts(Collection<?> objects, AtsApi atsApi) {
        LinkedList<ArtifactId> artifacts = new LinkedList<ArtifactId>();
        for (Object object : objects) {
            if (object instanceof ArtifactToken) {
                ArtifactToken artId = (ArtifactToken)object;
                if (artId.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                    artifacts.addAll(AtsObjects.getArtifacts(atsApi.getWorkItemService().getTeams((Object)atsApi.getWorkItemService().getAction(artId))));
                }
            }
            if (!(object instanceof IAtsTeamWorkflow)) continue;
            artifacts.add((ArtifactId)((IAtsTeamWorkflow)object).getStoreObject());
        }
        return artifacts;
    }

    public static <T> Collection<T> getActive(Collection<? extends IAtsConfigObject> objects) {
        LinkedList<IAtsConfigObject> active = new LinkedList<IAtsConfigObject>();
        for (IAtsConfigObject iAtsConfigObject : objects) {
            if (!iAtsConfigObject.isActive()) continue;
            active.add(iAtsConfigObject);
        }
        return active;
    }

    public static List<String> toIdStrings(Collection<? extends IAtsConfigObject> objects) {
        LinkedList<String> ids = new LinkedList<String>();
        for (IAtsConfigObject iAtsConfigObject : objects) {
            ids.add(iAtsConfigObject.getIdString());
        }
        return ids;
    }

    public static List<String> toIdStringsFromLong(Collection<Long> ids) {
        LinkedList<String> results = new LinkedList<String>();
        for (Long id : ids) {
            results.add(id.toString());
        }
        return results;
    }

    public static boolean isAtsWorkItemOrAction(Object element) {
        return element instanceof IAtsAction || element instanceof IAtsWorkItem;
    }

    public static IAtsConfigObject getConfigObject(ArtifactToken artifact, AtsApi atsApi) {
        Version configObject;
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Version})) {
            configObject = atsApi.getVersionService().getVersionById((ArtifactId)artifact);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
            configObject = atsApi.getTeamDefinitionService().getTeamDefinitionById((ArtifactId)artifact);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) {
            configObject = atsApi.getActionableItemService().getActionableItemById((ArtifactId)artifact);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Program})) {
            configObject = atsApi.getProgramService().getProgramById((ArtifactId)artifact);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileTeam})) {
            configObject = atsApi.getAgileService().getAgileTeam((ArtifactId)artifact);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileFeatureGroup})) {
            configObject = atsApi.getAgileService().getAgileFeatureGroup((ArtifactId)artifact);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Insertion})) {
            configObject = atsApi.getProgramService().getInsertionById((ArtifactId)artifact);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.InsertionActivity})) {
            configObject = atsApi.getProgramService().getInsertionActivityById((ArtifactId)artifact);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Country})) {
            configObject = atsApi.getProgramService().getCountryById((ArtifactId)artifact);
        } else {
            throw new OseeArgumentException("Unexpected artifact type [%s]", new Object[]{artifact.getArtifactType()});
        }
        return configObject;
    }

    public static boolean isAtsConfigArtifact(ArtifactToken artifact, AtsApi atsApi) {
        return artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsConfigArtifact});
    }

    public static IAtsObject getAtsObject(ArtifactToken artifact, AtsApi atsApi) {
        IAtsWorkItem result = null;
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
            result = atsApi.getWorkItemService().getWorkItem(artifact);
        } else if (AtsObjects.isAtsConfigArtifact(artifact, atsApi)) {
            result = AtsObjects.getConfigObject(artifact, atsApi);
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            result = atsApi.getWorkItemService().getAction(artifact);
        }
        return result;
    }
}

