/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class ArtifactValueProvider
implements IValueProvider {
    private final ArtifactToken artifact;
    private final AttributeTypeToken attrTypeToken;
    private final AtsApi atsApi;

    public ArtifactValueProvider(ArtifactToken artifact, WidgetDefinition widgetDef, AtsApi atsApi) {
        this.artifact = artifact;
        this.atsApi = atsApi;
        this.attrTypeToken = widgetDef.getAttributeType();
    }

    public ArtifactValueProvider(ArtifactToken artifact, AttributeTypeToken attributeType, AtsApi atsApi) {
        this.artifact = artifact;
        this.atsApi = atsApi;
        this.attrTypeToken = attributeType;
    }

    public boolean isEmpty() {
        AttributeTypeToken attributeType = this.getAtributeType();
        if (attributeType != null) {
            return this.atsApi.getAttributeResolver().getAttributeCount((ArtifactId)this.artifact, attributeType) == 0;
        }
        return true;
    }

    public Collection<String> getValues() {
        AttributeTypeToken attributeType = this.getAtributeType();
        if (attributeType != null) {
            return this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)this.artifact, attributeType);
        }
        return Collections.emptyList();
    }

    public AttributeTypeToken getAtributeType() {
        return this.attrTypeToken;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public Collection<Date> getDateValues() {
        AttributeTypeToken attributeType = this.getAtributeType();
        if (attributeType != null && attributeType.isDate()) {
            return this.atsApi.getAttributeResolver().getAttributeValues((ArtifactId)this.artifact, attributeType);
        }
        return Collections.emptyList();
    }

    public ArtifactId getArtifact() {
        return this.artifact;
    }

    public Object getObject() {
        return this.artifact;
    }
}

