/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.IAtsConfigurationsService;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractAtsUserService
implements IAtsUserService {
    protected IAtsConfigurationsService configurationService;

    public void setConfigurationService(IAtsConfigurationsService configurationService) {
        this.configurationService = configurationService;
    }

    public Collection<AtsUser> getUsersByUserIds(Collection<String> userIds) {
        LinkedList<AtsUser> users = new LinkedList<AtsUser>();
        for (String userId : userIds) {
            AtsUser user = this.getUserByUserId(userId);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    public boolean isLoadValid() {
        return false;
    }

    public AtsUser getUserByUserId(String userId) {
        AtsUser atsUser = null;
        if (Strings.isValid((String)userId) && (atsUser = this.configurationService.getUserByUserId(userId)) == null && Strings.isValid((String)userId) && (atsUser = AtsCoreUsers.getAtsCoreUserByUserId((String)userId)) == null && this.isLoadValid()) {
            try {
                atsUser = this.loadUserByUserId(userId);
            }
            catch (UserNotInDatabase userNotInDatabase) {}
            if (atsUser != null) {
                this.configurationService.getConfigurations().addUser(atsUser);
            }
        }
        return atsUser;
    }

    public AtsUser getUserById(ArtifactId user) {
        AtsUser atsUser = (AtsUser)this.configurationService.getConfigurations().getIdToUser().get(user.getId());
        if (atsUser == null && this.isLoadValid() && (atsUser = this.loadUserByUserId(user.getId())) != null) {
            this.configurationService.getConfigurations().addUser(atsUser);
        }
        return atsUser;
    }

    protected AtsUser loadUserByUserId(Long accountId) {
        throw new UnsupportedOperationException();
    }

    protected AtsUser loadUserByUserId(String userId) {
        throw new UnsupportedOperationException();
    }

    protected AtsUser loadUserByUserName(String name) {
        throw new UnsupportedOperationException();
    }

    public AtsUser getUserByName(String name) {
        AtsUser atsUser = this.configurationService.getUserByName(name);
        if (atsUser == null && Strings.isValid((String)name) && this.isLoadValid() && (atsUser = this.loadUserByUserName(name)) != null) {
            this.configurationService.getConfigurations().addUser(atsUser);
        }
        return atsUser;
    }

    public AtsUser getUserByToken(UserToken userToken) {
        return this.getUserByUserId(userToken.getUserId());
    }

    public Collection<AtsUser> getUsers(Active active) {
        ArrayList<AtsUser> users = new ArrayList<AtsUser>();
        for (AtsUser user : this.getUsers()) {
            if (active != Active.Both && (active != Active.Active || !user.isActive()) && (active != Active.InActive || user.isActive())) continue;
            users.add(user);
        }
        return users;
    }

    public void reloadCache() {
        this.configurationService.getConfigurationsWithPend();
        this.setCurrentUser(null);
    }

    public Collection<AtsUser> getActiveAndAssignedInActive(Collection<? extends IAtsWorkItem> workItems) {
        HashSet<AtsUser> users = new HashSet<AtsUser>();
        users.addAll(this.getUsers(Active.Active));
        for (IAtsWorkItem iAtsWorkItem : workItems) {
            for (AtsUser user : iAtsWorkItem.getAssignees()) {
                if (user.isActive()) continue;
                users.add(user);
            }
        }
        return users;
    }

    public Collection<AtsUser> getRelatedUsers(AtsApi atsApi, ArtifactToken artifact, RelationTypeSide relation) {
        HashSet<AtsUser> results = new HashSet<AtsUser>();
        for (Object userArt : atsApi.getRelationResolver().getRelated((ArtifactId)artifact, relation)) {
            String userId = (String)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)userArt, (AttributeTypeToken)CoreAttributeTypes.UserId, null);
            AtsUser lead = atsApi.getUserService().getUserByUserId(userId);
            Conditions.assertNotNull((Object)lead, (String)"Lead can not be null with userArt %s", (Object[])new Object[]{userArt});
            results.add(lead);
        }
        return results;
    }

    public String getUserStorageString(Collection<AtsUser> users) {
        StringBuilder sb = new StringBuilder();
        for (AtsUser u : users) {
            sb.append("<" + u.getUserId() + ">");
        }
        return sb.toString();
    }

    public String getAbridgedEmail(ArtifactToken user, AtsApi atsApi) {
        return (String)atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.AbridgedEmail, (Object)"");
    }

    public AtsUser getUserByLoginId(String loginId) {
        return this.configurationService.getUserByLoginId(loginId);
    }
}

