/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.rule.validate;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class OrphanAndDuplicateParentValidationRule
extends AbstractValidationRule {
    public OrphanAndDuplicateParentValidationRule(AtsApi atsApi) {
        super(atsApi);
    }

    public void validate(ArtifactToken artifact, XResultData rd) {
        try {
            if (!this.atsApi.getStoreService().isHistorical((ArtifactId)artifact)) {
                int count = this.atsApi.getRelationResolver().getRelatedCount(artifact, CoreRelationTypes.DefaultHierarchical_Parent);
                if (count == 0 && !CoreArtifactTokens.DefaultHierarchyRoot.equals(artifact)) {
                    this.logError(artifact, "is orphaned (no parent on Default Hierarchy).", rd);
                } else if (count > 1) {
                    this.logError(artifact, String.format("has %s parents (duplicate parents on Default Hierarchy).", count), rd);
                }
            }
        }
        catch (Exception ex) {
            String errStr = String.format("had exception on orphaned and duplicate parent check: %s", Lib.exceptionToString((Exception)ex));
            this.logError(artifact, errStr, rd);
        }
    }

    public String getRuleDescription() {
        return "All Errors reported must be fixed.";
    }

    public String getRuleTitle() {
        return "Orphan / Duplicate Parent Validation Checks";
    }
}

