/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.rule.validate;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class DeletedArtifactValidationRule
extends AbstractValidationRule {
    public DeletedArtifactValidationRule(AtsApi atsApi) {
        super(atsApi);
    }

    public void validate(ArtifactToken artifact, XResultData rd) {
        ArtifactToken relatedArtifact;
        if (this.atsApi.getStoreService().isDeleted((ArtifactId)artifact) && (relatedArtifact = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)artifact, CoreRelationTypes.DefaultHierarchical_Parent)).isValid()) {
            String errStr = "is deleted but still has a parent relation.  Please delete the relation.";
            this.logError(artifact, errStr, rd);
        }
    }

    public String getRuleDescription() {
        return "Artifact was deleted, but the parent relation still exists.";
    }

    public String getRuleTitle() {
        return "Deleted Artifact Validation Checks";
    }
}

