/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.log;

import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.ILogStorageProvider;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsLogHtml {
    private final IAtsLog atsLog;
    private final boolean showLogTitle;
    private final ILogStorageProvider storeProvider;
    private final IAtsUserService atsUserService;

    public AtsLogHtml(IAtsLog atsLog, ILogStorageProvider storeProvider, IAtsUserService atsUserService, boolean showLogTitle) {
        this.storeProvider = storeProvider;
        this.atsUserService = atsUserService;
        this.showLogTitle = showLogTitle;
        this.atsLog = atsLog;
    }

    public String get() {
        if (this.atsLog.getLogItems().isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.showLogTitle) {
            sb.append(String.valueOf(AHTML.addSpace((int)1)) + AHTML.getLabelStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)this.storeProvider.getLogTitle()));
        }
        sb.append(this.getTable());
        return sb.toString();
    }

    public String getTable() {
        StringBuilder builder = new StringBuilder();
        List logItems = this.atsLog.getLogItems();
        builder.append(AHTML.beginMultiColumnTable((int)100, (int)1));
        builder.append(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Event", "State", "Message", "User", "Date")));
        for (IAtsLogItem item : logItems) {
            builder.append(AHTML.addRowMultiColumnTable((String[])new String[]{String.valueOf(item.getType()), item.getState().equals("") ? "." : item.getState(), item.getMsg().equals("") ? "." : item.getMsg(), this.getUserName(item.getUserId()), item.getDate("MM/dd/yyyy hh:mm a")}));
        }
        builder.append(AHTML.endMultiColumnTable());
        return builder.toString();
    }

    private String getUserName(String userId) {
        String userName;
        AtsUser userById;
        String name = userId;
        if (this.atsUserService != null && (userById = this.atsUserService.getUserByUserId(userId)) != null && Strings.isValid((String)(userName = userById.getName()))) {
            name = userName;
        }
        return name;
    }
}

