/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.column;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsColumnUtil;
import org.eclipse.osee.ats.api.column.AtsCoreAttrTokColumnToken;
import org.eclipse.osee.ats.api.column.AtsCoreColumn;
import org.eclipse.osee.ats.api.column.AtsCoreColumnToken;
import org.eclipse.osee.ats.api.column.IAtsColumnProvider;
import org.eclipse.osee.ats.api.column.IAtsColumnService;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.AtsDisplayHint;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.ColumnType;
import org.eclipse.osee.ats.core.column.ActionableItemsColumn;
import org.eclipse.osee.ats.core.column.AgileFeatureGroupColumn;
import org.eclipse.osee.ats.core.column.AgileTeamPointsColumn;
import org.eclipse.osee.ats.core.column.AssigneeColumn;
import org.eclipse.osee.ats.core.column.AtsIdColumn;
import org.eclipse.osee.ats.core.column.AttachmentsCountColumn;
import org.eclipse.osee.ats.core.column.ChangeTypeColumn;
import org.eclipse.osee.ats.core.column.CheckColumn;
import org.eclipse.osee.ats.core.column.CompletedCancelledByColumn;
import org.eclipse.osee.ats.core.column.CompletedCancelledDateColumn;
import org.eclipse.osee.ats.core.column.CrIdColumn;
import org.eclipse.osee.ats.core.column.DerivedFromAtsIdColumn;
import org.eclipse.osee.ats.core.column.DerivedFromTaskColumn;
import org.eclipse.osee.ats.core.column.DerivedFromTeamDefColumn;
import org.eclipse.osee.ats.core.column.DerivedWorkflowColumn;
import org.eclipse.osee.ats.core.column.FeatureImpactReferenceColumn;
import org.eclipse.osee.ats.core.column.FoundInVersionColumn;
import org.eclipse.osee.ats.core.column.HoursSpentTotalColumn;
import org.eclipse.osee.ats.core.column.IdColumn;
import org.eclipse.osee.ats.core.column.ImplementerColumn;
import org.eclipse.osee.ats.core.column.IncorporatedInColumn;
import org.eclipse.osee.ats.core.column.InsertionActivityColumn;
import org.eclipse.osee.ats.core.column.InsertionColumn;
import org.eclipse.osee.ats.core.column.ParentTitleColumn;
import org.eclipse.osee.ats.core.column.PercentCompleteTasksColumn;
import org.eclipse.osee.ats.core.column.PrIdColumn;
import org.eclipse.osee.ats.core.column.PriorityColumn;
import org.eclipse.osee.ats.core.column.SprintOrderColumn;
import org.eclipse.osee.ats.core.column.StateColumn;
import org.eclipse.osee.ats.core.column.TargetedVersionColumn;
import org.eclipse.osee.ats.core.column.TaskPointsColumn;
import org.eclipse.osee.ats.core.column.TaskRelatedArtifactTypeColumn;
import org.eclipse.osee.ats.core.column.TaskRiskFactorsColumn;
import org.eclipse.osee.ats.core.column.TeamColumn;
import org.eclipse.osee.ats.core.column.TitleColumn;
import org.eclipse.osee.ats.core.column.TypeColumn;
import org.eclipse.osee.ats.core.column.WorkDefinitionColumn;
import org.eclipse.osee.ats.core.column.model.AtsCoreAttrTokenColumn;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.internal.column.AtsColumnProviderCollector;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.exception.OseeTypeDoesNotExist;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsColumnService
implements IAtsColumnService {
    public static final String CELL_ERROR_PREFIX = "!Error";
    private Map<String, AtsCoreColumn> idToAtsColumn;
    private final AtsApi atsApi;
    private final Set<String> errorLogged = new HashSet<String>();
    private final Set<AttributeTypeToken> attrTypeHintChecked = new HashSet<AttributeTypeToken>();
    private XResultData rd = null;
    private Map<String, String> legacyIdToId;

    public AtsColumnService(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData validateIdeColumns(List<XViewerColumn> ideColumns) {
        XResultData rd = new XResultData();
        this.ensureLoaded();
        for (XViewerColumn ideCol : ideColumns) {
            this.atsApi.getColumnService().getColumn(ideCol.getId());
        }
        return rd;
    }

    public synchronized void ensureLoaded() {
        if (this.idToAtsColumn == null) {
            this.idToAtsColumn = new HashMap<String, AtsCoreColumn>();
            this.rd = new XResultData();
            this.loadCoreAtsConfigViewsColumns();
            this.loadCoreAtsColumns();
            this.loadCoreAtsProviderColumns();
            this.loadCoreAtsCodedColumns();
            this.loadRemainingAtsWorkflowAttributes();
            this.loadLegacyIdColumns();
        }
    }

    private void loadLegacyIdColumns() {
        this.getIdFromLegacyId("");
        for (Map.Entry<String, String> entry : this.legacyIdToId.entrySet()) {
            String id = entry.getValue();
            AtsCoreColumn atsCoreColumn = this.idToAtsColumn.get(id);
            if (atsCoreColumn == null) continue;
            String legacyId = entry.getKey();
            this.idToAtsColumn.put(legacyId, atsCoreColumn);
        }
    }

    public AtsCoreColumn getColumn(String id) {
        this.ensureLoaded();
        AtsCoreColumn column = this.idToAtsColumn.get(id);
        if (column == null && !this.errorLogged.contains(id)) {
            this.errorLogged.add(id);
        }
        return column;
    }

    private void loadRemainingAtsWorkflowAttributes() {
        this.loadRemainingAtsWorkflowAttributes("ats.");
    }

    public void loadRemainingAtsWorkflowAttributes(String prefix) {
        this.loadRemainingAtsWorkflowAttributes(prefix, AtsArtifactTypes.AbstractWorkflowArtifact);
    }

    public void loadRemainingAtsWorkflowAttributes(String prefix, ArtifactTypeToken artType) {
        this.rd.logf("%s - Processing art type: %s\n", new Object[]{this.getClass().getSimpleName(), artType.toStringWithId()});
        for (AttributeTypeToken attrType : artType.getValidAttributeTypes()) {
            if (this.attrTypeHintChecked.contains(attrType)) continue;
            try {
                if (attrType.hasDisplayHint(new DisplayHint[]{AtsDisplayHint.Read, AtsDisplayHint.Edit, AtsDisplayHint.ReadConfig})) {
                    if (!this.idToAtsColumn.containsKey(attrType.getName())) {
                        AtsCoreAttrTokenColumn col = this.getAttributeColumn(attrType, "workflow attr types");
                        this.idToAtsColumn.put(col.getId(), col);
                    }
                } else {
                    this.rd.error(String.format("Workflow Attribute Type %s must specify AtsDisplayHint.Edit or Read", attrType.toStringWithId()));
                }
                if (attrType.hasDisplayHint(new DisplayHint[]{AtsDisplayHint.Config})) {
                    this.rd.error(String.format("Workflow Attribute Type %s should not specify DisplayHint.Config", attrType.toStringWithId()));
                }
            }
            catch (OseeTypeDoesNotExist ex) {
                this.rd.logf("Attribute Type %s Does Not Exist %s", new Object[]{attrType.toStringWithId(), Lib.exceptionToString((Exception)((Object)ex))});
            }
            this.attrTypeHintChecked.add(attrType);
        }
        for (ArtifactTypeToken childArtType : artType.getAllDescendantTypes()) {
            this.loadRemainingAtsWorkflowAttributes(prefix, childArtType);
        }
    }

    private void loadCoreAtsCodedColumns() {
        this.registerCol(new ActionableItemsColumn(this.atsApi));
        this.registerCol(new AgileFeatureGroupColumn(this.atsApi));
        this.registerCol(new AgileTeamPointsColumn(this.atsApi));
        this.registerCol(new AssigneeColumn(this.atsApi));
        this.registerCol(new AtsIdColumn(this.atsApi));
        this.registerCol(new AttachmentsCountColumn(this.atsApi));
        this.registerCol(new ChangeTypeColumn(this.atsApi));
        this.registerCol(new CheckColumn(this.atsApi));
        this.registerCol(new CompletedCancelledByColumn(this.atsApi));
        this.registerCol(new CompletedCancelledDateColumn(this.atsApi));
        this.registerCol(new CrIdColumn(this.atsApi));
        this.registerCol(new DerivedFromAtsIdColumn(this.atsApi));
        this.registerCol(new DerivedFromTeamDefColumn(this.atsApi));
        this.registerCol(new DerivedFromTaskColumn(this.atsApi));
        this.registerCol(new DerivedWorkflowColumn(this.atsApi));
        this.registerCol(new FeatureImpactReferenceColumn(this.atsApi));
        this.registerCol(new FoundInVersionColumn(this.atsApi));
        this.registerCol(new HoursSpentTotalColumn(this.atsApi));
        this.registerCol(new IdColumn(this.atsApi));
        this.registerCol(new ImplementerColumn(this.atsApi));
        this.registerCol(new IncorporatedInColumn(this.atsApi));
        this.registerCol(new InsertionActivityColumn(this.atsApi));
        this.registerCol(new InsertionColumn(this.atsApi));
        this.registerCol(new ParentTitleColumn(this.atsApi));
        this.registerCol(new PercentCompleteTasksColumn(this.atsApi));
        this.registerCol(new PrIdColumn(this.atsApi));
        this.registerCol(new PriorityColumn(this.atsApi));
        this.registerCol(new SprintOrderColumn(this.atsApi));
        this.registerCol(new StateColumn(this.atsApi));
        this.registerCol(new TargetedVersionColumn(this.atsApi));
        this.registerCol(new TaskPointsColumn(this.atsApi));
        this.registerCol(new TaskRelatedArtifactTypeColumn(this.atsApi));
        this.registerCol(new TaskRiskFactorsColumn(this.atsApi));
        this.registerCol(new TeamColumn(this.atsApi));
        this.registerCol(new TitleColumn(this.atsApi));
        this.registerCol(new TypeColumn(this.atsApi));
        this.registerCol(new WorkDefinitionColumn(this.atsApi));
    }

    private void registerCol(AtsCoreCodeColumn col) {
        if (!this.idToAtsColumn.containsKey(col.getId())) {
            this.idToAtsColumn.put(col.getId(), col);
        }
    }

    private void loadCoreAtsColumns() {
        for (AtsCoreAttrTokColumnToken atsAttrCol : AtsColumnTokensDefault.getIdToAttrValCol().values()) {
            AtsCoreAttrTokenColumn col = new AtsCoreAttrTokenColumn(atsAttrCol, "code", AtsApiService.get());
            if (this.idToAtsColumn.containsKey(atsAttrCol.getId())) continue;
            this.idToAtsColumn.put(atsAttrCol.getId(), col);
        }
    }

    private void loadCoreAtsConfigViewsColumns() {
        try {
            for (AtsCoreAttrTokColumnToken atsAttrCol : this.atsApi.getConfigService().getConfigurations().getViews().getAttrColumns()) {
                String msg = "";
                if (Strings.isInvalid((String)atsAttrCol.getName())) {
                    msg = "AtsConfig.views col name invalid for " + atsAttrCol;
                } else if (Strings.isInvalid((String)atsAttrCol.getNamespace())) {
                    msg = "AtsConfig.views col namespace invalid for " + atsAttrCol;
                } else if (Strings.isInvalid((String)atsAttrCol.getColumnType())) {
                    msg = "AtsConfig.views col columnType invalid for " + atsAttrCol;
                } else if (atsAttrCol.getAttrTypeId() <= 0L) {
                    msg = "AtsConfig.views col attrTypeId <=0 for " + atsAttrCol;
                } else if (this.atsApi.tokenService().getAttributeTypeOrSentinel(Long.valueOf(atsAttrCol.getAttrTypeId())).isInvalid()) {
                    msg = "AtsConfig.views col attrTypeId invalid for " + atsAttrCol;
                } else if (this.atsApi.tokenService().getAttributeTypeOrSentinel(Long.valueOf(atsAttrCol.getAttrTypeId())).isInvalid()) {
                    msg = "AtsConfig.views col attrTypeId invalid for " + atsAttrCol;
                } else {
                    AtsCoreAttrTokenColumn col = new AtsCoreAttrTokenColumn(atsAttrCol, "AtsConfig.views", AtsApiService.get());
                    this.idToAtsColumn.put(atsAttrCol.getId(), col);
                }
                if (!Strings.isValid((String)msg)) continue;
                this.rd.error(msg);
            }
        }
        catch (Exception ex) {
            this.rd.errorf("Exception processing AtsConfig.views %s\n", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
    }

    private void loadCoreAtsProviderColumns() {
        for (IAtsColumnProvider provider : AtsColumnProviderCollector.getColumnProviders()) {
            for (AtsCoreAttrTokColumnToken atsAttrCol : provider.getAttrValCols()) {
                if (this.idToAtsColumn.containsKey(atsAttrCol.getId())) continue;
                AtsCoreAttrTokenColumn col = new AtsCoreAttrTokenColumn(atsAttrCol, "code " + provider.getClass().getSimpleName(), AtsApiService.get());
                this.idToAtsColumn.put(atsAttrCol.getId(), col);
            }
        }
    }

    public AtsCoreAttrTokenColumn getAttributeColumn(AttributeTypeToken attrType, String source) {
        return new AtsCoreAttrTokenColumn(attrType, source, this.atsApi);
    }

    public String getColumnText(AtsCoreColumnToken column, IAtsObject atsObject) {
        return this.getColumnText(column.getId(), atsObject);
    }

    public String getColumnText(String id, IAtsObject atsObject) {
        String result = "";
        AtsCoreColumn column = this.getColumn(id);
        result = column == null ? "Unhandled Column" : column.getColumnText(atsObject);
        return result;
    }

    public String getColumnText(AtsConfigurations configurations, AtsCoreColumnToken column, IAtsObject atsObject) {
        return this.getColumnText(configurations, column.getId(), atsObject);
    }

    public String getColumnText(AtsConfigurations configurations, String id, IAtsObject atsObject) {
        String result = "";
        AtsCoreColumn column = this.getColumn(id);
        result = column == null ? "Unhandled Column" : column.getColumnText(atsObject);
        return result;
    }

    public AtsCoreColumn getColumn(AtsCoreColumnToken columnId) {
        return this.getColumn(columnId.getId());
    }

    public Collection<IAtsColumnProvider> getColumProviders() {
        return AtsColumnProviderCollector.getColumnProviders();
    }

    public Date getColumnDate(AtsCoreAttrTokColumnToken attrCol, IAtsWorkItem workItem) {
        AttributeTypeGeneric attrType = this.atsApi.tokenService().getAttributeType(Long.valueOf(attrCol.getAttrTypeId()));
        return this.getColumnDate((AttributeTypeToken)attrType, workItem);
    }

    public Date getColumnDate(AttributeTypeToken attrType, IAtsWorkItem workItem) {
        if (attrType.isInvalid() || !attrType.isDate()) {
            return null;
        }
        Date date = (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, attrType, null);
        return date;
    }

    public Collection<AtsCoreColumn> getColumns() {
        this.ensureLoaded();
        return this.idToAtsColumn.values();
    }

    public String getColumnsJson() {
        this.ensureLoaded();
        String json = JsonUtil.toJson(this.idToAtsColumn.values());
        return json;
    }

    public ColumnType getColumnType(AttributeTypeToken attributeType) {
        return AtsColumnUtil.getColumnType((AttributeTypeToken)attributeType);
    }

    public XResultData getLoadResults() {
        this.ensureLoaded();
        return this.rd;
    }

    public synchronized String getIdFromLegacyId(String legacyId) {
        if (this.legacyIdToId == null) {
            this.legacyIdToId = new HashMap<String, String>();
            this.legacyIdToId.put("ats.Category", AtsAttributeTypes.Category1.getName());
            this.legacyIdToId.put("ats.Category2", AtsAttributeTypes.Category2.getName());
            this.legacyIdToId.put("ats.Category3", AtsAttributeTypes.Category3.getName());
            this.legacyIdToId.put("ats.Priority", AtsColumnTokensDefault.PriorityColumn.getId());
            this.legacyIdToId.put("ats.column.Priority", AtsColumnTokensDefault.PriorityColumn.getId());
            this.legacyIdToId.put("ats.column.activityId", AtsAttributeTypes.ActivityId.getName());
            this.legacyIdToId.put("ats.column.applicabletoprogram", AtsAttributeTypes.ApplicableToProgram.getName());
            this.legacyIdToId.put("ats.column.cancelledDate", AtsAttributeTypes.CancelledDate.getName());
            this.legacyIdToId.put("ats.column.category", AtsAttributeTypes.Category1.getName());
            this.legacyIdToId.put("ats.column.completedBy", AtsAttributeTypes.CompletedBy.getName());
            this.legacyIdToId.put("ats.column.completedDate", AtsAttributeTypes.CompletedDate.getName());
            this.legacyIdToId.put("ats.column.createdDate", AtsAttributeTypes.CreatedDate.getName());
            this.legacyIdToId.put("ats.column.description", AtsAttributeTypes.Description.getName());
            this.legacyIdToId.put("ats.column.duplicatedpcrid", AtsAttributeTypes.DuplicatedPcrId.getName());
            this.legacyIdToId.put("ats.column.estimatedCompletionDate", AtsAttributeTypes.EstimatedCompletionDate.getName());
            this.legacyIdToId.put("ats.column.estimatedHours", AtsAttributeTypes.EstimatedHours.getName());
            this.legacyIdToId.put("ats.column.legacyPcr", AtsAttributeTypes.LegacyPcrId.getName());
            this.legacyIdToId.put("ats.column.locReviewed", AtsAttributeTypes.LocReviewed.getName());
            this.legacyIdToId.put("ats.column.notes", AtsAttributeTypes.WorkflowNotes.getName());
            this.legacyIdToId.put("ats.column.numeric1", AtsAttributeTypes.Numeric1.getName());
            this.legacyIdToId.put("ats.column.originatingpcrid", AtsAttributeTypes.OriginatingPcrId.getName());
            this.legacyIdToId.put("ats.column.pagesReviewed", AtsAttributeTypes.PagesReviewed.getName());
            this.legacyIdToId.put("ats.column.points", AtsAttributeTypes.Points.getName());
            this.legacyIdToId.put("ats.column.rationale", AtsAttributeTypes.Rationale.getName());
            this.legacyIdToId.put("ats.column.resolution", AtsAttributeTypes.Resolution.getName());
            this.legacyIdToId.put("ats.column.reviewformaltype", AtsAttributeTypes.ReviewFormalType.getName());
            this.legacyIdToId.put("ats.column.workPackageId", "ats.column.workPackage");
            this.legacyIdToId.put("ats.column.workPackageName", "ats.column.workPackage");
            this.legacyIdToId.put("ats.column.workflowPercentComplete", AtsAttributeTypes.PercentComplete.getName());
            this.legacyIdToId.put("attribute.ats.Category3", AtsAttributeTypes.Category3.getName());
            this.legacyIdToId.put("attribute.ats.Completed Date", AtsAttributeTypes.CompletedDate.getName());
            this.legacyIdToId.put("attribute.ats.Created Date", AtsAttributeTypes.CreatedDate.getName());
            this.legacyIdToId.put("attribute.ats.Description", AtsAttributeTypes.Description.getName());
            this.legacyIdToId.put("attribute.ats.End Date", AtsAttributeTypes.EndDate.getName());
            this.legacyIdToId.put("attribute.ats.Estimated Completion Date", AtsAttributeTypes.EstimatedCompletionDate.getName());
            this.legacyIdToId.put("attribute.ats.Id", "ats.id");
            this.legacyIdToId.put("attribute.ats.Id", AtsAttributeTypes.AtsId.getName());
            this.legacyIdToId.put("attribute.ats.Legacy PCR Id", AtsAttributeTypes.LegacyPcrId.getName());
            this.legacyIdToId.put("attribute.ats.Meeting Attendee", AtsAttributeTypes.MeetingAttendeeId.getName());
            this.legacyIdToId.put("attribute.ats.Meeting Date", AtsAttributeTypes.MeetingDate.getName());
            this.legacyIdToId.put("attribute.ats.Meeting Length", AtsAttributeTypes.MeetingLength.getName());
            this.legacyIdToId.put("attribute.ats.Meeting Location", AtsAttributeTypes.MeetingLocation.getName());
            this.legacyIdToId.put("attribute.ats.Need By", "ats.column.deadline");
            this.legacyIdToId.put("attribute.ats.Operational Impact Description", AtsAttributeTypes.OperationalImpactDescription.getName());
            this.legacyIdToId.put("attribute.ats.Operational Impact Workaround Description", AtsAttributeTypes.OperationalImpactDescription.getName());
            this.legacyIdToId.put("attribute.ats.Operational Impact Workaround", AtsAttributeTypes.OperationalImpactWorkaround.getName());
            this.legacyIdToId.put("attribute.ats.Operational Impact", AtsAttributeTypes.OperationalImpact.getName());
            this.legacyIdToId.put("attribute.ats.Percent Complete", AtsAttributeTypes.PercentComplete.getName());
            this.legacyIdToId.put("attribute.ats.Priority", AtsColumnTokensDefault.PriorityColumn.getId());
            this.legacyIdToId.put("attribute.ats.Review Blocks", AtsAttributeTypes.ReviewBlocks.getName());
            this.legacyIdToId.put("attribute.ats.Review Formal Type", AtsAttributeTypes.ReviewFormalType.getName());
            this.legacyIdToId.put("attribute.ats.Start Date", AtsAttributeTypes.StartDate.getName());
            this.legacyIdToId.put("ats.column.TestProcedure", CoreArtifactTypes.TestProcedure.getName());
            this.legacyIdToId.put("ats.column.cancelledReasonDetails", AtsAttributeTypes.CancelledReasonDetails.getName());
            this.legacyIdToId.put("ats.column.cancelledReason", AtsAttributeTypes.CancelledReason.getName());
            this.legacyIdToId.put("ats.column.crash.or.blank.display", AtsAttributeTypes.CrashOrBlankDisplay.getName());
            this.legacyIdToId.put("ats.column.external.reference", AtsAttributeTypes.ExternalReference.getName());
            for (IAtsColumnProvider provider : AtsColumnProviderCollector.getColumnProviders()) {
                provider.getLegacyIdToId(this.legacyIdToId);
            }
        }
        return this.legacyIdToId.get(legacyId);
    }
}

