/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.ArrayList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TeamColumn
extends AtsCoreCodeColumn {
    public TeamColumn(AtsApi atsApi) {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.TeamColumn, atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) {
        String result = "";
        if (atsObject instanceof IAtsTeamWorkflow) {
            result = ((IAtsTeamWorkflow)atsObject).getTeamDefinition().getName();
        } else if (atsObject instanceof IAtsWorkItem) {
            result = this.getColumnText((IAtsObject)((IAtsWorkItem)atsObject).getParentTeamWorkflow());
        }
        if (!Strings.isValid((String)result) && atsObject instanceof IAtsPeerToPeerReview) {
            IAtsPeerToPeerReview peerRev = (IAtsPeerToPeerReview)atsObject;
            if (this.atsApi.getReviewService().isStandAloneReview((Object)peerRev)) {
                ArrayList<IAtsTeamDefinition> teams = new ArrayList<IAtsTeamDefinition>();
                for (IAtsActionableItem ai : peerRev.getActionableItems()) {
                    if (ai.getAtsApi().getActionableItemService().getTeamDefinitionInherited(ai) == null) continue;
                    teams.add(ai.getTeamDefinition());
                }
                if (!teams.isEmpty()) {
                    result = Collections.toString((String)", ", teams);
                }
            }
        }
        return result;
    }
}

