/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class TaskRelatedArtifactTypeColumn
extends AtsCoreCodeColumn {
    private final LoadingCache<IAtsWorkItem, ArtifactTypeToken> artIdToRelatedArtTypeCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<IAtsWorkItem, ArtifactTypeToken>(){

        public ArtifactTypeToken load(IAtsWorkItem workItem) throws Exception {
            ArtifactId relatedArtId = TaskRelatedArtifactTypeColumn.this.getRelatedArtId(workItem);
            if (relatedArtId.isValid()) {
                Map results = TaskRelatedArtifactTypeColumn.this.atsApi.getStoreService().getArtifactTypes(Collections.singleton(relatedArtId), TaskRelatedArtifactTypeColumn.this.atsApi.tokenService());
                return (ArtifactTypeToken)results.values().iterator().next();
            }
            return ArtifactTypeToken.SENTINEL;
        }
    });

    public TaskRelatedArtifactTypeColumn(AtsApi atsApi) {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.TaskToRelatedArtifactTypeColumnToken, atsApi);
    }

    @Override
    protected String getText(IAtsObject atsObject) throws Exception {
        ArtifactTypeToken artifactType;
        if (atsObject instanceof IAtsWorkItem && (artifactType = (ArtifactTypeToken)this.artIdToRelatedArtTypeCache.get((Object)((IAtsWorkItem)atsObject))).isValid()) {
            return artifactType.toString();
        }
        return "";
    }

    public void populateCache(List<IAtsWorkItem> workItems) {
        HashMap<ArtifactId, IAtsWorkItem> workItemMap = new HashMap<ArtifactId, IAtsWorkItem>();
        LinkedList<ArtifactId> relatedArtIds = new LinkedList<ArtifactId>();
        for (IAtsWorkItem workItem : workItems) {
            ArtifactId relatedArtId;
            if (this.artIdToRelatedArtTypeCache.getIfPresent((Object)workItem) != null || !(relatedArtId = this.getRelatedArtId(workItem)).isValid()) continue;
            relatedArtIds.add(relatedArtId);
            workItemMap.put(relatedArtId, workItem);
        }
        if (!relatedArtIds.isEmpty()) {
            Map results = this.atsApi.getStoreService().getArtifactTypes(relatedArtIds, this.atsApi.tokenService());
            for (ArtifactId relatedArtId : relatedArtIds) {
                if (!relatedArtId.isValid()) continue;
                ArtifactTypeToken artifactType = (ArtifactTypeToken)results.get(relatedArtId);
                this.artIdToRelatedArtTypeCache.put((Object)((IAtsWorkItem)workItemMap.get(relatedArtId)), (Object)artifactType);
            }
        }
    }

    private ArtifactId getRelatedArtId(IAtsWorkItem workItem) {
        return (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactReference, (Object)ArtifactId.SENTINEL);
    }
}

