/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CompletedCancelledByColumn
extends AtsCoreCodeColumn {
    public CompletedCancelledByColumn(AtsApi atsApi) {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.CompletedCancelledByColumn, atsApi);
    }

    @Override
    protected String getText(IAtsObject atsObject) throws Exception {
        AtsUser user;
        if (atsObject instanceof IAtsWorkItem && (user = CompletedCancelledByColumn.getCompletedCancelledBy(atsObject, this.atsApi)) != null) {
            return user.getName();
        }
        return null;
    }

    public static AtsUser getCompletedCancelledBy(Object obj, AtsApi atsApi) {
        String userId = null;
        if (obj instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)obj;
            AttributeTypeString type = null;
            if (workItem.isCompleted()) {
                type = AtsAttributeTypes.CompletedBy;
            } else if (workItem.isCancelled()) {
                type = AtsAttributeTypes.CancelledBy;
            }
            if (type != null && Strings.isValid((String)(userId = (String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)((IAtsWorkItem)obj), (AttributeTypeToken)type, null)))) {
                return atsApi.getUserService().getUserByUserId(userId);
            }
        }
        return null;
    }
}

