/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile.operations;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.AgileReportType;
import org.eclipse.osee.ats.api.agile.AgileSprintData;
import org.eclipse.osee.ats.api.agile.AgileSprintDateData;
import org.eclipse.osee.ats.api.agile.IAgileSprintHtmlOperation;
import org.eclipse.osee.ats.core.agile.SprintUtil;
import org.eclipse.osee.ats.core.util.chart.LineChart;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class SprintBurndownOperations
implements IAgileSprintHtmlOperation {
    private final AtsApi atsApi;

    public SprintBurndownOperations(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public String getReportHtml(long teamId, long sprintId) {
        try {
            LineChart chart = this.getChartData(teamId, sprintId);
            if (chart.getResults().isErrors()) {
                return AHTML.simplePage((String)chart.getResults().toString().replaceAll("\n", "<br/>"));
            }
            return chart.getChart();
        }
        catch (Exception ex) {
            return AHTML.simplePage((String)Lib.exceptionToString((Exception)ex).replaceAll("\n", "<br/>"));
        }
    }

    public LineChart getChartData(long teamId, long sprintId) {
        LineChart chart = new LineChart(this.atsApi);
        ArtifactToken team = this.atsApi.getQueryService().getArtifact(Long.valueOf(teamId));
        AgileSprintData data = SprintUtil.getAgileSprintData(this.atsApi, teamId, sprintId, chart.getResults());
        XResultData results = data.validate();
        if (results.isErrors()) {
            return chart;
        }
        try {
            chart.setTitle(String.valueOf(team.getName()) + " - " + data.getSprintName() + " - Burndown");
            chart.setyAxisLabel("Points");
            chart.setxAxisLabel("Dates");
            LinkedList<String> xDateList = new LinkedList<String>();
            for (AgileSprintDateData date : data.getDates()) {
                xDateList.add("\"" + DateUtil.getMMDDYY((Date)date.getDate()) + "\"");
            }
            chart.setxAxisLabels(xDateList);
            ArrayList<Double> values = new ArrayList<Double>();
            for (AgileSprintDateData date : data.getDates()) {
                values.add(date.getGoalPoints());
            }
            chart.addLine("Total Work", values, SprintUtil.RGB_BLACK);
            ArrayList<Double> values1 = new ArrayList<Double>();
            Date today = new Date();
            for (AgileSprintDateData date : data.getDates()) {
                if (!today.after(date.getDate())) continue;
                values1.add((double)(data.getPlannedPoints() + data.getUnPlannedPoints()) - date.getCompletedPlannedPoints() - date.getCompletedUnPlannedPoints());
            }
            chart.addLine("Remaining Work", values1, SprintUtil.RGB_GREEN);
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex, "Can't return LineChart", new Object[0]);
        }
        return chart;
    }

    public AgileReportType getReportType() {
        return AgileReportType.Burn_Down;
    }
}

