/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile.jira;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.jira.AtsJiraService;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.jira.Issue;
import org.eclipse.osee.ats.api.workflow.jira.JiraSearch;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractAtsJiraService
implements AtsJiraService {
    public String TW_DESCRIPTION_SEARCH = "{ \"jql\": \"team = %s AND description ~ %s \", \"startAt\": 0, \"maxResults\": 4, \"fields\": [ \"summary\", \"description\", \"status\", \"assignee\" ] }";
    public String STORY_ID_SEARCH = "{ \"jql\": \"key = %s\" , \"startAt\": 0, \"maxResults\": 4, \"fields\": [ \"summary\", \"description\", \"status\", \"assignee\" ] }";
    protected final AtsApi atsApi;

    public AbstractAtsJiraService(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public String getStatus(IAtsTeamWorkflow teamWf) {
        String status = "";
        JiraSearch twSearch = this.search((IAtsWorkItem)teamWf);
        if (twSearch != null && twSearch.issues != null && !twSearch.issues.isEmpty()) {
            status = ((Issue)twSearch.issues.iterator().next()).fields.status.name;
        }
        return status;
    }

    public String getJiraBasePath() {
        return AtsApiService.get().getConfigValue("JiraBasepath");
    }

    public Long getJiraSprintId(IAgileSprint sprint, XResultData rd) {
        Long jiraSprintId = (Long)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.JiraSprintId, (Object)0L);
        if (jiraSprintId == 0L) {
            String sprintConfigTag = String.valueOf(AtsAttributeTypes.JiraSprintId.getName()) + "_" + sprint.getIdString();
            String sprintIdStr = AtsApiService.get().getConfigValue(sprintConfigTag);
            if (Strings.isNumeric((String)sprintIdStr)) {
                jiraSprintId = Long.valueOf(sprintIdStr);
            } else {
                rd.errorf("No JIRA SprintId Configured for Sprint %s", new Object[]{sprint.toStringWithId()});
                return null;
            }
        }
        return jiraSprintId;
    }

    public AtsUser getJiraAssignee(IAtsWorkItem workItem) {
        String userId;
        JiraSearch srch = this.search(workItem);
        if (!srch.issues.isEmpty() && srch.issues != null && Strings.isValid((String)(userId = ((Issue)srch.issues.iterator().next()).getAssigneeUserId()))) {
            AtsUser user = AtsApiService.get().getUserService().getUserByLoginId(userId);
            return user;
        }
        return AtsCoreUsers.UNASSIGNED_USER;
    }

    public JiraSearch search(IAtsWorkItem workItem) {
        try {
            String jiraStoryId = this.getJiraStoryLink(workItem);
            String json = "";
            json = Strings.isValid((String)jiraStoryId) ? this.getStorySearchJson(workItem, jiraStoryId) : this.getTwSearchJson(workItem, this.getJiraTeamId(workItem));
            String searchResults = this.searchJira(json);
            if (searchResults.contains("errorMessages")) {
                JiraSearch srch = new JiraSearch();
                srch.getRd().errorf(searchResults, new Object[0]);
                return srch;
            }
            JiraSearch srch = (JiraSearch)JsonUtil.readValue((String)searchResults, JiraSearch.class);
            return srch;
        }
        catch (Exception ex) {
            JiraSearch srch = new JiraSearch();
            srch.getRd().errorf(Lib.exceptionToString((Exception)ex), new Object[0]);
            return srch;
        }
    }

    public String getJiraStoryLink(IAtsWorkItem workItem) {
        String jiraStoryId = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.JiraStoryId, (Object)"");
        return jiraStoryId;
    }

    protected abstract String searchJira(String var1);

    public String getStorySearchJson(IAtsWorkItem workItem, String jiraStoreId) {
        String json = String.format(this.STORY_ID_SEARCH, jiraStoreId);
        return json;
    }

    public String getTwSearchJson(IAtsWorkItem workItem, Integer teamId) {
        String json = String.format(this.TW_DESCRIPTION_SEARCH, teamId.toString(), workItem.getAtsId());
        return json;
    }

    public Integer getJiraTeamId(IAtsWorkItem workItem) {
        Integer teamId = ((Long)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem.getParentTeamWorkflow().getTeamDefinition(), (AttributeTypeToken)AtsAttributeTypes.JiraTeamId, (Object)-1L)).intValue();
        if (teamId <= 0) {
            throw new OseeArgumentException("Not JIRA Team Id specified for %s", new Object[]{workItem.getParentTeamWorkflow().getTeamDefinition().toStringWithId()});
        }
        return teamId;
    }
}

