/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.disposition.model.CiSetData;
import org.eclipse.osee.disposition.model.DispoConfig;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.DispoSetStatus;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.internal.DispoConfigArtifact;
import org.eclipse.osee.disposition.rest.internal.DispoItemArtifact;
import org.eclipse.osee.disposition.rest.internal.DispoSetArtifact;
import org.eclipse.osee.disposition.rest.internal.Storage;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoverageOseeTypes;
import org.eclipse.osee.framework.core.enums.DispoOseeTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class OrcsStorageImpl
implements Storage {
    private final OrcsApi orcsApi;
    public static final BranchToken dispoParent = BranchToken.create((long)5781701693103907161L, (String)"Dispo Parent");

    public OrcsStorageImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    private QueryFactory getQuery() {
        return this.orcsApi.getQueryFactory();
    }

    private TransactionFactory getTxFactory() {
        return this.orcsApi.getTransactionFactory();
    }

    private OrcsBranch getBranchFactory() {
        return this.orcsApi.getBranchOps();
    }

    @Override
    public UserId findUser() {
        return this.orcsApi.userService().getUser();
    }

    @Override
    public UserId findUser(String userId) {
        return UserId.valueOf((String)userId);
    }

    @Override
    public boolean isUniqueProgramName(String name) {
        return ((BranchQuery)this.getQuery().branchQuery().andNameEquals(name)).getResults().isEmpty();
    }

    @Override
    public boolean isUniqueSetName(BranchId branch, String name) {
        ResultSet results = this.getQuery().fromBranch(branch).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.DispositionSet}).andNameEquals(name).getResults();
        return results.isEmpty();
    }

    @Override
    public boolean isUniqueItemName(BranchId branch, String setId, String name) {
        ArtifactReadable setArt = this.findDispoArtifact(branch, setId);
        ResultSet results = this.getQuery().fromBranch(branch).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)setArt).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.DispositionableItem}).andNameEquals(name).getResults();
        return results.isEmpty();
    }

    @Override
    public BranchToken findDispoProgramIdByName(String branchName) {
        List<BranchToken> dispoPrograms = this.getDispoBranches();
        BranchToken branchId = null;
        String allItems = "";
        int count = 0;
        for (BranchToken branch : dispoPrograms) {
            if (!branch.getName().equals(branchName)) continue;
            allItems = String.valueOf(allItems) + branch.getIdString() + '\n';
            ++count;
            branchId = branch;
        }
        if (count > 1) {
            throw new OseeCoreException("Multiple items found - total [%s]\n%s", new Object[]{count, allItems});
        }
        if (count < 1) {
            throw new OseeCoreException("No item found", new Object[0]);
        }
        return branchId;
    }

    @Override
    public String findDispoSetIdByName(BranchId branchId, String setName) {
        List<DispoSet> dispoSets = this.findDispoSets(branchId, "codeCoverage");
        for (DispoSet set : dispoSets) {
            if (!set.getName().equals(setName)) continue;
            return (String)set.getGuid();
        }
        return null;
    }

    @Override
    public List<DispoSet> findDispoSets(BranchId branch, String type) {
        ResultSet results = this.getQuery().fromBranch(branch).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.DispositionSet}).getResults();
        ArrayList<DispoSet> toReturn = new ArrayList<DispoSet>();
        for (ArtifactReadable art : results) {
            DispoSetArtifact dispoSetArt = new DispoSetArtifact(art);
            if (!dispoSetArt.getDispoType().equals(type)) continue;
            toReturn.add(dispoSetArt);
        }
        return toReturn;
    }

    @Override
    public List<String> getDispoSets(BranchId branch, String type) {
        ResultSet results = this.getQuery().fromBranch(branch).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.DispositionSet}).getResults();
        ArrayList<String> toReturn = new ArrayList<String>();
        for (ArtifactReadable art : results) {
            DispoSetArtifact dispoSetArt = new DispoSetArtifact(art);
            if (!dispoSetArt.getDispoType().equals(type)) continue;
            toReturn.add(dispoSetArt.getName());
        }
        return toReturn;
    }

    @Override
    public ArtifactReadable findSetArtifact(BranchId branch, String setId) {
        return this.findDispoArtifact(branch, setId);
    }

    @Override
    public DispoSet findDispoSetsById(BranchId branch, String setId) {
        ArtifactReadable result = this.findDispoArtifact(branch, setId);
        return new DispoSetArtifact(result);
    }

    private ArtifactReadable findDispoArtifact(BranchId branch, String artId) {
        return (ArtifactReadable)this.getQuery().fromBranch(branch).andUuid(Long.valueOf(artId).longValue()).getResults().getExactlyOne();
    }

    @Override
    public List<ArtifactReadable> findItemArtifacts(BranchId branch, String setId) {
        ArtifactReadable setArt = this.findDispoArtifact(branch, setId);
        ArrayList<ArtifactReadable> toReturn = new ArrayList<ArtifactReadable>();
        for (ArtifactReadable art : setArt.getChildren()) {
            toReturn.add(art);
        }
        return toReturn;
    }

    @Override
    public List<DispoItem> findDispoItems(BranchId branch, String setId, boolean isDetailed) {
        ArtifactReadable setArt = this.findDispoArtifact(branch, setId);
        ArrayList<DispoItem> toReturn = new ArrayList<DispoItem>();
        for (ArtifactReadable art : setArt.getChildren()) {
            DispoItemArtifact dispoItemArtifact = new DispoItemArtifact(art);
            dispoItemArtifact.setIsIncludeDetails(isDetailed);
            toReturn.add(dispoItemArtifact);
        }
        return toReturn;
    }

    @Override
    public Long createDispoProgram(String name) {
        BranchToken branch = BranchToken.create((String)name);
        this.getBranchFactory().createWorkingBranch(branch, dispoParent, ArtifactId.SENTINEL);
        return branch.getId();
    }

    @Override
    public ArtifactId createSet(BranchId branch, String importPath, String setName, String partitionName) {
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, "Create Dispo Set");
        ArtifactToken creatdArtId = tx.createArtifact(CoreArtifactTypes.DispositionSet, setName);
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoveragePartition, (Object)partitionName);
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageImportPath, (Object)importPath);
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageImportApi, (Object)importPath);
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageImportState, (Object)DispoSetStatus.NONE);
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoOseeTypes.CoverageConfig, (Object)"codeCoverage");
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageNotesJson, (Object)JsonUtil.toJson((Object)""));
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageImportDate, (Object)new Date());
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageRerunList, (Object)"");
        tx.commit();
        return creatdArtId;
    }

    @Override
    public ArtifactId createDispoSet(BranchId branch, DispoSet descriptor) {
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, "Create Dispo Set");
        ArtifactToken creatdArtId = tx.createArtifact(CoreArtifactTypes.DispositionSet, descriptor.getName());
        if (descriptor.getDispoType().equals("codeCoverage")) {
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoveragePartition, (Object)descriptor.getCoveragePartition());
        }
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageImportApi, (Object)descriptor.getImportPath());
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageImportPath, (Object)descriptor.getImportPath());
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageImportState, (Object)descriptor.getImportState());
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoOseeTypes.CoverageConfig, (Object)descriptor.getDispoType());
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageNotesJson, (Object)JsonUtil.toJson((Object)descriptor.getNotesList()));
        if (descriptor.getCiSet() == null) {
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoOseeTypes.DispoCiSet, (Object)"NOCI");
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageRerunList, (Object)"NOCI");
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageImportDate, (Object)new Date());
        } else {
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoOseeTypes.DispoCiSet, (Object)descriptor.getCiSet());
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageRerunList, (Object)descriptor.getRerunList());
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)CoreAttributeTypes.CoverageImportDate, (Object)descriptor.getTime());
        }
        tx.commit();
        return creatdArtId;
    }

    @Override
    public boolean deleteDispoSet(BranchId branch, String setId) {
        return this.deleteDispoEntityArtifact(branch, setId, CoreArtifactTypes.DispositionSet);
    }

    @Override
    public boolean deleteDispoItem(BranchId branch, String itemId) {
        return this.deleteDispoEntityArtifact(branch, itemId, CoreArtifactTypes.DispositionableItem);
    }

    private boolean deleteDispoEntityArtifact(BranchId branch, String entityId, ArtifactTypeToken type) {
        boolean toReturn = false;
        ArtifactReadable dispoArtifact = this.findDispoArtifact(branch, entityId);
        if (dispoArtifact != null) {
            TransactionBuilder tx = this.getTxFactory().createTransaction(branch, "Delete Dispo Artifact");
            tx.deleteArtifact((ArtifactId)dispoArtifact);
            tx.commit();
            toReturn = true;
        }
        return toReturn;
    }

    @Override
    public void updateOrCreateServerImportPath(BranchId branch, DispoSet setId, String localImportPath) {
        ArtifactReadable dispoSet = this.findDispoArtifact(branch, setId.getIdString());
        DispoSetArtifact origSetAs = new DispoSetArtifact(dispoSet);
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, "Update Local Import Path for Coverage Set");
        if (!setId.serverImportPathExists()) {
            tx.createAttribute((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoverageImportApi, (Object)localImportPath);
        } else if (localImportPath != null && !localImportPath.equals(origSetAs.getCoverageImportApi())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoverageImportApi, localImportPath);
        }
        tx.commit();
    }

    @Override
    public void updateDispoSet(BranchId branch, String setId, DispoSet newData) {
        ArtifactReadable dispoSet = this.findDispoArtifact(branch, setId);
        DispoSetArtifact origSetAs = new DispoSetArtifact(dispoSet);
        String name = newData.getName();
        String importPath = newData.getImportPath();
        String coverageImportApi = newData.getCoverageImportApi();
        String coveragePartition = newData.getCoveragePartition();
        String ciSet = newData.getCiSet();
        String rerunList = newData.getRerunList();
        Date time = newData.getTime();
        List notesList = new LinkedList();
        if (newData.getNotesList() != null) {
            notesList = newData.getNotesList();
        }
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, "Update Dispo Set");
        if (name != null && !name.equals(origSetAs.getName())) {
            tx.setName((ArtifactId)dispoSet, name);
        }
        if (importPath != null && !importPath.equals(origSetAs.getImportPath())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoverageImportPath, importPath);
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoverageImportApi, importPath);
        }
        if (coverageImportApi != null && !coverageImportApi.equals(origSetAs.getCoverageImportApi())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoverageImportApi, coverageImportApi);
        }
        if (coveragePartition != null && !coveragePartition.equals(origSetAs.getCoveragePartition())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoveragePartition, coveragePartition);
        }
        if (notesList != null && !notesList.equals(origSetAs.getNotesList())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoverageNotesJson, JsonUtil.toJson(origSetAs.getNotesList()));
        }
        if (ciSet != null && !ciSet.equals(origSetAs.getCiSet())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)DispoOseeTypes.DispoCiSet, ciSet);
        }
        if (rerunList != null && !rerunList.equals(origSetAs.getRerunList())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoverageRerunList, rerunList);
        }
        if (time != null && !time.equals(origSetAs.getTime())) {
            tx.setSoleAttributeValue((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoverageImportDate, (Object)time);
        }
        tx.commit();
    }

    @Override
    public void createDispoItem(BranchId branch, DispoSet parentSet, DispoItem data) {
        ArtifactReadable parentSetArt = this.findDispoArtifact(branch, (String)parentSet.getGuid());
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, "Create Dispoable Item");
        ArtifactToken createdItem = tx.createArtifact(CoreArtifactTypes.DispositionableItem, data.getName());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageCreatedDate, (Object)data.getCreationDate());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageLastUpdated, (Object)data.getLastUpdate());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageStatus, (Object)data.getStatus());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageTotalPoints, (Object)data.getTotalPoints());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageNeedsRerun, (Object)data.getNeedsRerun());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoOseeTypes.DispoItemAborted, (Object)data.getAborted());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageDiscrepanciesJson, (Object)JsonUtil.toJson((Object)data.getDiscrepanciesList()));
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageAnnotationsJson, (Object)JsonUtil.toJson((Object)data.getAnnotationsList()));
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoOseeTypes.DispoItemVersion, (Object)data.getVersion());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageAssignee, (Object)data.getAssignee());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoOseeTypes.DispoItemMachine, (Object)data.getMachine());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoOseeTypes.CoverageItemCategory, (Object)data.getCategory());
        tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoOseeTypes.DispoItemElapsedTime, (Object)data.getElapsedTime());
        if (Strings.isValid((String)data.getFileNumber())) {
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageFileNumber, (Object)data.getFileNumber());
        }
        if (Strings.isValid((String)data.getMethodNumber())) {
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageMethodNumber, (Object)data.getMethodNumber());
        }
        tx.relate((ArtifactId)parentSetArt, (RelationTypeToken)CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)createdItem);
        tx.commit();
    }

    @Override
    public void createDispoItems(BranchId branch, DispoSet parentSet, List<DispoItem> data) {
        ArtifactReadable parentSetArt = this.findDispoArtifact(branch, (String)parentSet.getGuid());
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, "Create Dispoable Item");
        for (DispoItem item : data) {
            ArtifactToken createdItem = tx.createArtifact(CoreArtifactTypes.DispositionableItem, item.getName());
            if (item.getCreationDate() == null) {
                tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageCreatedDate, (Object)new Date());
            } else {
                tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageCreatedDate, (Object)item.getCreationDate());
            }
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageLastUpdated, (Object)item.getLastUpdate());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageStatus, (Object)item.getStatus());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageTotalPoints, (Object)item.getTotalPoints());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageNeedsRerun, (Object)item.getNeedsRerun());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoOseeTypes.DispoItemAborted, (Object)item.getAborted());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageDiscrepanciesJson, (Object)JsonUtil.toJson((Object)item.getDiscrepanciesList()));
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageAnnotationsJson, (Object)JsonUtil.toJson((Object)item.getAnnotationsList()));
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoOseeTypes.DispoItemVersion, (Object)item.getVersion());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageAssignee, (Object)item.getAssignee());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoOseeTypes.DispoItemMachine, (Object)item.getMachine());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoOseeTypes.CoverageItemCategory, (Object)item.getCategory());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoOseeTypes.DispoItemElapsedTime, (Object)item.getElapsedTime());
            if (Strings.isValid((String)item.getFileNumber())) {
                tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageFileNumber, (Object)item.getFileNumber());
            }
            if (Strings.isValid((String)item.getMethodNumber())) {
                tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)CoreAttributeTypes.CoverageMethodNumber, (Object)item.getMethodNumber());
            }
            tx.relate((ArtifactId)parentSetArt, (RelationTypeToken)CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)createdItem);
        }
        tx.commit();
    }

    private void updateSingleItem(ArtifactReadable currentItemArt, DispoItem newItemData, TransactionBuilder tx, boolean resetRerunFlag, boolean isImport) {
        Date lastUpdate = newItemData.getLastUpdate();
        String name = newItemData.getName();
        Map newDiscrepancies = newItemData.getDiscrepanciesList();
        List newAnnotations = newItemData.getAnnotationsList();
        String status = newItemData.getStatus();
        String assignee = newItemData.getAssignee();
        String totalPoints = newItemData.getTotalPoints();
        String machine = newItemData.getMachine();
        String category = newItemData.getCategory();
        String elapsedTime = newItemData.getElapsedTime();
        Boolean aborted = newItemData.getAborted();
        String itemNotes = newItemData.getItemNotes();
        String fileNumber = newItemData.getFileNumber();
        String methodNumber = newItemData.getMethodNumber();
        String team = newItemData.getTeam();
        Boolean needsRerun = resetRerunFlag ? Boolean.valueOf(false) : newItemData.getNeedsRerun();
        DispoItemArtifact origItem = new DispoItemArtifact(currentItemArt);
        if (name != null && !name.equals(origItem.getName())) {
            tx.setName((ArtifactId)currentItemArt, name);
        }
        if (newDiscrepancies != null && !newDiscrepancies.equals(origItem.getDiscrepanciesList())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageDiscrepanciesJson, JsonUtil.toJson((Object)newDiscrepancies));
        }
        if (newAnnotations != null && !newAnnotations.equals(origItem.getAnnotationsList())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageAnnotationsJson, JsonUtil.toJson((Object)newAnnotations));
        }
        if (assignee != null && !assignee.equals("UnAssigned") && !assignee.equals(origItem.getAssignee())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageAssignee, assignee);
        }
        if (status != null && !status.equals("Unspecified") && !status.equals(origItem.getStatus())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageStatus, status);
        }
        if (lastUpdate != null && !lastUpdate.equals(origItem.getLastUpdate())) {
            tx.setSoleAttributeValue((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageLastUpdated, (Object)lastUpdate);
        }
        if (needsRerun != null && !needsRerun.equals(origItem.getNeedsRerun())) {
            tx.setSoleAttributeValue((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageNeedsRerun, (Object)needsRerun);
        }
        if (totalPoints != null && !totalPoints.equals("0.0") && !totalPoints.equals(origItem.getTotalPoints())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageTotalPoints, totalPoints);
        }
        if (machine != null && !machine.equals("n/a") && !machine.equals(origItem.getMachine())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoOseeTypes.DispoItemMachine, machine);
        }
        if (category != null && !category.isEmpty() && !category.equals(origItem.getCategory())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoOseeTypes.CoverageItemCategory, category);
        }
        if (elapsedTime != null && elapsedTime.equals("0.0") && !elapsedTime.equals(origItem.getElapsedTime())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoOseeTypes.DispoItemElapsedTime, elapsedTime);
        }
        if (aborted != null && !aborted.equals(origItem.getAborted())) {
            tx.setSoleAttributeValue((ArtifactId)currentItemArt, (AttributeTypeToken)DispoOseeTypes.DispoItemAborted, (Object)aborted);
        }
        if (!isImport && itemNotes != null && !itemNotes.equals(origItem.getItemNotes())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageNotes, itemNotes);
        } else if (isImport && itemNotes != null && (origItem.getItemNotes().equals("none") || origItem.getItemNotes().isEmpty())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageNotes, itemNotes);
        }
        if (fileNumber != null && !fileNumber.equals(origItem.getFileNumber())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageFileNumber, fileNumber);
        }
        if (methodNumber != null && !methodNumber.equals(origItem.getMethodNumber())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageMethodNumber, methodNumber);
        }
        if (team != null && !team.equals(origItem.getTeam())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageTeam, team);
        }
    }

    @Override
    public void updateDispoItem(BranchId branch, String dispoItemId, DispoItem data) {
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, "Update Dispo Item");
        ArtifactReadable dispoItemArt = this.findDispoArtifact(branch, dispoItemId);
        this.updateSingleItem(dispoItemArt, data, tx, false, false);
        tx.commit();
    }

    @Override
    public void updateDispoItems(BranchId branch, Collection<DispoItem> data, boolean resetRerunFlag, String operation) {
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, operation);
        boolean isImport = false;
        if (operation.equals("Import")) {
            isImport = true;
        }
        boolean isCommitNeeded = false;
        for (DispoItem newItem : data) {
            String itemId = (String)newItem.getGuid();
            if (!Strings.isValid((String)itemId)) continue;
            isCommitNeeded = true;
            ArtifactReadable dispoItemArt = this.findDispoArtifact(branch, (String)newItem.getGuid());
            this.updateSingleItem(dispoItemArt, newItem, tx, resetRerunFlag, isImport);
        }
        if (isCommitNeeded) {
            tx.commit();
        }
    }

    @Override
    public List<BranchToken> getDispoBranches() {
        ArrayList<BranchToken> dispoBranchesNormalized = new ArrayList<BranchToken>();
        ResultSet dispoBranches = ((BranchQuery)((BranchQuery)this.getQuery().branchQuery().andIsOfType(new BranchType[]{BranchType.WORKING})).andIsChildOf((BranchId)dispoParent)).getResultsAsId();
        for (BranchToken branch : dispoBranches) {
            BranchToken newName = BranchToken.create((BranchId)branch, (String)branch.getName().replaceFirst("\\(DISPO\\)", ""));
            dispoBranchesNormalized.add(newName);
        }
        return dispoBranchesNormalized;
    }

    @Override
    public List<String> getDispoBranchNames() {
        ArrayList<String> dispoBranchNames = new ArrayList<String>();
        ResultSet dispoBranches = ((BranchQuery)((BranchQuery)this.getQuery().branchQuery().andIsOfType(new BranchType[]{BranchType.WORKING})).andIsChildOf((BranchId)dispoParent)).getResultsAsId();
        for (BranchToken branch : dispoBranches) {
            dispoBranchNames.add(branch.getName().replaceFirst("\\(DISPO\\)", ""));
        }
        return dispoBranchNames;
    }

    @Override
    public List<String> getCheckedReruns(HashMap<String, DispoItem> items, String setId) {
        return Named.getNames(items.values(), DispoItem::getNeedsRerun);
    }

    @Override
    public Collection<DispoItem> findDispoItemByAnnoationText(BranchId branch, String setId, String keyword, boolean isDetailed) {
        ArtifactReadable dispoSetArt = this.findDispoArtifact(branch, setId);
        HashSet<DispoItem> toReturn = new HashSet<DispoItem>();
        ResultSet dispoArtifacts = this.getQuery().fromBranch(branch).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.DispositionableItem}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)dispoSetArt).and((AttributeTypeToken)CoreAttributeTypes.CoverageAnnotationsJson, keyword, QueryOption.CONTAINS_MATCH_OPTIONS).getResults();
        for (ArtifactReadable art : dispoArtifacts) {
            DispoItemArtifact dispoItem = new DispoItemArtifact(art);
            dispoItem.setIsIncludeDetails(isDetailed);
            toReturn.add(dispoItem);
        }
        return toReturn;
    }

    @Override
    public @NonNull DispoItem findDispoItemById(BranchId branch, String itemId) {
        DispoItemArtifact toReturn = null;
        ArtifactReadable dispoArtifact = this.findDispoArtifact(branch, itemId);
        toReturn = new DispoItemArtifact(dispoArtifact);
        return toReturn;
    }

    @Override
    public String findDispoItemIdByName(BranchId branchId, String setId, String itemName) {
        List<DispoItem> dispoItems = this.findDispoItems(branchId, setId, false);
        for (DispoItem item : dispoItems) {
            if (!item.getName().equals(itemName)) continue;
            return (String)item.getGuid();
        }
        return null;
    }

    @Override
    public DispoConfig findDispoConfig(BranchId branch) {
        ArtifactReadable config = this.getQuery().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.CoverageProgram}).andNameEquals("Coverage Config").asArtifactOrSentinel();
        if (!config.isValid()) {
            config = (ArtifactReadable)this.getQuery().fromBranch(branch).andNameEquals("Program Config").getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        }
        if (config.isInvalid()) {
            return DispoUtil.getDefaultConfig();
        }
        return DispoUtil.configArtToConfigData(new DispoConfigArtifact(config));
    }

    @Override
    public String createDispoReport(BranchId branch, String contents, String operationTitle) {
        String toReturn = "";
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, "Update Report: " + operationTitle);
        ArtifactReadable reportArt = (ArtifactReadable)this.getQuery().fromBranch(branch).andNameEquals("Dispo_Report").getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (reportArt.isInvalid()) {
            TransactionBuilder txToCreate = this.getTxFactory().createTransaction(branch, "Add Operation Report Art");
            txToCreate.createArtifact(CoreArtifactTypes.GeneralData, "Dispo_Report");
            txToCreate.commit();
            reportArt = (ArtifactReadable)this.getQuery().fromBranch(branch).andNameEquals("Dispo_Report").getResults().getExactlyOne();
        }
        tx.setSoleAttributeFromString((ArtifactId)reportArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, contents);
        TransactionToken commit = tx.commit();
        if (commit.isValid()) {
            ArtifactReadable newRerpotArt = (ArtifactReadable)this.getQuery().fromBranch(branch).fromTransaction((TransactionId)commit).andId((ArtifactId)reportArt).getResults().getExactlyOne();
            AttributeReadable contentsAsAttribute = (AttributeReadable)newRerpotArt.getAttributes((AttributeTypeToken)CoreAttributeTypes.GeneralStringData).getExactlyOne();
            toReturn = String.format("/orcs/branch/%s/artifact/%s/attribute/%s/version/%s", branch, newRerpotArt.getGuid(), contentsAsAttribute.getId(), commit.getId());
        }
        return toReturn;
    }

    @Override
    public Map<String, ArtifactReadable> getCoverageUnits(BranchId branchId, Long artifactUuid) {
        ArtifactReadable coveragePackage = (ArtifactReadable)this.getQuery().fromBranch(branchId).andUuid(artifactUuid.longValue()).getResults().getExactlyOne();
        List descendants = coveragePackage.getDescendants();
        return this.getChildrenRecurse(descendants);
    }

    private Map<String, ArtifactReadable> getChildrenRecurse(List<ArtifactReadable> descendants) {
        HashMap<String, ArtifactReadable> toReturn = new HashMap<String, ArtifactReadable>();
        for (ArtifactReadable descendant : descendants) {
            if (descendant.getAttributeValues((AttributeTypeToken)CoverageOseeTypes.CoverageItem).isEmpty()) continue;
            ArtifactReadable parent = descendant.getParent();
            String fullName = String.format("%s.%s", parent.getName(), descendant.getName());
            toReturn.put(fullName, descendant);
        }
        return toReturn;
    }

    @Override
    public void updateOperationSummary(BranchId branch, String setId, OperationReport summary) {
        OperationReport newReport = DispoUtil.cleanOperationReport(summary);
        ArtifactReadable dispoSet = this.findDispoArtifact(branch, setId);
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, "Update Dispo Operation Report");
        tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoverageImportState, newReport.getStatus().getName());
        tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)CoreAttributeTypes.CoverageOperationSummary, DispoUtil.operationReportToString(newReport));
        tx.commit();
    }

    @Override
    public ArtifactId getDispoItemParentSet(BranchId branch, String itemId) {
        ArtifactReadable artifact = this.findDispoArtifact(branch, itemId);
        return artifact.getParent();
    }

    @Override
    public HashMap<ArtifactReadable, BranchId> getCiSet(CiSetData setData) {
        HashMap<ArtifactReadable, BranchId> set = new HashMap<ArtifactReadable, BranchId>();
        BranchId branch = BranchId.valueOf((String)setData.getBranchId());
        List<ArtifactReadable> arts = this.findDispoSet(branch, ArtifactId.valueOf((String)setData.getDispoSetId()));
        for (ArtifactReadable art : arts) {
            set.put(art, branch);
        }
        return set;
    }

    @Override
    public String getDispoItemId(BranchId branch, String setId, String item) {
        ArtifactReadable DispoSet2 = (ArtifactReadable)this.getQuery().fromBranch(branch).andId(ArtifactId.valueOf((String)setId)).getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (DispoSet2.isInvalid()) {
            return "";
        }
        for (ArtifactReadable child : DispoSet2.getChildren()) {
            if (!child.getName().equals(item)) continue;
            return child.getIdString();
        }
        return "";
    }

    @Override
    public List<CiSetData> getAllCiSets() {
        ArrayList<CiSetData> setData = new ArrayList<CiSetData>();
        List<Branch> dispoBranches = this.findDispoBranches();
        for (BranchId branchId : dispoBranches) {
            for (ArtifactReadable dispoSet : this.findAllCiSets(branchId)) {
                String ciSet = (String)dispoSet.getSoleAttributeValue((AttributeTypeToken)DispoOseeTypes.DispoCiSet, (Object)"");
                if (ciSet.isEmpty()) continue;
                CiSetData set = new CiSetData();
                set.setBranchId(branchId.getIdString());
                set.setDispoSetId(dispoSet.getIdString());
                set.setCiSetName(ciSet);
                setData.add(set);
            }
        }
        return setData;
    }

    private List<ArtifactReadable> findDispoSet(BranchId branch, ArtifactId setId) {
        return this.getQuery().fromBranch(branch).andId(setId).getResults().getList();
    }

    private List<Branch> findDispoBranches() {
        Branch dispoParent = (Branch)((BranchQuery)this.getQuery().branchQuery().andNameEquals("Dispo Parent")).getResults().getOneOrDefault((Object)Branch.SENTINEL);
        return ((BranchQuery)((BranchQuery)((BranchQuery)this.getQuery().branchQuery().andIsChildOf((BranchId)dispoParent)).excludeArchived()).excludeDeleted()).getResults().getList();
    }

    private List<ArtifactReadable> findAllCiSets(BranchId branch) {
        return this.getQuery().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.DispositionSet}).andExists(new AttributeTypeToken[]{DispoOseeTypes.DispoCiSet}).getResults().getList();
    }

    @Override
    public UserId findUserByName(String name) {
        ArtifactToken userArtId = this.getQuery().fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andNameEquals(name).asArtifactTokenOrSentinel();
        UserId user = UserId.valueOf((ArtifactId)userArtId);
        if (user.isInvalid()) {
            user = this.findUser();
        }
        return user;
    }
}

