/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.Date;
import java.util.List;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.Note;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DispoOseeTypes;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;

public class DispoSetArtifact
extends BaseIdentity<String>
implements DispoSet {
    private final ArtifactReadable artifact;

    public DispoSetArtifact(ArtifactReadable artifact) {
        super((Object)artifact.getIdString());
        this.artifact = artifact;
    }

    public String getIdString() {
        return this.artifact.getIdString();
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getImportPath() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageImportPath);
    }

    public String getCoveragePartition() {
        if (this.artifact.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.CoveragePartition) == 1) {
            return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoveragePartition);
        }
        return "";
    }

    public String getCoverageImportApi() {
        if (this.artifact.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.CoverageImportApi) == 1) {
            return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageImportApi);
        }
        return "";
    }

    public boolean serverImportPathExists() {
        return this.artifact.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.CoverageImportApi) == 1;
    }

    public List<Note> getNotesList() {
        String notesJson = this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageNotesJson, "[]");
        return DispoUtil.jsonStringToList(notesJson, Note.class);
    }

    public OperationReport getOperationSummary() {
        String operationSummaryJson = this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageOperationSummary, "{}");
        return DispoUtil.jsonObjToOperationSummary(operationSummaryJson);
    }

    public String toString() {
        return this.getName();
    }

    public String getImportState() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageImportState, "None");
    }

    public String getDispoType() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoOseeTypes.CoverageConfig, "");
    }

    public String getCiSet() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoOseeTypes.DispoCiSet, "");
    }

    public String getRerunList() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageRerunList, "");
    }

    public Date getTime() {
        return (Date)this.artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.CoverageImportDate, null);
    }
}

