/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.disposition.model.CiItemData;
import org.eclipse.osee.disposition.model.CiSetData;
import org.eclipse.osee.disposition.model.CopySetParams;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoConfig;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.DispoSetData;
import org.eclipse.osee.disposition.model.DispoSetDescriptorData;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.Note;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.DispoApiConfiguration;
import org.eclipse.osee.disposition.rest.DispoImporterApi;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.DispoDataFactory;
import org.eclipse.osee.disposition.rest.internal.DispoQuery;
import org.eclipse.osee.disposition.rest.internal.DispoResolutionValidator;
import org.eclipse.osee.disposition.rest.internal.DispoWriter;
import org.eclipse.osee.disposition.rest.internal.OrcsStorageImpl;
import org.eclipse.osee.disposition.rest.internal.Storage;
import org.eclipse.osee.disposition.rest.internal.importer.DispoImporterFactory;
import org.eclipse.osee.disposition.rest.internal.importer.DispoSetCopier;
import org.eclipse.osee.disposition.rest.internal.importer.coverage.CoverageAdapter;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DispoOseeTypes;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Zip;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class DispoApiImpl
implements DispoApi {
    private final Date newDate = new Date();
    private Storage storage;
    private ExecutorAdmin executor;
    private Log logger;
    private DispoDataFactory dataFactory;
    private DispoConnector dispoConnector;
    private DispoResolutionValidator resolutionValidator;
    private DispoImporterFactory importerFactory;
    private OrcsApi orcsApi;
    private AtsApi atsApi;
    private static final Pattern gitlabApiPattern = Pattern.compile("^.*projects.*?jobs.*?artifacts/?$");
    private volatile DispoApiConfiguration config;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setAtsApi(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    @Override
    public DispoApiConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(DispoApiConfiguration config) {
        this.config = config;
    }

    public void setExecutor(ExecutorAdmin executor) {
        this.executor = executor;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setDataFactory(DispoDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public void setDispoConnector(DispoConnector dispoConnector) {
        this.dispoConnector = dispoConnector;
    }

    public void setResolutionValidator(DispoResolutionValidator resolutionValidator) {
        this.resolutionValidator = resolutionValidator;
    }

    public void setStorageForTest(Storage storage) {
        this.storage = storage;
    }

    public void start(Map<String, Object> props) {
        this.logger.trace("Starting DispoApiImpl...", new Object[0]);
        this.update(props);
        this.importerFactory = new DispoImporterFactory(this.dataFactory, this.executor, this.config, this.logger, this.orcsApi.jaxRsApi());
        this.storage = new OrcsStorageImpl(this.orcsApi);
    }

    public void update(Map<String, Object> props) {
        this.logger.trace("Configuring [%s]...", new Object[]{this.getClass().getSimpleName()});
        this.setConfig(DispoApiConfiguration.newConfig(props));
    }

    public void stop() {
        this.logger.trace("Stopping DispoApiImpl...", new Object[0]);
    }

    private DispoQuery getQuery() {
        return this.storage;
    }

    private DispoWriter getWriter() {
        return this.storage;
    }

    @Override
    public Long createDispoProgram(String name) {
        return this.getWriter().createDispoProgram(name);
    }

    @Override
    public ArtifactId createSet(BranchId branch, String importPath, String setName, String partitionName) {
        return this.getWriter().createSet(branch, importPath, setName, partitionName);
    }

    @Override
    public ArtifactId createDispoSet(BranchId branch, DispoSetDescriptorData descriptor) {
        DispoSetData newSet = this.dataFactory.creteSetDataFromDescriptor(descriptor);
        return this.getWriter().createDispoSet(branch, (DispoSet)newSet);
    }

    private void createDispoItems(BranchId branch, String setId, List<DispoItem> dispoItems) {
        DispoSet parentSet = this.getQuery().findDispoSetsById(branch, setId);
        if (parentSet != null) {
            this.getWriter().createDispoItems(branch, parentSet, dispoItems);
        }
    }

    @Override
    public String createDispoAnnotation(BranchId branch, String itemId, DispoAnnotationData annotationToCreate, String userName, boolean isCi) {
        String idOfNewAnnotation = "";
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            List annotationsList = dispoItem.getAnnotationsList();
            this.dataFactory.initAnnotation(annotationToCreate);
            idOfNewAnnotation = this.dataFactory.getNewId();
            annotationToCreate.setId(idOfNewAnnotation);
            int indexOfAnnotation = annotationsList.size();
            annotationToCreate.setIndex(indexOfAnnotation);
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            this.dispoConnector.connectAnnotation(annotationToCreate, discrepanciesList);
            annotationsList.add(indexOfAnnotation, annotationToCreate);
            DispoItem updatedItem = this.dataFactory.createUpdatedItem(annotationsList, discrepanciesList);
            this.getQuery().findUserByName(userName);
            this.getWriter().updateDispoItem(branch, (String)dispoItem.getGuid(), updatedItem);
        }
        return idOfNewAnnotation;
    }

    @Override
    public void editDispoSet(BranchId branch, String setId, DispoSetData newSet) {
        DispoSet dispSetToEdit = this.getQuery().findDispoSetsById(branch, setId);
        if (dispSetToEdit != null) {
            if (newSet.getOperation() != null) {
                this.runOperation(branch, dispSetToEdit, newSet, false);
            } else {
                this.getWriter().updateDispoSet(branch, (String)dispSetToEdit.getGuid(), (DispoSet)newSet);
            }
        }
    }

    @Override
    public void importDispoSet(BranchId branch, String dispoSetId) {
        DispoSet dispSetToEdit = this.getQuery().findDispoSetsById(branch, dispoSetId);
        if (dispSetToEdit != null) {
            String operation = "Import";
            DispoSetData newSet = new DispoSetData();
            newSet.setOperation(operation);
            this.runOperation(branch, dispSetToEdit, newSet, false);
        }
    }

    @Override
    public void importDispoSet(BranchId branch, String dispoSetId, String coverageImportApi, String partition) {
        DispoSet dispSetToEdit = this.getQuery().findDispoSetsById(branch, dispoSetId);
        if (dispSetToEdit != null) {
            String operation = "Import";
            DispoSetData newSet = new DispoSetData();
            boolean editImportInfo = false;
            String currPartition = dispSetToEdit.getCoveragePartition();
            String currImportApi = dispSetToEdit.getCoverageImportApi();
            newSet.setOperation(operation);
            if (currPartition == null || !partition.equals(currPartition)) {
                editImportInfo = true;
                newSet.setCoveragePartition(partition);
            }
            if (currImportApi == null || !coverageImportApi.equals(currImportApi)) {
                editImportInfo = true;
                newSet.setCoverageImportApi(coverageImportApi);
            }
            if (editImportInfo) {
                this.getWriter().updateDispoSet(branch, (String)dispSetToEdit.getGuid(), (DispoSet)newSet);
            }
            this.runOperation(branch, dispSetToEdit, newSet, false);
        }
    }

    @Override
    public void importAllDispoSets(BranchId branch, String filterState) {
        List<Object> dispoSets = new ArrayList();
        dispoSets = this.getDispoSets(branch, "codeCoverage");
        if (filterState.isEmpty()) {
            filterState = "None";
        }
        for (DispoSet dispoSet : dispoSets) {
            DispoSetData newSet = new DispoSetData();
            newSet.setOperation("Import");
            if (filterState.equalsIgnoreCase("All") || dispoSet.getImportState().equalsIgnoreCase(filterState)) {
                this.runOperation(branch, dispoSet, newSet, true);
                continue;
            }
            this.getWriter().updateDispoSet(branch, (String)dispoSet.getGuid(), (DispoSet)newSet);
        }
    }

    @Override
    public void importAllDispoPrograms(String filterState) {
        List<Object> dispoBranches = new ArrayList();
        dispoBranches = this.getDispoPrograms();
        for (BranchToken branchToken : dispoBranches) {
            this.importAllDispoSets((BranchId)branchToken, filterState);
        }
    }

    @Override
    public Set<String> getTestScripts(BranchId branch, String dispoSetId) {
        HashSet<String> testScripts = new HashSet<String>();
        for (DispoItem dispoItem : this.getDispoItems(branch, dispoSetId, true)) {
            if (dispoItem == null) continue;
            for (DispoAnnotationData annotation : dispoItem.getAnnotationsList()) {
                if (!annotation.getResolutionType().equals("Test_Script")) continue;
                testScripts.add(annotation.getResolution());
            }
        }
        return testScripts;
    }

    @Override
    public Set<String> getTestScripts(BranchId branch) {
        HashSet<String> testScripts = new HashSet<String>();
        List<DispoSet> dispoSets = this.getDispoSets(branch, "codeCoverage");
        for (DispoSet dispoSet : dispoSets) {
            for (DispoItem dispoItem : this.getDispoItems(branch, dispoSet.getIdString(), true)) {
                if (dispoItem == null) continue;
                for (DispoAnnotationData annotation : dispoItem.getAnnotationsList()) {
                    if (!annotation.getResolutionType().equals("Test_Script")) continue;
                    testScripts.add(annotation.getResolution());
                }
            }
        }
        return testScripts;
    }

    @Override
    public boolean deleteDispoSet(BranchId branch, String setId) {
        return this.getWriter().deleteDispoSet(branch, setId);
    }

    @Override
    public boolean editMassDispositions(BranchId branch, String setId, List<String> ids, String resolutionType, String resolution) {
        boolean wasUpdated = false;
        List<DispoItem> itemsToEdit = this.massDisposition(branch, setId, ids, resolutionType, resolution);
        if (itemsToEdit.size() > 0) {
            this.editDispoItems(branch, setId, itemsToEdit, true, "Import");
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public boolean editDispoItem(BranchId branch, String itemId, DispoItemData newDispoItem, String userName, boolean assignUser) {
        boolean wasUpdated = false;
        DispoItem dispoItemToEdit = this.getQuery().findDispoItemById(branch, itemId);
        if (assignUser || dispoItemToEdit != null && newDispoItem.getAnnotationsList() == null) {
            this.getQuery().findUserByName(userName);
            this.getWriter().updateDispoItem(branch, (String)dispoItemToEdit.getGuid(), (DispoItem)newDispoItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public boolean updateAllDispoItems(BranchId branch, String dispoSetId) {
        boolean wasUpdated = false;
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "Update All Dispo Item Status");
        for (DispoItem dispoItem : this.getDispoItems(branch, dispoSetId, true)) {
            if (dispoItem == null) continue;
            boolean isPass = true;
            boolean isAnalysis = false;
            boolean needsModify = false;
            boolean isIncomplete = false;
            ArtifactReadable dispoItemArt = (ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(branch).andUuid(Long.valueOf((String)dispoItem.getGuid()).longValue()).getResults().getExactlyOne();
            String itemStatus = dispoItem.getStatus();
            boolean needsEdit = false;
            for (DispoAnnotationData annotation : dispoItem.getAnnotationsList()) {
                if (annotation.getIsPairAnnotation()) continue;
                if (!annotation.getIsResolutionValid()) {
                    isIncomplete = true;
                    isPass = false;
                }
                if (annotation.setAndGetIsAnalyze()) {
                    isAnalysis = true;
                    isPass = false;
                }
                if (annotation.setAndGetNeedsModify()) {
                    needsModify = true;
                    isPass = false;
                }
                if (annotation.getIsDefault()) continue;
                isPass = false;
            }
            String newStatus = isPass ? "PASS" : (isIncomplete ? "INCOMPLETE" : (needsModify ? "MODIFY" : (isAnalysis ? "ANALYSIS-COMPLETE" : "COMPLETE")));
            if (!newStatus.equals(itemStatus)) {
                needsEdit = true;
            }
            if (!needsEdit) continue;
            wasUpdated = true;
            tx.setSoleAttributeFromString((ArtifactId)dispoItemArt, (AttributeTypeToken)CoreAttributeTypes.CoverageStatus, newStatus);
        }
        if (wasUpdated) {
            tx.commit();
        }
        return wasUpdated;
    }

    private String getFullFilePathFromDispoItemId(BranchId branch, String itemId, DispoItem dispoItemToEdit) {
        DispoSet dispoSet;
        Conditions.checkNotNull((Object)dispoItemToEdit, (String)"Dispo Item to Edit");
        Conditions.checkNotNull((Object)branch, (String)"Branch");
        Conditions.checkNotNull((Object)itemId, (String)"Item Id");
        ArtifactId set = this.getQuery().getDispoItemParentSet(branch, itemId);
        if (set != null && (dispoSet = this.getQuery().findDispoSetsById(branch, set.getIdString())) != null) {
            String importPath = dispoSet.getCoverageImportApi();
            String name = dispoItemToEdit.getName().replaceAll(this.config.getFileExtRegex(), ".LIS");
            return String.valueOf(importPath) + File.separator + "vcast" + File.separator + name;
        }
        return "";
    }

    @Override
    public boolean massEditTeam(BranchId branch, String setId, List<String> itemNames, String team, String operation) {
        boolean wasUpdated = false;
        HashSet<DispoItem> dispoItems = new HashSet<DispoItem>();
        List<DispoItem> itemsFromSet = this.getDispoItems(branch, setId);
        HashMap<String, String> nameToId = new HashMap<String, String>();
        OperationReport report = new OperationReport();
        for (DispoItem item : itemsFromSet) {
            nameToId.put(item.getName(), (String)item.getGuid());
        }
        HashSet<String> itemsUpdated = new HashSet<String>();
        for (String name : itemNames) {
            String matchingItemId = (String)nameToId.get(name = name.trim());
            if (matchingItemId == null) {
                report.addEntry(name, "No existing item with this name for the selected set", DispoSummarySeverity.WARNING);
                continue;
            }
            itemsUpdated.add(name);
            DispoItemData newItem = new DispoItemData();
            newItem.setGuid(matchingItemId);
            newItem.setTeam(team);
            dispoItems.add((DispoItem)newItem);
        }
        if (!itemsUpdated.isEmpty()) {
            report.addEntry(team, String.format("Team Applied to %s of %s items", itemsUpdated.size(), itemNames.size()), DispoSummarySeverity.UPDATE);
            if (itemsUpdated.size() != itemNames.size()) {
                HashSet<String> uniqueNames = new HashSet<String>(itemNames);
                itemNames.removeAll(uniqueNames);
                if (!itemNames.isEmpty()) {
                    String duplicatesAsString = Collections.toString((String)", ", itemNames);
                    report.addEntry(team, String.format("There were %s duplciates: %s", itemNames.size(), duplicatesAsString), DispoSummarySeverity.WARNING);
                }
            }
            this.editDispoItems(branch, setId, dispoItems, false, operation);
        } else {
            report.addEntry("Womp womp womp", "No items were updated. Please check your 'Items' list and make sure it's a comma seperated list of item names", DispoSummarySeverity.ERROR);
        }
        this.getWriter().updateOperationSummary(branch, setId, report);
        return wasUpdated;
    }

    private void editDispoItems(BranchId branch, String setId, Collection<DispoItem> dispoItems, boolean resetRerunFlag, String operation) {
        this.getWriter().updateDispoItems(branch, dispoItems, resetRerunFlag, operation);
    }

    @Override
    public boolean deleteDispoItem(BranchId branch, String itemId) {
        return this.getWriter().deleteDispoItem(branch, itemId);
    }

    @Override
    public boolean editDispoAnnotation(BranchId branch, String itemId, String annotationId, DispoAnnotationData newAnnotation, String userName, boolean isCi) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            String parentLoc;
            DispoAnnotationData parentAnnotation;
            String[] splitPairLoc;
            boolean isResolutionChange;
            List annotationsList = dispoItem.getAnnotationsList();
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            DispoAnnotationData origAnnotation = DispoUtil.getById(annotationsList, annotationId);
            if (!origAnnotation.isValid()) {
                return false;
            }
            int indexOfAnnotation = origAnnotation.getIndex();
            boolean needToReconnect = false;
            String newLocationRefs = newAnnotation.getLocationRefs();
            String newResolution = newAnnotation.getResolution();
            String newResolutionType = newAnnotation.getResolutionType();
            boolean isTypeChange = !origAnnotation.getResolutionType().equals(newResolutionType);
            boolean bl = isResolutionChange = !origAnnotation.getResolution().equals(newResolution);
            if (isTypeChange || isResolutionChange) {
                needToReconnect = true;
                this.resolutionValidator.validate(newAnnotation);
            }
            if (!origAnnotation.getLocationRefs().equals(newLocationRefs)) {
                needToReconnect = true;
            }
            if (needToReconnect) {
                newAnnotation.disconnect();
                this.dispoConnector.connectAnnotation(newAnnotation, discrepanciesList);
            }
            annotationsList.set(indexOfAnnotation, newAnnotation);
            this.getQuery().findUserByName(userName);
            DispoItemData modifiedDispoItem = DispoUtil.itemArtToItemData(this.getDispoItemById(branch, itemId), true);
            modifiedDispoItem.setAnnotationsList(annotationsList);
            modifiedDispoItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)modifiedDispoItem));
            this.getWriter().updateDispoItem(branch, (String)dispoItem.getGuid(), (DispoItem)modifiedDispoItem);
            wasUpdated = true;
            if (newAnnotation.getIsPairAnnotation() && newAnnotation.getIsResolutionValid() && (splitPairLoc = newAnnotation.getLocationRefs().split("\\.", 3)).length >= 2 && !(parentAnnotation = DispoUtil.getByLocation(annotationsList, parentLoc = String.format("%s.%s", splitPairLoc[0], splitPairLoc[1]))).getIsResolutionValid()) {
                ArrayList<String> satisfiedPairs = new ArrayList<String>();
                String newParentResolutionType = newAnnotation.getResolutionType();
                String newParentResolution = newAnnotation.getResolution();
                Iterator iterator = newAnnotation.getPairedWith().iterator();
                while (iterator.hasNext()) {
                    int pairNumber = (Integer)iterator.next();
                    String pairLoc = String.format("%s.%d", parentLoc, pairNumber);
                    DispoAnnotationData pairAnnotation = DispoUtil.getByLocation(annotationsList, pairLoc);
                    if (!pairAnnotation.getIsResolutionValid()) continue;
                    if (newAnnotation.getRow() < pairNumber) {
                        satisfiedPairs.add(String.format("%s/%s", newAnnotation.getRow(), pairNumber));
                    } else {
                        satisfiedPairs.add(String.format("%s/%s", pairNumber, newAnnotation.getRow()));
                    }
                    if (!pairAnnotation.getResolutionType().equals(newParentResolutionType)) {
                        newParentResolutionType = String.valueOf(newParentResolutionType) + "/" + pairAnnotation.getResolutionType();
                    }
                    if (pairAnnotation.getResolution().equals(newParentResolution)) continue;
                    newParentResolution = String.valueOf(newParentResolution) + "/" + pairAnnotation.getResolution();
                }
                if (!satisfiedPairs.isEmpty()) {
                    DispoAnnotationData newParentAnnotation = new DispoAnnotationData();
                    newParentAnnotation = parentAnnotation;
                    newParentAnnotation.setResolutionType(newParentResolutionType);
                    newParentAnnotation.setResolution(newParentResolution);
                    newParentAnnotation.setSatisfiedPairs(String.format("Pairs Satisfied By: %s", ((Object)satisfiedPairs).toString()));
                    this.editDispoAnnotation(branch, itemId, parentAnnotation.getGuid(), newParentAnnotation, userName, isCi);
                }
            }
        }
        return wasUpdated;
    }

    @Override
    public boolean deleteDispoAnnotation(BranchId branch, String itemId, String annotationId, String userName, boolean isCi) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            List annotationsList = dispoItem.getAnnotationsList();
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            DispoAnnotationData annotationToRemove = DispoUtil.getById(annotationsList, annotationId);
            if (!annotationToRemove.isValid()) {
                return wasUpdated;
            }
            annotationToRemove.disconnect();
            List<DispoAnnotationData> newAnnotationsList = this.removeAnnotationFromList(annotationsList, annotationToRemove.getIndex());
            DispoItem updatedItem = this.dataFactory.createUpdatedItem(newAnnotationsList, discrepanciesList);
            this.getQuery().findUserByName(userName);
            this.getWriter().updateDispoItem(branch, (String)dispoItem.getGuid(), updatedItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public boolean deleteAllDispoAnnotation(BranchId branch, String itemId, String userName, boolean isCi) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null && (isCi || dispoItem.getAssignee().equalsIgnoreCase(userName))) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            for (DispoAnnotationData annotation : dispoItem.getAnnotationsList()) {
                annotation.disconnect();
            }
            DispoItem updatedItem = this.dataFactory.createUpdatedItem(new ArrayList<DispoAnnotationData>(), discrepanciesList);
            this.getQuery().findUserByName(userName);
            this.getWriter().updateDispoItem(branch, (String)dispoItem.getGuid(), updatedItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public List<BranchToken> getDispoPrograms() {
        return this.getQuery().getDispoBranches();
    }

    @Override
    public List<String> getDispoProgramNames() {
        return this.getQuery().getDispoBranchNames();
    }

    @Override
    public BranchToken getDispoProgramIdByName(String branchName) {
        return this.getQuery().findDispoProgramIdByName(branchName);
    }

    @Override
    public List<DispoSet> getDispoSets(BranchId branch, String type) {
        return this.getQuery().findDispoSets(branch, type);
    }

    @Override
    public List<String> getDispoSetNames(BranchId branch, String type) {
        return this.getQuery().getDispoSets(branch, type);
    }

    @Override
    public DispoSet getDispoSetById(BranchId branch, String setId) {
        return this.getQuery().findDispoSetsById(branch, setId);
    }

    @Override
    public String getDispoSetIdByName(BranchId branchId, String setName) {
        return this.getQuery().findDispoSetIdByName(branchId, setName);
    }

    @Override
    public List<DispoItem> getDispoItems(BranchId branch, String setArtId, boolean isDetailed) {
        return this.getQuery().findDispoItems(branch, setArtId, isDetailed);
    }

    private List<DispoItem> getDispoItems(BranchId branch, String setArtId) {
        return this.getDispoItems(branch, setArtId, true);
    }

    @Override
    public DispoItem getDispoItemById(BranchId branch, String itemId) {
        return this.getQuery().findDispoItemById(branch, itemId);
    }

    @Override
    public String getDispoItemIdByName(BranchId branchId, String setId, String itemName) {
        return this.getQuery().findDispoItemIdByName(branchId, setId, itemName);
    }

    @Override
    public Collection<DispoItem> getDispoItemByAnnotationText(BranchId branch, String setId, String keyword, boolean isDetailed) {
        return this.getQuery().findDispoItemByAnnoationText(branch, setId, keyword, isDetailed);
    }

    @Override
    public List<DispoAnnotationData> getDispoAnnotations(BranchId branch, String itemId) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        return dispoItem.getAnnotationsList();
    }

    @Override
    public List<DispoAnnotationData> getDispoAnnotationsByType(Iterable<DispoAnnotationData> annotationData, String resolutionType) {
        ArrayList<DispoAnnotationData> resolutionTypeAnnotations = new ArrayList<DispoAnnotationData>();
        for (DispoAnnotationData dad : annotationData) {
            if (!dad.getResolutionType().equals(resolutionType)) continue;
            resolutionTypeAnnotations.add(dad);
        }
        return resolutionTypeAnnotations;
    }

    @Override
    public List<String> getCheckedReruns(BranchId branch, String setId) {
        DispoSet set = this.getDispoSetById(branch, setId);
        HashMap<String, DispoItem> nameToItemMap = this.getItemsMap(branch, set);
        return this.getQuery().getCheckedReruns(nameToItemMap, setId);
    }

    @Override
    public DispoAnnotationData getDispoAnnotationById(BranchId branch, String itemId, String annotationId) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        List annotationsList = dispoItem.getAnnotationsList();
        return DispoUtil.getById(annotationsList, annotationId);
    }

    @Override
    public boolean isUniqueProgramName(String name) {
        return this.getQuery().isUniqueProgramName(name);
    }

    @Override
    public boolean isUniqueItemName(BranchId branch, String setId, String name) {
        return this.getQuery().isUniqueItemName(branch, setId, name);
    }

    @Override
    public boolean isUniqueSetName(BranchId branch, String name) {
        return this.getQuery().isUniqueSetName(branch, name);
    }

    private void runOperation(BranchId branch, DispoSet setToEdit, DispoSetData newSet, boolean isIterative) {
        OperationReport report = new OperationReport();
        String operation = newSet.getOperation();
        if (operation.equals("Import")) {
            try {
                HashMap<String, DispoItem> nameToItemMap = this.getItemsMap(branch, setToEdit);
                DispoImporterApi importer = setToEdit.getDispoType().equalsIgnoreCase("codeCoverage") ? this.importerFactory.createImporter(DispoImporterFactory.ImportFormat.LIS, this.dispoConnector) : this.importerFactory.createImporter(DispoImporterFactory.ImportFormat.TMO, this.dispoConnector);
                File importDirectory = gitlabApiPattern.matcher(setToEdit.getCoverageImportApi()).matches() ? this.importDataFromGit(branch, setToEdit, setToEdit.getCoverageImportApi(), setToEdit.getCoveragePartition()) : (gitlabApiPattern.matcher(setToEdit.getImportPath()).matches() ? this.importDataFromGit(branch, setToEdit, setToEdit.getImportPath(), setToEdit.getCoveragePartition()) : (setToEdit.getImportPath().contains("artifactory") ? this.importDataArtifactory(branch, setToEdit, setToEdit.getImportPath()) : new File(setToEdit.getImportPath())));
                boolean pathExists = this.checkIfPathExists(importDirectory, report);
                ArtifactReadable programConfig = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.CoverageProgram}).andNameEquals("Coverage Config").asArtifactOrSentinel();
                List<DispoItem> itemsFromParse = importer.importDirectory(nameToItemMap, importDirectory, report, this.logger, programConfig);
                if (pathExists && itemsFromParse.isEmpty()) {
                    report.addEntry(setToEdit.getImportPath(), "No file(s) found", DispoSummarySeverity.IGNORE);
                } else {
                    report.addEntry("INFO", "CI Set: " + setToEdit.getCiSet(), DispoSummarySeverity.IGNORE);
                    report.addEntry("INFO", "Dispo Type: " + setToEdit.getDispoType(), DispoSummarySeverity.IGNORE);
                    report.addEntry("INFO", "Import State: " + setToEdit.getImportState(), DispoSummarySeverity.IGNORE);
                }
                ArrayList<DispoItem> itemsToCreate = new ArrayList<DispoItem>();
                ArrayList<DispoItem> itemsToEdit = new ArrayList<DispoItem>();
                for (DispoItem item : itemsFromParse) {
                    if (item.getGuid() == null) {
                        itemsToCreate.add(item);
                        report.addEntry(item.getName(), "", DispoSummarySeverity.NEW);
                        continue;
                    }
                    itemsToEdit.add(item);
                }
                if (!report.getStatus().isFailed()) {
                    if (itemsToCreate.size() > 0) {
                        this.createDispoItems(branch, (String)setToEdit.getGuid(), itemsToCreate);
                    }
                    if (itemsToEdit.size() > 0) {
                        this.editDispoItems(branch, (String)setToEdit.getGuid(), itemsToEdit, true, "Import");
                    }
                }
                this.updateAllDispoItems(branch, (String)setToEdit.getGuid());
            }
            catch (Exception ex) {
                if (isIterative) {
                    return;
                }
                throw new OseeCoreException((Throwable)ex);
            }
        }
        List notesList = setToEdit.getNotesList();
        Note genOpNotes = this.generateOperationNotes(operation);
        notesList.add(this.generateOperationNotes("Import"));
        notesList.add(genOpNotes);
        newSet.setNotesList(notesList);
        this.newDate.setTime(System.currentTimeMillis());
        newSet.setTime(this.newDate);
        this.getWriter().updateOperationSummary(branch, (String)setToEdit.getGuid(), report);
        this.getWriter().updateDispoSet(branch, (String)setToEdit.getGuid(), (DispoSet)newSet);
    }

    private File importDataArtifactory(BranchId branch, DispoSet setId, String dataSource) {
        String folderPath = this.getLocalFolderPath(branch.getIdString(), setId.getIdString());
        File setFolder = new File(folderPath);
        File parent = setFolder.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new OseeStateException("Couldn't create dir: " + parent, new Object[0]);
        }
        if (!setFolder.exists()) {
            setFolder.mkdirs();
        }
        String fullPath = "";
        fullPath = String.valueOf(folderPath) + this.getZipFileName(dataSource);
        this.downloadArtifactoryFile(dataSource, fullPath);
        this.getWriter().updateOrCreateServerImportPath(branch, setId, fullPath);
        return new File(fullPath);
    }

    private File importDataFromGit(BranchId branch, DispoSet setId, String apiCall, String partitionName) {
        String folderPath = this.getLocalFolderPath(branch.getIdString(), setId.getIdString());
        File setFolder = new File(folderPath);
        File parent = setFolder.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new OseeStateException("Couldn't create dir: " + parent, new Object[0]);
        }
        if (!setFolder.exists()) {
            setFolder.mkdirs();
        }
        String fullPath = "";
        fullPath = String.valueOf(folderPath) + partitionName;
        this.downloadGitLabFile(apiCall, fullPath, partitionName);
        this.getWriter().updateOrCreateServerImportPath(branch, setId, fullPath);
        return new File(fullPath);
    }

    private String getLocalFolderPath(String branchId, String setId) {
        String basePath = this.orcsApi.getSystemProperties().getValue("osee.application.server.data");
        return String.valueOf(basePath) + File.separator + "coverage" + File.separator + branchId + File.separator + setId + File.separator;
    }

    private String getZipFileName(String artifactoryUrl) {
        int lastSlashIndex = artifactoryUrl.lastIndexOf(47);
        int dotZipIndex = artifactoryUrl.lastIndexOf(".zip");
        if (lastSlashIndex != -1 && dotZipIndex != -1 && lastSlashIndex < dotZipIndex) {
            return artifactoryUrl.substring(lastSlashIndex + 1, dotZipIndex);
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuilder downloadArtifactoryFile(String artifactoryUrl, String downloadLocation) {
        StringBuilder response = new StringBuilder();
        String personalAccessToken = this.getArtifactoryPersonalAccessToken();
        try {
            if (!artifactoryUrl.endsWith(".zip")) {
                throw new OseeCoreException("Artifactory Item is not a .zip", new Object[0]);
            }
            URL repositoryUrl = new URL(artifactoryUrl);
            HttpURLConnection connection = (HttpURLConnection)repositoryUrl.openConnection();
            connection.addRequestProperty("X-JFrog-Art-Api", personalAccessToken);
            connection.setRequestProperty("Connection", "keep-alive");
            connection.setRequestMethod("GET");
            connection.connect();
            String fileZip = String.format("%s.zip", downloadLocation);
            File uploadedZip = new File(fileZip);
            Throwable throwable = null;
            Object var10_12 = null;
            try {
                InputStream stream = connection.getInputStream();
                try {
                    try (FileOutputStream outStream = new FileOutputStream(uploadedZip);){
                        byte[] buffer = stream.readAllBytes();
                        stream.close();
                        ((OutputStream)outStream).write(buffer);
                        ((OutputStream)outStream).close();
                        connection.disconnect();
                        ZipInputStream zis = new ZipInputStream(new FileInputStream(fileZip));
                        File unzipLocation = new File(downloadLocation);
                        Zip.decompressStream((ZipInputStream)zis, (byte[])buffer, (File)unzipLocation);
                    }
                    if (stream == null) return response;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return response;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new OseeCoreException("Artifactory Operation Failed", (Throwable)ex);
        }
    }

    private StringBuilder downloadGitLabFile(String gitlabUrl, String downloadLocation, String partitionName) {
        StringBuilder response = new StringBuilder();
        String personalAccessToken = String.format("Bearer %s", this.getGitlabPersonalAccessToken());
        String fullGitlabUrl = gitlabUrl;
        if (!gitlabUrl.contains("https")) {
            fullGitlabUrl = String.format("%s%s", this.getGitlabBaseApiUrl(), gitlabUrl);
        }
        try {
            URL repositoryUrl = new URL(fullGitlabUrl);
            HttpURLConnection connection = (HttpURLConnection)repositoryUrl.openConnection();
            connection.addRequestProperty("Authorization", personalAccessToken);
            connection.setRequestProperty("Connection", "keep-alive");
            connection.setRequestMethod("GET");
            connection.connect();
            String fileZip = String.format("%s%svcast.zip", downloadLocation, File.separator);
            Throwable throwable = null;
            Object var11_13 = null;
            try (InputStream stream = connection.getInputStream();){
                File unzipLocation = new File(downloadLocation);
                Zip.decompressStream((InputStream)stream, (File)unzipLocation.getParentFile(), (String)(String.valueOf(partitionName) + "/vcast"));
                connection.disconnect();
                stream.close();
                File vcastDir = new File(String.format("%s%svcast", downloadLocation, File.separator));
                if (vcastDir.exists()) {
                    Zip.compressDirectory((File)vcastDir, (String)fileZip, (boolean)true);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new OseeCoreException("Gitlab Operation Failed", (Throwable)ex);
        }
        return response;
    }

    private String getGitlabPersonalAccessToken() {
        ArtifactReadable gitlabConfig = this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch()).andId((ArtifactId)AtsArtifactToken.GitlabConfig).asArtifact();
        return gitlabConfig.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.GeneralStringData);
    }

    private String getGitlabBaseApiUrl() {
        ArtifactReadable gitlabConfig = this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch()).andId((ArtifactId)AtsArtifactToken.GitlabConfig).asArtifact();
        return gitlabConfig.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ContentUrl);
    }

    private String getArtifactoryPersonalAccessToken() {
        ArtifactReadable artifactoryConfig = this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch()).andId((ArtifactId)AtsArtifactToken.ArtifactoryConfig).asArtifact();
        return artifactoryConfig.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.GeneralStringData);
    }

    private boolean checkIfPathExists(File file, OperationReport report) {
        boolean ret = true;
        if (!file.canRead()) {
            report.addEntry(file.getAbsolutePath(), "No Read Access", DispoSummarySeverity.IGNORE);
        }
        if (!file.canWrite()) {
            report.addEntry(file.getAbsolutePath(), "No Write Access", DispoSummarySeverity.IGNORE);
        }
        if (!file.exists() && !file.isDirectory()) {
            ret = false;
            boolean isRealPath = false;
            String filePath = file.getAbsolutePath();
            while (!isRealPath && filePath.contains(File.separator)) {
                int end = filePath.lastIndexOf(File.separator);
                StringBuilder pathName = new StringBuilder();
                pathName.append(filePath.substring(0, end));
                filePath = pathName.toString();
                if (!new File(filePath).isDirectory()) continue;
                isRealPath = true;
            }
            if (isRealPath) {
                report.addEntry(file.getAbsolutePath(), "No file or directory was found. Closest path found at: " + filePath, DispoSummarySeverity.IGNORE);
            } else {
                report.addEntry(file.getAbsolutePath(), "No file or directory was found.", DispoSummarySeverity.IGNORE);
            }
        } else {
            report.addEntry(file.getAbsolutePath(), "The Import Path/File Does Exist", DispoSummarySeverity.IGNORE);
        }
        return ret;
    }

    private List<DispoItem> massDisposition(BranchId branch, String setId, List<String> itemIds, String resolutionType, String resolution) {
        ArrayList<DispoItem> toEdit = new ArrayList<DispoItem>();
        List<DispoItem> allItemsInSet = this.getDispoItems(branch, setId);
        for (DispoItem item : allItemsInSet) {
            if (!itemIds.contains(item.getGuid())) continue;
            DispoItemData newItem = new DispoItemData();
            newItem.setGuid((String)item.getGuid());
            newItem.setName(item.getName());
            List<DispoAnnotationData> newAnnotations = new ArrayList();
            newAnnotations = item.getAnnotationsList();
            for (DispoAnnotationData annotation : item.getAnnotationsList()) {
                DispoAnnotationData parentAnnotation;
                if (!DispoUtil.isAnnotationValueBlank(annotation) || annotation.getIsParentPair()) continue;
                DispoAnnotationData newAnnotation = new DispoAnnotationData(annotation, resolutionType, resolution, true, false, true);
                this.dispoConnector.connectAnnotation(newAnnotation, item.getDiscrepanciesList());
                newAnnotations.set(newAnnotation.getIndex(), newAnnotation);
                if (!newAnnotation.getIsPairAnnotation() || (parentAnnotation = this.getParentAnnotation(branch, (String)item.getGuid(), newAnnotation)).getIsResolutionValid()) continue;
                String newParentResolutionType = resolutionType;
                String newParentResolution = resolution;
                ArrayList<String> satisfiedPairs = new ArrayList<String>();
                Iterator iterator = newAnnotation.getPairedWith().iterator();
                while (iterator.hasNext()) {
                    int pairNumber = (Integer)iterator.next();
                    String pairLoc = String.format("%s.%d", parentAnnotation.getLocationRefs(), pairNumber);
                    DispoAnnotationData pairAnnotation = DispoUtil.getByLocation(newAnnotations, pairLoc);
                    if (!pairAnnotation.getIsResolutionValid()) continue;
                    if (newAnnotation.getRow() < pairNumber) {
                        satisfiedPairs.add(String.format("%s/%s", newAnnotation.getRow(), pairNumber));
                    } else {
                        satisfiedPairs.add(String.format("%s/%s", pairNumber, newAnnotation.getRow()));
                    }
                    if (!pairAnnotation.getResolutionType().equals(newParentResolutionType)) {
                        newParentResolutionType = String.valueOf(newParentResolutionType) + "/" + pairAnnotation.getResolutionType();
                    }
                    if (pairAnnotation.getResolution().equals(newParentResolution)) continue;
                    newParentResolution = String.valueOf(newParentResolution) + "/" + pairAnnotation.getResolution();
                }
                if (satisfiedPairs.isEmpty()) continue;
                DispoAnnotationData newParentAnnotation = new DispoAnnotationData(parentAnnotation, newParentResolutionType, newParentResolution, String.format("Pairs Satisfied By: %s", ((Object)satisfiedPairs).toString()), true, false, true);
                this.dispoConnector.connectAnnotation(newParentAnnotation, item.getDiscrepanciesList());
                newAnnotations.set(newParentAnnotation.getIndex(), newParentAnnotation);
            }
            newItem.setAnnotationsList(newAnnotations);
            newItem.setDiscrepanciesList(item.getDiscrepanciesList());
            newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
            toEdit.add((DispoItem)newItem);
        }
        return toEdit;
    }

    private DispoAnnotationData getParentAnnotation(BranchId branch, String itemId, DispoAnnotationData pairAnnotation) {
        String[] splitPairLoc;
        DispoAnnotationData parentAnnotation = DispoAnnotationData.SENTINEL;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        List annotationsList = dispoItem.getAnnotationsList();
        if (pairAnnotation.getIsPairAnnotation() && pairAnnotation.getIsResolutionValid() && (splitPairLoc = pairAnnotation.getLocationRefs().split("\\.", 3)).length >= 2) {
            String parentLoc = String.format("%s.%s", splitPairLoc[0], splitPairLoc[1]);
            parentAnnotation = DispoUtil.getByLocation(annotationsList, parentLoc);
        }
        return parentAnnotation;
    }

    private HashMap<String, DispoItem> getItemsMap(BranchId branch, DispoSet set) {
        HashMap<String, DispoItem> toReturn = new HashMap<String, DispoItem>();
        List<DispoItem> dispoItems = this.getDispoItems(branch, (String)set.getGuid());
        for (DispoItem item : dispoItems) {
            toReturn.put(item.getName(), item);
        }
        return toReturn;
    }

    private Note generateOperationNotes(String operation) {
        Note operationNote = new Note();
        this.newDate.setTime(System.currentTimeMillis());
        operationNote.setDateString(this.newDate.toString());
        operationNote.setType("SYSTEM");
        operationNote.setContent(operation);
        return operationNote;
    }

    private List<DispoAnnotationData> removeAnnotationFromList(List<DispoAnnotationData> oldList, int indexRemoved) {
        ArrayList<DispoAnnotationData> newList = new ArrayList<DispoAnnotationData>();
        oldList.remove(indexRemoved);
        int newIndex = 0;
        for (DispoAnnotationData annotation : oldList) {
            annotation.setIndex(newIndex);
            newList.add(newIndex, annotation);
            ++newIndex;
        }
        return newList;
    }

    @Override
    public void copyDispoSetCoverage(BranchId sourceBranch, Long sourceCoverageUuid, BranchId destBranch, String destSetId, CopySetParams params) {
        Map<String, ArtifactReadable> coverageUnits = this.getQuery().getCoverageUnits(sourceBranch, sourceCoverageUuid);
        List<DispoItem> destItems = this.getDispoItems(destBranch, destSetId);
        OperationReport report = new OperationReport();
        CoverageAdapter coverageAdapter = new CoverageAdapter(this.dispoConnector);
        List<DispoItem> copyData = coverageAdapter.copyData(coverageUnits, destItems, report);
        String operation = String.format("Copy From Legacy Coverage - Branch [%s] and Source Set [%s]", sourceBranch, sourceCoverageUuid);
        if (!copyData.isEmpty()) {
            this.editDispoItems(destBranch, destSetId, copyData, false, operation);
            this.storage.updateOperationSummary(destBranch, destSetId, report);
        }
    }

    @Override
    public void copyDispoSet(BranchId branch, String destSetId, BranchId sourceBranch, String sourceSetId, CopySetParams params) {
        if (branch == sourceBranch && destSetId == sourceSetId) {
            return;
        }
        boolean wasUpdated = false;
        DispoSet destDispoSet = this.getQuery().findDispoSetsById(branch, destSetId);
        if (destDispoSet.getDispoType().equalsIgnoreCase("codeCoverage")) {
            DispoConfig dispoConfig = this.getDispoConfig(branch);
            HashSet<String> validResolutions = new HashSet<String>();
            dispoConfig.getValidResolutions().forEach(res -> validResolutions.add(res.getValue()));
            List<DispoItem> sourceItems = this.getDispoItems(sourceBranch, sourceSetId);
            HashMap<String, Set<DispoItemData>> namesToDestItems = new HashMap<String, Set<DispoItemData>>();
            for (DispoItem itemArt : this.getDispoItems(branch, destSetId)) {
                DispoItemData itemData = DispoUtil.itemArtToItemData(itemArt, true, true);
                String name = itemData.getName();
                Set itemsWithSameName = (Set)namesToDestItems.get(name);
                if (itemsWithSameName == null) {
                    HashSet<DispoItemData> set = new HashSet<DispoItemData>();
                    set.add(itemData);
                    namesToDestItems.put(name, set);
                    continue;
                }
                itemsWithSameName.add(itemData);
                namesToDestItems.put(name, itemsWithSameName);
            }
            HashMap<String, String> reruns = new HashMap<String, String>();
            HashMap<String, DispoItem> namesToToEditItems = new HashMap<String, DispoItem>();
            OperationReport report = new OperationReport();
            DispoSetCopier copier = new DispoSetCopier(this.dispoConnector);
            if (!params.getAnnotationParam().isNone()) {
                List<DispoItem> copyResults = copier.copyAllDispositions(namesToDestItems, sourceItems, true, reruns, params.getAllowOnlyValidResolutionTypes(), validResolutions, false, report);
                for (DispoItem item : copyResults) {
                    namesToToEditItems.put(item.getName(), item);
                }
            }
            copier.copyCategories(namesToDestItems, sourceItems, namesToToEditItems, params.getCategoryParam());
            copier.copyAssignee(namesToDestItems, sourceItems, namesToToEditItems, params.getAssigneeParam());
            copier.copyNotes(namesToDestItems, sourceItems, namesToToEditItems, params.getNoteParam());
            String operation = String.format("Copy Set from Program [%s] and Set [%s] to branch [%s] set [%s]", sourceBranch, sourceSetId, branch, destSetId);
            if (!namesToToEditItems.isEmpty() && !report.getStatus().isFailed()) {
                this.editDispoItems(branch, destSetId, namesToToEditItems.values(), false, operation);
                this.storage.updateOperationSummary(branch, destSetId, report);
            }
            this.storeRerunData(branch, destSetId, reruns);
            this.updateAllDispoItems(branch, destSetId);
        } else {
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, String.format("Merge CI Dispositions from branch [%s] set [%s] to branch [%s] set [%s]", sourceBranch, sourceSetId, branch, destSetId));
            ArrayList<String> destItemNames = new ArrayList<String>();
            List<ArtifactReadable> sourceItemArtifacts = this.getQuery().findItemArtifacts(sourceBranch, sourceSetId);
            List<ArtifactReadable> destItemArtifacts = this.getQuery().findItemArtifacts(branch, destSetId);
            ArtifactReadable setArtifact = this.getQuery().findSetArtifact(branch, destSetId);
            for (ArtifactReadable destItemArt : destItemArtifacts) {
                destItemNames.add(destItemArt.getName());
            }
            for (ArtifactReadable sourceItemArt : sourceItemArtifacts) {
                if (destItemNames.contains(sourceItemArt.getName())) continue;
                wasUpdated = true;
                ArtifactToken copiedItem = tx.createArtifact((ArtifactId)setArtifact, CoreArtifactTypes.DispositionableItem, (String)sourceItemArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name));
                for (AttributeTypeToken attributeTypeToken : sourceItemArt.getExistingAttributeTypes()) {
                    if (!copiedItem.isAttributeTypeValid((AttributeTypeId)attributeTypeToken)) continue;
                    if (attributeTypeToken.isEnumerated() && sourceItemArt.getSoleAttributeValue(attributeTypeToken) == null) {
                        tx.setSoleAttributeValue((ArtifactId)copiedItem, attributeTypeToken, (Object)"");
                        continue;
                    }
                    tx.setSoleAttributeValue((ArtifactId)copiedItem, attributeTypeToken, sourceItemArt.getSoleAttributeValue(attributeTypeToken, this.orcsApi.tokenService().getAttributeType((AttributeTypeId)attributeTypeToken).getBaseAttributeTypeDefaultValue()));
                }
                DispoOseeTypes.DispoItemVersion.getBaseAttributeTypeDefaultValue();
            }
            if (wasUpdated) {
                tx.commit();
            }
        }
    }

    private void storeRerunData(BranchId branch, String destSetId, HashMap<String, String> reruns) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : reruns.entrySet()) {
            sb = sb.append("\t\t<ScriptEntry>\n");
            sb = sb.append(String.format("\t\t\t<Name>%s</Name>\n", entry.getKey()));
            sb = sb.append(String.format("\t\t\t<Path>%s</Path>\n", entry.getValue()));
            sb = sb.append("\t\t\t<IsRunnable>true</IsRunnable>\n");
            sb = sb.append("\t\t</ScriptEntry>\n");
        }
        DispoSetData dispoSetData = new DispoSetData();
        this.newDate.setTime(System.currentTimeMillis());
        dispoSetData.setTime(this.newDate);
        dispoSetData.setRerunList("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<TestManagerConfig>\n\t<ScriptPageConfig>\n\t\t<ServicesSettings/>\n" + sb.toString() + "\t</ScriptPageConfig>\n</TestManagerConfig>");
        this.getQuery().findUser();
        this.storage.updateDispoSet(branch, destSetId, (DispoSet)dispoSetData);
    }

    @Override
    public DispoConfig getDispoConfig(BranchId branch) {
        return this.getQuery().findDispoConfig(branch);
    }

    @Override
    public DispoSet getDispoItemParentSet(BranchId branch, String itemId) {
        ArtifactId id = this.getQuery().getDispoItemParentSet(branch, itemId);
        return this.getDispoSetById(branch, id.getIdString());
    }

    @Override
    public HashMap<ArtifactReadable, BranchId> getCiSet(CiSetData setData) {
        return this.getQuery().getCiSet(setData);
    }

    @Override
    public String getDispoItemId(BranchId branch, String setId, String item) {
        return this.getQuery().getDispoItemId(branch, setId, item);
    }

    @Override
    public List<CiSetData> getAllCiSets() {
        return this.getQuery().getAllCiSets();
    }

    @Override
    public String createDispoDiscrepancy(BranchId branch, String itemId, Discrepancy discrepancy, String userName) {
        String idOfNewDiscrepancy = "";
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepancyList = dispoItem.getDiscrepanciesList();
            idOfNewDiscrepancy = this.dataFactory.getNewId();
            discrepancy.setId(idOfNewDiscrepancy);
            if (discrepancy.getLocation() == null) {
                discrepancy.setLocation("");
            }
            if (discrepancy.getText() == null) {
                discrepancy.setText("");
            }
            discrepancyList.put(idOfNewDiscrepancy, discrepancy);
            DispoItemData newItem = new DispoItemData();
            newItem.setDiscrepanciesList(discrepancyList);
            newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
            this.getQuery().findUser();
            this.getWriter().updateDispoItem(branch, (String)dispoItem.getGuid(), (DispoItem)newItem);
        }
        return idOfNewDiscrepancy;
    }

    @Override
    public void createDispoDiscrepancies(BranchId branch, String itemId, List<Discrepancy> discrepancies, String userName) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepancyList = dispoItem.getDiscrepanciesList();
            ArrayList<DispoItem> dispoItems = new ArrayList<DispoItem>();
            for (Discrepancy discrepancy : discrepancies) {
                String idOfNewDiscrepancy = "";
                idOfNewDiscrepancy = this.dataFactory.getNewId();
                discrepancy.setId(idOfNewDiscrepancy);
                if (discrepancy.getLocation() == null) {
                    discrepancy.setLocation("");
                }
                if (discrepancy.getText() == null) {
                    discrepancy.setText("");
                }
                discrepancyList.put(idOfNewDiscrepancy, discrepancy);
                DispoItemData newItem = new DispoItemData();
                newItem.setDiscrepanciesList(discrepancyList);
                newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
                dispoItems.add((DispoItem)newItem);
            }
            this.getQuery().findUser();
            String operation = String.format("Create Dispo Discrepancies in Program [%s], Item [%s]", branch, itemId);
            this.getWriter().updateDispoItems(branch, dispoItems, false, operation);
        }
    }

    @Override
    public boolean editDispoDiscrepancy(BranchId branch, String itemId, String discrepancyId, Discrepancy newDiscrepancy, String userName) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            discrepanciesList.put(discrepancyId, newDiscrepancy);
            DispoItemData modifiedDispoItem = DispoUtil.itemArtToItemData(this.getDispoItemById(branch, itemId), true);
            modifiedDispoItem.setDiscrepanciesList(discrepanciesList);
            modifiedDispoItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)modifiedDispoItem));
            try {
                Date date = DispoUtil.getTimestampOfFile(this.getFullFilePathFromDispoItemId(branch, itemId, dispoItem));
                modifiedDispoItem.setLastUpdate(date);
            }
            catch (Throwable ex) {
                throw new OseeCoreException(ex);
            }
            this.getQuery().findUser();
            this.getWriter().updateDispoItem(branch, (String)dispoItem.getGuid(), (DispoItem)modifiedDispoItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public void editDispoDiscrepancies(BranchId branch, String itemId, List<Discrepancy> discrepancies, String userName) {
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            for (Discrepancy discrepancy : discrepancies) {
                discrepanciesList.put(discrepancy.getId(), discrepancy);
            }
            DispoItemData modifiedDispoItem = DispoUtil.itemArtToItemData(this.getDispoItemById(branch, itemId), true);
            modifiedDispoItem.setDiscrepanciesList(discrepanciesList);
            modifiedDispoItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)modifiedDispoItem));
            try {
                Date date = DispoUtil.getTimestampOfFile(this.getFullFilePathFromDispoItemId(branch, itemId, dispoItem));
                modifiedDispoItem.setLastUpdate(date);
            }
            catch (Throwable ex) {
                throw new OseeCoreException(ex);
            }
            this.getQuery().findUser();
            this.getWriter().updateDispoItem(branch, (String)dispoItem.getGuid(), (DispoItem)modifiedDispoItem);
        }
    }

    @Override
    public boolean deleteDispoDiscrepancy(BranchId branch, String itemId, String discrepancyId, String userName) {
        boolean wasUpdated = false;
        DispoItem dispoItem = this.getQuery().findDispoItemById(branch, itemId);
        if (dispoItem != null) {
            Map discrepanciesList = dispoItem.getDiscrepanciesList();
            discrepanciesList.remove(discrepancyId);
            DispoItemData newItem = new DispoItemData();
            newItem.setDiscrepanciesList(discrepanciesList);
            newItem.setStatus(this.dispoConnector.getItemStatus((DispoItem)newItem));
            this.getWriter().updateDispoItem(branch, (String)dispoItem.getGuid(), (DispoItem)newItem);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    @Override
    public String createDispoItem(BranchId branch, CiItemData data, String userName) {
        DispoItemData dispoItemData = new DispoItemData();
        dispoItemData.setName(data.getScriptName());
        dispoItemData.setGuid(this.dataFactory.getNewId());
        dispoItemData.setDiscrepanciesAsRanges(data.getTestPoints().getFail());
        dispoItemData.setDiscrepanciesList(new HashMap());
        dispoItemData.setAnnotationsList(data.getAnnotations());
        this.getQuery().findUser();
        DispoSet parentSet = this.getQuery().findDispoSetsById(branch, data.getSetData().getDispoSetId());
        if (parentSet != null) {
            this.getWriter().createDispoItem(branch, parentSet, (DispoItem)dispoItemData);
        }
        return dispoItemData.getGuid();
    }
}

