/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.resource.management;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.osee.framework.core.exception.OseeDataStoreException;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.ByteStreamResource;
import org.eclipse.osee.framework.resource.management.DataResource;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceLocatorProvider;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.framework.resource.management.IResourceProvider;

public class ResourceManager
implements IResourceManager {
    private static final PropertyStore DEFAULT_OPTIONS = new PropertyStore();
    private final Collection<IResourceProvider> resourceProviders = new CopyOnWriteArraySet<IResourceProvider>();
    private final Collection<IResourceLocatorProvider> resourceLocatorProviders = new CopyOnWriteArraySet<IResourceLocatorProvider>();

    private IResourceProvider getProvider(IResourceLocator locator) {
        for (IResourceProvider provider : this.resourceProviders) {
            if (!provider.isValid(locator)) continue;
            return provider;
        }
        throw new OseeNotFoundException("No resource provider found for Locator: [%s].  Searched providers: [%s]", new Object[]{locator, Arrays.deepToString(this.resourceProviders.toArray())});
    }

    public void addResourceProvider(IResourceProvider resourceProvider) {
        this.resourceProviders.add(resourceProvider);
    }

    public void removeResourceProvider(IResourceProvider resourceProvider) {
        this.resourceProviders.remove(resourceProvider);
    }

    @Override
    public IResource acquire(IResourceLocator locator, PropertyStore options) {
        IResourceProvider provider = this.getProvider(locator);
        IResource toReturn = provider.acquire(locator, options);
        return toReturn;
    }

    @Override
    public IResourceLocator save(IResourceLocator locator, IResource resource, PropertyStore options) {
        IResourceProvider provider = this.getProvider(locator);
        IResourceLocator actualLocator = provider.save(locator, resource, options);
        return actualLocator;
    }

    @Override
    public int delete(IResourceLocator locator) {
        int toReturn = 2;
        IResourceProvider provider = this.getProvider(locator);
        toReturn = provider.delete(locator);
        return toReturn;
    }

    @Override
    public boolean exists(IResourceLocator locator) {
        IResourceProvider provider = this.getProvider(locator);
        return provider.exists(locator);
    }

    @Override
    public Collection<String> getProtocols() {
        HashSet<String> protocols = new HashSet<String>();
        for (IResourceLocatorProvider provider : this.resourceLocatorProviders) {
            protocols.add(provider.getSupportedProtocol());
        }
        return protocols;
    }

    public void addResourceLocatorProvider(IResourceLocatorProvider resourceLocatorProvider) {
        this.resourceLocatorProviders.add(resourceLocatorProvider);
    }

    public void removeResourceLocatorProvider(IResourceLocatorProvider resourceLocatorProvider) {
        this.resourceLocatorProviders.remove(resourceLocatorProvider);
    }

    @Override
    public IResourceLocator generateResourceLocator(String protocol, String seed, String name) {
        IResourceLocatorProvider resourceLocatorProvider = this.getProvider(protocol);
        return resourceLocatorProvider.generateResourceLocator(seed, name);
    }

    @Override
    public IResourceLocator getResourceLocator(String path) {
        IResourceLocatorProvider resourceLocatorProvider = this.getProvider(path);
        return resourceLocatorProvider.getResourceLocator(path);
    }

    private IResourceLocatorProvider getProvider(String protocol) {
        for (IResourceLocatorProvider provider : this.resourceLocatorProviders) {
            if (!provider.isValid(protocol)) continue;
            return provider;
        }
        throw new OseeNotFoundException("No locator proivder found for [%s].  Searched providers: [%s]", new Object[]{protocol, Arrays.deepToString(this.resourceLocatorProviders.toArray())});
    }

    @Override
    public byte[] acquire(DataResource dataResource) {
        String path = dataResource.getLocator();
        Conditions.checkNotNull((Object)path, (String)"resource path");
        IResourceLocator locator = this.getResourceLocator(path);
        Conditions.checkNotNull((Object)locator, (String)"resource locator", (String)"Unable to locate resource: [%s]", (Object[])new Object[]{path});
        IResource resource = this.acquire(locator, DEFAULT_OPTIONS);
        String mimeType = null;
        if (resource != null) {
            mimeType = ResourceManager.getContentType(resource);
        }
        byte[] data = null;
        InputStream inputStream = null;
        if (resource != null) {
            try {
                try {
                    inputStream = resource.getContent();
                    data = Lib.inputStreamToBytes((InputStream)inputStream);
                }
                catch (IOException ex) {
                    throw new OseeCoreException((Throwable)ex, "Error acquiring resource - [%s]", new Object[]{dataResource});
                }
            }
            finally {
                Lib.close((AutoCloseable)inputStream);
            }
            String extension = Lib.getExtension((String)resource.getName());
            if (Strings.isValid((String)extension)) {
                dataResource.setExtension(extension);
            }
        }
        dataResource.setContentType(mimeType);
        dataResource.setEncoding("ISO-8859-1");
        return data;
    }

    @Override
    public void save(long storageId, String storageName, DataResource dataResource, byte[] rawContent) {
        StringBuilder fullName = new StringBuilder();
        fullName.append(storageName);
        String extension = dataResource.getExtension();
        if (Strings.isValid((String)extension)) {
            fullName.append(".");
            fullName.append(extension);
        }
        String seed = String.valueOf(storageId);
        IResourceLocator locatorHint = this.generateResourceLocator("attr", seed, fullName.toString());
        String contentType = dataResource.getContentType();
        boolean isCompressed = Strings.isValid((String)contentType) && contentType.contains("zip");
        ByteStreamResource resource = new ByteStreamResource(locatorHint, rawContent, isCompressed);
        IResourceLocator locator = this.save(locatorHint, resource, DEFAULT_OPTIONS);
        Conditions.checkNotNull((Object)locator, (String)"locator", (String)"Error saving resource [%s]", (Object[])new Object[]{locatorHint.getRawPath()});
        dataResource.setLocator(locator.getLocation().toASCIIString());
    }

    @Override
    public void purge(DataResource dataResource) {
        String path = dataResource.getLocator();
        Conditions.checkNotNull((Object)path, (String)"resource path");
        IResourceLocator locator = this.getResourceLocator(path);
        Conditions.checkNotNull((Object)locator, (String)"resource locator", (String)"Unable to locate resource [%s]", (Object[])new Object[]{dataResource});
        int result = this.delete(locator);
        if (1 != result) {
            throw new OseeDataStoreException("Error deleting resource located at [%s]", new Object[]{dataResource.getLocator()});
        }
    }

    private static String getContentType(IResource resource) {
        String mimeType;
        InputStream inputStream = null;
        try {
            try {
                inputStream = resource.getContent();
                mimeType = URLConnection.guessContentTypeFromStream(inputStream);
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex, "Error determining mime type for - [%s]", new Object[]{resource.getName()});
            }
        }
        finally {
            Lib.close((AutoCloseable)inputStream);
        }
        if (mimeType == null && (mimeType = URLConnection.guessContentTypeFromName(resource.getLocation().toASCIIString())) == null) {
            mimeType = "application/*";
        }
        return mimeType;
    }
}

