/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.resource.management;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;

public class ByteStreamResource
implements IResource {
    private final IResourceLocator locator;
    private final byte[] rawContent;
    private final boolean isCompressed;

    public ByteStreamResource(IResourceLocator locator, byte[] rawContent, boolean isCompressed) {
        this.locator = locator;
        this.rawContent = rawContent;
        this.isCompressed = isCompressed;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.rawContent);
    }

    @Override
    public URI getLocation() {
        return this.locator.getLocation();
    }

    @Override
    public String getName() {
        String path = this.locator.getLocation().toASCIIString();
        int index = path.lastIndexOf("/");
        if (index != -1 && index + 1 < path.length()) {
            path = path.substring(index + 1, path.length());
        }
        return path;
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }
}

