/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin.internal.validator;

import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.osee.account.admin.AccountConstants;
import org.eclipse.osee.account.admin.AccountField;
import org.eclipse.osee.account.admin.ds.AccountStorage;
import org.eclipse.osee.account.admin.internal.validator.AbstractConfigurableValidator;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class EmailValidator
extends AbstractConfigurableValidator {
    private static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("[a-zA-Z0-9\\+\\.\\_\\%\\-\\+]{1,256}\\@[a-zA-Z0-9][a-zA-Z0-9\\-]{0,64}(\\.[a-zA-Z0-9][a-zA-Z0-9\\-]{0,25})+");
    private final AccountStorage storage;

    public EmailValidator(AccountStorage storage) {
        this.storage = storage;
    }

    @Override
    public AccountField getFieldType() {
        return AccountField.EMAIL;
    }

    @Override
    public boolean exists(String value) {
        return this.storage.emailExists(value);
    }

    @Override
    public boolean isValid(String value) {
        boolean result = Strings.isValid((String)value);
        if (result && (result = this.isValid(EMAIL_ADDRESS_PATTERN, value)) && this.hasCustomPattern()) {
            result = this.isValid(this.getCustomPattern(), value);
        }
        return result;
    }

    @Override
    public String getPatternFromConfig(Map<String, Object> props) {
        return this.get(props, AccountConstants.ACCOUNT_EMAIL_VALIDATION_PATTERN, AccountConstants.DEFAULT_EMAIL_VALIDATION_PATTERN);
    }
}

