/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.types;

import java.util.ArrayList;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;

public class HealthReportOperation {
    private final OrcsTokenService tokenService;
    private final JdbcService jdbcService;

    public HealthReportOperation(OrcsTokenService tokenService, JdbcService jdbcService) {
        this.tokenService = tokenService;
        this.jdbcService = jdbcService;
    }

    public XResultData run() {
        XResultData rd = new XResultData();
        ArrayList attrTypes = new ArrayList();
        attrTypes.addAll(this.tokenService.getAttributeTypes());
        for (ArtifactTypeToken artType : this.tokenService.getArtifactTypes()) {
            for (AttributeTypeToken attrType : artType.getValidAttributeTypes()) {
                attrTypes.remove(attrType);
            }
        }
        rd.log("ORCS Types Health Check\n");
        rd.log("Server: " + System.getProperty("OseeApplicationServer") + "\n");
        rd.log("Attribute Types defined in code without Artifact reference in code: \n");
        for (AttributeTypeToken attrType : attrTypes) {
            if (!attrType.isValid()) continue;
            rd.error(attrType.toStringWithId());
        }
        rd.log("\nAttribute Types used in database and not defined in code: \n");
        try (JdbcStatement chStmt = this.jdbcService.getClient().getStatement();){
            String query = "SELECT DISTINCT attr_type_id FROM osee_attribute";
            chStmt.runPreparedQuery(query, new Object[0]);
            while (chStmt.next()) {
                Long attrTypeId = chStmt.getLong("attr_type_id");
                AttributeTypeGeneric attributeType = this.tokenService.getAttributeTypeOrSentinel(attrTypeId);
                if (!attributeType.isInvalid()) continue;
                rd.error(attrTypeId.toString());
            }
        }
        return rd;
    }
}

