/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthUtils;

public class HealthStatus {
    private final JdbcClient jdbcClient;
    private String auth = "";

    public HealthStatus(JdbcClient jdbcClient, OrcsApi orcsApi) {
        this.jdbcClient = jdbcClient;
        this.auth = (String)orcsApi.userService().getUser().getLoginIds().get(0);
    }

    public List<HealthServer> getServers() {
        ArrayList<HealthServer> servers = new ArrayList<HealthServer>();
        List<String> serverStrings = HealthUtils.getServers(this.jdbcClient);
        for (String server : serverStrings) {
            HealthServer link = new HealthServer();
            String urlStr = String.valueOf(server) + "/orcs/branches?branchUuids=1";
            String res = HealthUtils.makeHttpRequestWithStringResult(urlStr, this.auth);
            link = res.contains("\"System Root Branch\"") ? new HealthServer(server, true, true, HealthUtils.getErrorMsg()) : (HealthUtils.getErrorMsg() == "" ? new HealthServer(server, true, false, HealthUtils.getErrorMsg()) : new HealthServer(server, false, false, HealthUtils.getErrorMsg()));
            servers.add(link);
        }
        return servers;
    }

    public class HealthServer {
        private String name = "";
        private Boolean serverAlive = false;
        private Boolean dbAlive = false;
        private String errorMsg = "";

        public HealthServer() {
        }

        public HealthServer(String name, Boolean serverAlive, Boolean dbAlive, String errorMsg) {
            this.name = name;
            this.serverAlive = serverAlive;
            this.dbAlive = dbAlive;
            this.errorMsg = errorMsg;
        }

        public String getName() {
            return this.name;
        }

        public Boolean getServerAlive() {
            return this.serverAlive;
        }

        public Boolean getDbAlive() {
            return this.dbAlive;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }
    }
}

