/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;

public class HealthSqlTableSize {
    private final OrcsApi orcsApi;
    private String errorMsg = "";
    private Integer size;

    public HealthSqlTableSize(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void querySqlHealthTableSize() {
        if (this.orcsApi.getJdbcService().getClient().getDbType().equals((Object)JdbcDbType.oracle)) {
            List<String> password = this.getPassword();
            if (password.size() == 1) {
                String setRoleQuery = "SET ROLE osee_health IDENTIFIED BY " + password.get(0);
                this.orcsApi.getJdbcService().getClient().runCall(setRoleQuery, new Object[0]);
                String selectCountFromMonitoringQuery = "SELECT COUNT(*) AS ROW_COUNT FROM OSEE_SQL_MONITORING";
                Consumer<JdbcStatement> consumer = stmt -> {
                    this.size = stmt.getInt("ROW_COUNT");
                };
                this.orcsApi.getJdbcService().getClient().runQuery(consumer, selectCountFromMonitoringQuery, new Object[0]);
                String unsetRoleQuery = "SET ROLE ALL EXCEPT osee_health";
                this.orcsApi.getJdbcService().getClient().runCall(unsetRoleQuery, new Object[0]);
            }
        } else if (this.orcsApi.getJdbcService().getClient().getDbType().equals((Object)JdbcDbType.postgresql)) {
            String selectCountFromStatsQuery = "select count(*) as row_count from pg_stat_statements";
            Consumer<JdbcStatement> consumer = stmt -> {
                this.size = stmt.getInt("row_count");
            };
            this.orcsApi.getJdbcService().getClient().runQuery(consumer, selectCountFromStatsQuery, new Object[0]);
        } else {
            this.errorMsg = "Using unsupported database";
        }
    }

    private List<String> getPassword() {
        ArrayList<String> password = new ArrayList<String>();
        Consumer<JdbcStatement> consumer = stmt -> password.add(stmt.getString("OSEE_VALUE"));
        String selectPasswordQuery = "SELECT OSEE_VALUE FROM OSEE_INFO WHERE OSEE_KEY = 'osee.health.view.password'";
        this.orcsApi.getJdbcService().getClient().runQuery(consumer, selectPasswordQuery, new Object[0]);
        return password;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Integer getSize() {
        return this.size;
    }
}

