/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ThreadStats;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.OseeServerProperties;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;

public class HealthDetails {
    private JdbcClient jdbcClient;
    private IApplicationServerManager applicationServerManager;
    private IAuthenticationManager authManager;
    private ActivityLog activityLog;
    private final RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
    private final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private String uri = "";
    private String startTime = "";
    private String upTime = "";
    private String authScheme = "";
    private List<String> authSchemeSupported = new ArrayList<String>();
    private String heapMemAlloc = "";
    private String heapMemMax = "";
    private String heapMemUsed = "";
    private String nonHeapMemAlloc = "";
    private String nonHeapMemMax = "";
    private String nonHeapMemUsed = "";
    private String codeLocation = "";
    private String systemLoad = "";
    private List<String> supportedVersions = new ArrayList<String>();
    private String serverId = "";
    private String binaryDataPath = "";
    private final List<String> threadStats = new ArrayList<String>();
    private final List<String> garbageCollectorStats = new ArrayList<String>();
    private String serverWithHealthInfo = "";

    public HealthDetails() {
    }

    public HealthDetails(JdbcClient jdbcClient, IApplicationServerManager applicationServerManager, IAuthenticationManager authManager, ActivityLog activityLog) {
        this.jdbcClient = jdbcClient;
        this.applicationServerManager = applicationServerManager;
        this.authManager = authManager;
        this.activityLog = activityLog;
    }

    public void setHealthDetails() {
        this.uri = this.applicationServerManager.getServerUri().toString();
        this.startTime = DateFormat.getDateTimeInstance(1, 1).format(this.applicationServerManager.getDateStarted());
        int seconds = (int)(this.runtimeMxBean.getUptime() / 1000L) % 60;
        int minutes = (int)(this.runtimeMxBean.getUptime() / 60000L % 60L);
        int hours = (int)(this.runtimeMxBean.getUptime() / 3600000L % 24L);
        int days = (int)(this.runtimeMxBean.getUptime() / 86400000L);
        this.upTime = String.format("%s days %s hr %s min %s sec", days, hours, minutes, seconds);
        this.authScheme = this.authManager.getProtocol();
        this.authSchemeSupported = Arrays.asList(this.authManager.getProtocols());
        MemoryUsage heapMem = this.memoryMXBean.getHeapMemoryUsage();
        this.heapMemAlloc = Lib.toMBytes((long)heapMem.getCommitted());
        this.heapMemMax = Lib.toMBytes((long)heapMem.getMax());
        this.heapMemUsed = Lib.toMBytes((long)heapMem.getUsed());
        MemoryUsage nonHeapMem = this.memoryMXBean.getNonHeapMemoryUsage();
        this.nonHeapMemAlloc = Lib.toMBytes((long)nonHeapMem.getCommitted());
        this.nonHeapMemMax = Lib.toMBytes((long)nonHeapMem.getMax());
        this.nonHeapMemUsed = Lib.toMBytes((long)nonHeapMem.getUsed());
        this.codeLocation = System.getProperty("user.dir");
        this.systemLoad = String.valueOf(this.osMxBean.getSystemLoadAverage());
        this.supportedVersions = Arrays.asList(this.applicationServerManager.getVersions());
        this.serverId = this.applicationServerManager.getId();
        this.binaryDataPath = OseeServerProperties.getOseeApplicationServerData(null);
        ThreadStats[] thread = this.activityLog.getThreadActivity();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            this.activityLog.createThrowableEntry(CoreActivityTypes.OSEE_ERROR, (Throwable)ex);
        }
        for (String threadStr : this.activityLog.getThreadActivityDelta(thread)) {
            this.threadStats.add(threadStr);
        }
        this.garbageCollectorStats.addAll(this.activityLog.getGarbageCollectionStats());
        String fetchedServerName = (String)this.jdbcClient.fetch((Object)"", "Select OSEE_VALUE FROM osee_info where OSEE_KEY = ?", new Object[]{"osee.health.curl.server"});
        this.serverWithHealthInfo = Strings.isInValid((String)fetchedServerName) ? "" : fetchedServerName;
    }

    public String getUri() {
        return this.uri;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getUpTime() {
        return this.upTime;
    }

    public String getAuthScheme() {
        return this.authScheme;
    }

    public List<String> getAuthSchemeSupported() {
        return this.authSchemeSupported;
    }

    public String getHeapMemAlloc() {
        return this.heapMemAlloc;
    }

    public String getHeapMemMax() {
        return this.heapMemMax;
    }

    public String getHeapMemUsed() {
        return this.heapMemUsed;
    }

    public String getNonHeapMemAlloc() {
        return this.nonHeapMemAlloc;
    }

    public String getNonHeapMemMax() {
        return this.nonHeapMemMax;
    }

    public String getNonHeapMemUsed() {
        return this.nonHeapMemUsed;
    }

    public String getCodeLocation() {
        return this.codeLocation;
    }

    public String getSystemLoad() {
        return this.systemLoad;
    }

    public List<String> getSupportedVersions() {
        return this.supportedVersions;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getBinaryDataPath() {
        return this.binaryDataPath;
    }

    public List<String> getThreadStats() {
        return this.threadStats;
    }

    public List<String> getGarbageCollectorStats() {
        return this.garbageCollectorStats;
    }

    public String getServerWithHealthInfo() {
        return this.serverWithHealthInfo;
    }
}

