/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthActiveMq;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthBalancers;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthDbTablespace;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthDetails;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthJava;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthLog;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthSql;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthSqlTableSize;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthStatus;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthTop;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthUsage;
import org.eclipse.osee.orcs.rest.internal.health.operations.RemoteHealthDetails;
import org.eclipse.osee.orcs.rest.internal.health.operations.RemoteHealthJava;
import org.eclipse.osee.orcs.rest.internal.health.operations.RemoteHealthLog;
import org.eclipse.osee.orcs.rest.internal.health.operations.RemoteHealthTop;

@Path(value="")
@Swagger
public final class HealthEndpointImpl {
    private final IApplicationServerManager applicationServerManager;
    private final IAuthenticationManager authManager;
    private final ActivityLog activityLog;
    private final OrcsApi orcsApi;
    private final Map<String, JdbcService> jdbcServices;

    public HealthEndpointImpl(OrcsApi orcsApi, IApplicationServerManager applicationServerManager, Map<String, JdbcService> jdbcServices, IAuthenticationManager authManager, ActivityLog activityLog) {
        this.orcsApi = orcsApi;
        this.applicationServerManager = applicationServerManager;
        this.jdbcServices = jdbcServices;
        this.authManager = authManager;
        this.activityLog = activityLog;
    }

    private JdbcClient getJdbcClient() {
        return this.jdbcServices.values().iterator().next().getClient();
    }

    @GET
    @Path(value="status")
    @Produces(value={"application/json"})
    public HealthStatus getHealthStatus() {
        return new HealthStatus(this.getJdbcClient(), this.orcsApi);
    }

    @GET
    @Path(value="details")
    @Produces(value={"application/json"})
    public HealthDetails getHealthDetails() {
        HealthDetails details = new HealthDetails(this.getJdbcClient(), this.applicationServerManager, this.authManager, this.activityLog);
        details.setHealthDetails();
        return details;
    }

    @GET
    @Path(value="details/remote")
    @Produces(value={"application/json"})
    public RemoteHealthDetails getRemoteHealthDetails(@QueryParam(value="remoteServerName") String remoteServerName) {
        RemoteHealthDetails details = new RemoteHealthDetails(remoteServerName, this.orcsApi);
        details.fetchRemoteHealthDetails();
        return details;
    }

    @GET
    @Path(value="log")
    @Produces(value={"application/json"})
    public HealthLog getHealthLog(@QueryParam(value="appServerDir") String appServerDir, @QueryParam(value="serverUri") String serverUri) {
        HealthLog log = new HealthLog(appServerDir, serverUri);
        log.setHealthLog();
        return log;
    }

    @GET
    @Path(value="log/remote")
    @Produces(value={"application/json"})
    public RemoteHealthLog getRemoteHealthLog(@QueryParam(value="remoteServerName") String remoteServerName, @QueryParam(value="appServerDir") String appServerDir, @QueryParam(value="serverUri") String serverUri) {
        RemoteHealthLog log = new RemoteHealthLog(remoteServerName, appServerDir, serverUri, this.orcsApi);
        log.fetchRemoteHealthLog();
        return log;
    }

    @GET
    @Path(value="balancers")
    @Produces(value={"application/json"})
    public HealthBalancers getHealthBalancers() {
        HealthBalancers bal = new HealthBalancers(this.getJdbcClient(), this.orcsApi);
        bal.getBalancers();
        return new HealthBalancers(this.getJdbcClient(), this.orcsApi);
    }

    @GET
    @Path(value="top")
    @Produces(value={"application/json"})
    public HealthTop getHealthTop() {
        HealthTop top = new HealthTop();
        top.setTop();
        return top;
    }

    @GET
    @Path(value="top/remote")
    @Produces(value={"application/json"})
    public RemoteHealthTop getRemoteHealthTop(@QueryParam(value="remoteServerName") String remoteServerName) {
        RemoteHealthTop top = new RemoteHealthTop(remoteServerName, this.orcsApi);
        top.fetchRemoteHealthTop();
        return top;
    }

    @GET
    @Path(value="java")
    @Produces(value={"application/json"})
    public HealthJava getHealthJava() {
        HealthJava javaInfo = new HealthJava(this.getJdbcClient(), this.orcsApi);
        javaInfo.setJavaInfo();
        return javaInfo;
    }

    @GET
    @Path(value="java/remote")
    @Produces(value={"application/json"})
    public RemoteHealthJava getRemoteHealthJava(@QueryParam(value="remoteServerName") String remoteServerName) {
        RemoteHealthJava javaInfo = new RemoteHealthJava(remoteServerName, this.orcsApi);
        javaInfo.fetchRemoteHealthJava();
        return javaInfo;
    }

    @GET
    @Path(value="http/headers")
    @Produces(value={"application/json"})
    public String getHealthHttpHeaders(@Context HttpHeaders headers) {
        MultivaluedMap reqHeaders = headers.getRequestHeaders();
        HashMap jsonMap = new HashMap();
        reqHeaders.forEach((key, values) -> jsonMap.put(key, values.size() == 1 ? values.get(0) : values));
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString(jsonMap);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @GET
    @Path(value="activemq")
    @Produces(value={"application/json"})
    public HealthActiveMq getHealthActiveMq() {
        HealthActiveMq activeMqInfo = new HealthActiveMq(this.getJdbcClient());
        activeMqInfo.setActiveMqInfo();
        return activeMqInfo;
    }

    @GET
    @Path(value="usage")
    @Produces(value={"application/json"})
    public HealthUsage getUsage() {
        HealthUsage usage = new HealthUsage(this.orcsApi, this.getJdbcClient());
        usage.calculateUsage();
        return usage;
    }

    @GET
    @Path(value="prometheus")
    @Produces(value={"text/plain"})
    public String getPrometheusUrl(@QueryParam(value="url") String url) {
        if (url != null && url.length() > 0) {
            OseeInfo.setValue((JdbcClient)this.getJdbcClient(), (String)"osee.health.prometheus.url", (String)url);
        }
        try {
            String updatedUrl = OseeInfo.getValue((JdbcClient)this.getJdbcClient(), (String)"osee.health.prometheus.url");
            return String.valueOf(updatedUrl) + "/graph?g0.expr=jvm_memory_bytes_used{area%3D%22heap%22}&g0.tab=0&g0.stacked=0&g0.show_exemplars=0&g0.range_input=1h";
        }
        catch (Exception exception) {
            return "Error: key [osee.health.prometheus.url] is NOT SET in table [osee_info]";
        }
    }

    @GET
    @Path(value="osee.health.servers")
    @Produces(value={"text/plain"})
    public String getServersTableEntry(@QueryParam(value="servers") String servers) {
        if (servers != null && servers.length() > 0) {
            OseeInfo.setValue((JdbcClient)this.getJdbcClient(), (String)"osee.health.servers", (String)servers);
        }
        try {
            String updatedServers = OseeInfo.getValue((JdbcClient)this.getJdbcClient(), (String)"osee.health.servers");
            return "Value for key [osee.health.servers] in table [osee_info]: " + updatedServers;
        }
        catch (Exception exception) {
            return "Error: key [osee.health.servers] is NOT SET in table [osee_info]";
        }
    }

    @GET
    @Path(value="osee.health.balancers")
    @Produces(value={"text/plain"})
    public String getBalancersTableEntry(@QueryParam(value="balancers") String balancers) {
        if (balancers != null && balancers.length() > 0) {
            OseeInfo.setValue((JdbcClient)this.getJdbcClient(), (String)"osee.health.balancers", (String)balancers);
        }
        try {
            String updatedBalancers = OseeInfo.getValue((JdbcClient)this.getJdbcClient(), (String)"osee.health.balancers");
            return "Value for key [osee.health.balancers] in table [osee_info]: " + updatedBalancers;
        }
        catch (Exception exception) {
            return "Error: key [osee.health.servers] is NOT SET in table [osee_info]";
        }
    }

    @GET
    @Path(value="db/sql")
    @Produces(value={"application/json"})
    public HealthSql getSqlHealth(@QueryParam(value="pageNum") long pageNum, @QueryParam(value="pageSize") long pageSize, @QueryParam(value="orderByName") String orderByName, @QueryParam(value="orderByDirection") String orderByDirection) {
        if (orderByName == null) {
            orderByName = "";
        }
        if (orderByDirection == null) {
            orderByDirection = "";
        }
        HealthSql sql = new HealthSql(this.orcsApi, ++pageNum, pageSize, orderByName, orderByDirection);
        sql.querySqlHealth();
        return sql;
    }

    @GET
    @Path(value="db/tablespace")
    @Produces(value={"application/json"})
    public HealthDbTablespace getDbTablespaceStats(@QueryParam(value="orderByName") String orderByName, @QueryParam(value="orderByDirection") String orderByDirection) {
        if (orderByName == null) {
            orderByName = "";
        }
        if (orderByDirection == null) {
            orderByDirection = "";
        }
        HealthDbTablespace ts = new HealthDbTablespace(this.orcsApi, orderByName, orderByDirection);
        ts.queryDbTablespace();
        return ts;
    }

    @GET
    @Path(value="db/sql/size")
    @Produces(value={"application/json"})
    public HealthSqlTableSize getSqlHealthTableSize() {
        HealthSqlTableSize size = new HealthSqlTableSize(this.orcsApi);
        size.querySqlHealthTableSize();
        return size;
    }
}

