/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.applicability;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.applicability.ApplicabilityUseResultToken;
import org.eclipse.osee.framework.core.applicability.BatFile;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.applicability.ProductTypeDefinition;
import org.eclipse.osee.framework.core.data.ApplicabilityData;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ApplicabilityTokenWithConstraints;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BlockApplicabilityStageRequest;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.ConfigurationGroupDefinition;
import org.eclipse.osee.framework.core.data.CreateViewDefinition;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ApplicabilityEndpointImpl
implements ApplicabilityEndpoint {
    private final OrcsApi orcsApi;
    private final BranchId branch;
    private final ApplicabilityQuery applicabilityQuery;
    private final OrcsApplicability ops;

    public ApplicabilityEndpointImpl(OrcsApi orcsApi, BranchId branch) {
        this.orcsApi = orcsApi;
        this.branch = branch;
        this.applicabilityQuery = orcsApi.getQueryFactory().applicabilityQuery();
        this.ops = orcsApi.getApplicabilityOps();
    }

    public Collection<ApplicabilityToken> getApplicabilityTokens() {
        return this.applicabilityQuery.getApplicabilityTokens(this.branch).values();
    }

    public Collection<ApplicabilityToken> getApplicabilityTokens(boolean orderByName, String filter, Long pageNum, Long pageSize) {
        return this.applicabilityQuery.getApplicabilityTokens(this.branch, orderByName, filter, pageNum, pageSize);
    }

    public Long getApplicabilityTokenCount(String filter) {
        return this.applicabilityQuery.getApplicabilityTokenCount(this.branch, filter);
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(List<? extends ArtifactId> artIds) {
        return this.applicabilityQuery.getApplicabilityTokens(artIds, this.branch);
    }

    public ApplicabilityToken getApplicabilityToken(ArtifactId artId) {
        return this.applicabilityQuery.getApplicabilityToken(artId, this.branch);
    }

    public List<ApplicabilityId> getApplicabilitiesReferenced(ArtifactId artifact) {
        return this.applicabilityQuery.getApplicabilitiesReferenced(artifact, this.branch);
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokensForArts(Collection<? extends ArtifactId> artIds) {
        ArrayList<Pair<ArtifactId, ApplicabilityToken>> artToApplicToken = new ArrayList<Pair<ArtifactId, ApplicabilityToken>>();
        for (ArtifactId artifactId : artIds) {
            artToApplicToken.add((Pair<ArtifactId, ApplicabilityToken>)new Pair((Object)artifactId, (Object)this.getApplicabilityToken(artifactId)));
        }
        return artToApplicToken;
    }

    public List<ApplicabilityToken> getApplicabilityReferenceTokens(ArtifactId artifact) {
        return this.applicabilityQuery.getApplicabilityReferenceTokens(artifact, this.branch);
    }

    public List<ApplicabilityToken> getViewApplicabilityTokens(ArtifactId view) {
        return this.applicabilityQuery.getViewApplicabilityTokens(view, this.branch);
    }

    public List<ApplicabilityToken> getViewApplicabilityTokens(ArtifactId view, String productType) {
        return this.applicabilityQuery.getViewApplicabilityTokens(view, this.branch, productType);
    }

    public List<ArtifactToken> getViews(AttributeTypeToken orderByAttributeType) {
        return orderByAttributeType == null ? this.applicabilityQuery.getViewsForBranch(this.branch).stream().map(a -> a.getToken()).collect(Collectors.toList()) : this.applicabilityQuery.getViewsForBranch(this.branch, orderByAttributeType).stream().map(a -> a.getToken()).collect(Collectors.toList());
    }

    public List<ArtifactToken> getViews() {
        return this.getViews((AttributeTypeToken)CoreAttributeTypes.Name);
    }

    public List<ArtifactToken> getCfgGroup() {
        return this.applicabilityQuery.getConfigurationGroupsForBranch(this.branch).stream().map(a -> a.getToken()).collect(Collectors.toList());
    }

    public List<FeatureDefinition> getFeatureDefinitionData(String productType) {
        return this.applicabilityQuery.getFeatureDefinitionData(this.branch, productType);
    }

    public List<FeatureDefinition> getFeatureDefinitionData() {
        return this.applicabilityQuery.getFeatureDefinitionData(this.branch);
    }

    public List<BranchId> getAffectedBranches(Long injectDateMs, Long removalDateMs, List<ApplicabilityId> applicabilityIds) {
        return this.applicabilityQuery.getAffectedBranches(injectDateMs, removalDateMs, applicabilityIds, this.branch);
    }

    public List<BranchId> getAffectedBranches(TransactionId injectionTx, TransactionId removalTx, List<ApplicabilityId> applicabilityIds) {
        return this.applicabilityQuery.getAffectedBranches(injectionTx, removalTx, applicabilityIds, this.branch);
    }

    public TransactionToken setApplicability(ApplicabilityId applicId, List<? extends ArtifactId> artifacts) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return TransactionToken.SENTINEL;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, "Set Applicability Ids for Artifacts");
        tx.setApplicability(applicId, artifacts);
        return tx.commit();
    }

    public TransactionToken setApplicabilityByString(String applicTag, List<? extends ArtifactId> artifacts) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return TransactionToken.SENTINEL;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, "Set Applicability Ids for Artifacts");
        Long putIfAbsent = this.orcsApi.getKeyValueOps().putIfAbsent(applicTag);
        ApplicabilityToken applicId = new ApplicabilityToken(putIfAbsent, applicTag);
        tx.setApplicability((ApplicabilityId)applicId, artifacts);
        return tx.commit();
    }

    public TransactionToken setApplicabilityReference(List<ApplicabilityData> appDatas) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return TransactionToken.SENTINEL;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(this.branch, "Set Reference Applicability Ids for Artifacts");
        HashMap<ArtifactId, List> artToApplMap = new HashMap<ArtifactId, List>();
        for (ApplicabilityData data : appDatas) {
            artToApplMap.put(data.getArtifact(), Collections.castAll((Collection)data.getApplIds()));
        }
        tx.setApplicabilityReference(artToApplMap);
        return tx.commit();
    }

    public XResultData createApplicabilityForView(ArtifactId viewId, String applicability) {
        XResultData results = this.isAccess();
        if (results.isErrors()) {
            return results;
        }
        return this.ops.createApplicabilityForView(viewId, applicability, this.branch);
    }

    public XResultData copyFeatureApplicValues(ArtifactId viewId, BranchId fromBranchId, ArtifactId fromViewId, boolean overwrite) {
        XResultData results = this.isAccess();
        List<FeatureDefinition> featureDefinitionData = this.getFeatureDefinitionData();
        List<ApplicabilityToken> currentAppViews = this.getViewApplicabilityTokens(viewId);
        for (ApplicabilityToken applicabilityToken : this.orcsApi.getQueryFactory().applicabilityQuery().getViewApplicabilityTokens(fromViewId, fromBranchId)) {
            if (applicabilityToken.getName().equals("Base") || applicabilityToken.getName().startsWith("Config =") || applicabilityToken.getName().startsWith("ConfigurationGroup =")) continue;
            String featureName = applicabilityToken.getName().substring(0, applicabilityToken.getName().indexOf("=") - 1);
            if (!featureDefinitionData.stream().anyMatch(a -> a.getName().equals(featureName)) || currentAppViews.stream().anyMatch(a -> a.getName().startsWith(String.valueOf(featureName) + " =") || overwrite)) continue;
            System.out.println("added: " + applicabilityToken + " Results: " + this.createApplicabilityForView(viewId, applicabilityToken.getName()).toString());
        }
        return results;
    }

    public XResultData createCompoundApplicabilityForBranch(String applicability) {
        XResultData results = this.isAccess();
        if (results.isErrors()) {
            return results;
        }
        return this.ops.createCompoundApplicabilityForBranch(applicability, this.branch);
    }

    public XResultData deleteCompoundApplicabilityFromBranch(ApplicabilityId compApplicId) {
        XResultData results = this.isAccess();
        if (results.isErrors()) {
            return results;
        }
        return this.ops.deleteCompoundApplicabilityFromBranch(compApplicId, this.branch);
    }

    public XResultData validate(String update) {
        XResultData results = this.isAccess();
        boolean makeUpdates = false;
        if (Strings.isValid((String)update) && update.equals("true")) {
            makeUpdates = true;
        }
        if (makeUpdates) {
            this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        }
        results = this.ops.validate(this.branch, makeUpdates, results);
        this.ops.validateCompoundApplicabilities(this.branch, makeUpdates, results);
        return results;
    }

    public XResultData removeApplicabilityFromView(ArtifactId viewId, String applicability) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        XResultData results = this.isAccess();
        if (results.isErrors()) {
            return results;
        }
        results = this.ops.removeApplicabilityFromView(this.branch, viewId, applicability);
        for (ArtifactReadable grp : this.orcsApi.getQueryFactory().applicabilityQuery().getConfigurationGroupsForBranch(this.branch).stream().filter(a -> a.getRelated(CoreRelationTypes.PlConfigurationGroup_BranchView).getList().stream().anyMatch(b -> b.getId() == viewId.getId())).collect(Collectors.toList())) {
            this.ops.syncConfigGroup(this.branch, grp.getIdString(), results);
        }
        return results;
    }

    public void addMissingApplicabilityFromParentBranch() {
        this.orcsApi.getBranchOps().addMissingApplicabilityFromParentBranch(this.branch);
    }

    public String getViewTable(String filter, ArtifactId view) {
        boolean isSingleAccess;
        String pleAccess = this.orcsApi.getSystemProperties().getValue("ple.access");
        boolean bl = pleAccess.isEmpty() ? false : (isSingleAccess = pleAccess.equals("SINGLE"));
        if (view.isInvalid() && !pleAccess.isEmpty() && isSingleAccess) {
            return null;
        }
        return this.applicabilityQuery.getViewTable(this.branch, filter, view);
    }

    public String getConfigMatrix(String matrixType, String filter, ArtifactId view) {
        boolean isSingleAccess;
        String mType = "all";
        String pleAccess = this.orcsApi.getSystemProperties().getValue("ple.access");
        boolean bl = pleAccess.isEmpty() ? false : (isSingleAccess = pleAccess.equals("SINGLE"));
        if (view.isInvalid() && !pleAccess.isEmpty() && isSingleAccess) {
            return null;
        }
        if (matrixType != null) {
            mType = matrixType;
        }
        return this.applicabilityQuery.getConfigMatrix(this.branch, mType, filter, view);
    }

    public FeatureDefinition getFeature(String featureNameOrId) {
        return this.ops.getFeature(featureNameOrId, this.branch);
    }

    public XResultData updateFeature(FeatureDefinition feature) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.updateFeature(feature, this.branch);
    }

    public XResultData createFeature(FeatureDefinition feature) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.createFeature(feature, this.branch);
    }

    public XResultData deleteFeature(ArtifactId feature) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.deleteFeature(feature, this.branch);
    }

    public XResultData updateView(CreateViewDefinition view) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.updateView(view, this.branch);
    }

    public XResultData createView(CreateViewDefinition view) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.createView(view, this.branch);
    }

    public XResultData deleteView(@PathParam(value="id") String id) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.deleteView(id, this.branch);
    }

    public CreateViewDefinition getView(String id) {
        return this.ops.getView(id, this.branch);
    }

    public XResultData isAccess() {
        Branch brch;
        XResultData rd = new XResultData();
        if (OseeProperties.isInTest()) {
            rd.logf("Access granted to branch cause isInTest", new Object[0]);
        }
        if ((brch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(this.branch)).getResults().getAtMostOneOrNull()).getBranchType() == BranchType.WORKING) {
            rd.log("Access granted to working branch");
        } else {
            rd.error("Access denied to non-working branch");
        }
        return rd;
    }

    public XResultData createCfgGroup(ConfigurationGroupDefinition group) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.createCfgGroup(group, this.branch);
    }

    public XResultData updateCfgGroup(ConfigurationGroupDefinition group) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.updateCfgGroup(group, this.branch);
    }

    public XResultData relateCfgGroupToView(String groupId, String viewId) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.OseeAccessAdmin});
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.relateCfgGroupToView(groupId, viewId, this.branch);
    }

    public XResultData unrelateCfgGroupToView(String groupId, String viewId) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.unrelateCfgGroupToView(groupId, viewId, this.branch);
    }

    public XResultData deleteCfgGroup(String id) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.deleteCfgGroup(id, this.branch);
    }

    public XResultData syncCfgGroup(String id) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.syncConfigGroup(this.branch, id, null);
    }

    public XResultData syncCfgGroup() {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.syncConfigGroup(this.branch);
    }

    public XResultData applyBlockVisibility(BlockApplicabilityStageRequest data) {
        return this.ops.applyApplicabilityToFiles(data, this.branch);
    }

    public XResultData refreshStagedFiles(BlockApplicabilityStageRequest data) {
        return this.ops.refreshStagedFiles(data, this.branch);
    }

    public XResultData startBlockVisibilityWatcher(BlockApplicabilityStageRequest data) {
        return this.ops.startWatcher(data, this.branch);
    }

    public XResultData stopBlockVisibilityWatcher() {
        return this.ops.stopWatcher();
    }

    public ConfigurationGroupDefinition getConfigurationGroup(String id) {
        return this.ops.getConfigurationGroup(id, this.branch);
    }

    public ApplicabilityToken getApplicabilityTokenFromId(String id) {
        Optional<ApplicabilityToken> findAny = this.getApplicabilityTokens().stream().filter(a -> a.getIdString().equals(id)).findAny();
        if (findAny.isPresent()) {
            return findAny.get();
        }
        return ApplicabilityToken.SENTINEL;
    }

    public List<ApplicabilityUseResultToken> getApplicabilityUsage(String applic, List<ArtifactTypeToken> artTypes, List<AttributeTypeToken> attrTypes) {
        return this.applicabilityQuery.getApplicabilityUsage(this.branch, applic, artTypes, attrTypes);
    }

    public XResultData createProductType(ProductTypeDefinition productType) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.createProductType(productType, this.branch);
    }

    public ProductTypeDefinition getProductType(String id) {
        return this.ops.getProductType(id, this.branch);
    }

    public Collection<ProductTypeDefinition> getProductTypes(long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        return this.ops.getProductTypeDefinitions(this.branch, pageNum, pageSize, orderByAttributeType);
    }

    public XResultData updateProductType(ProductTypeDefinition productType) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.updateProductType(productType, this.branch);
    }

    public XResultData deleteProductType(ArtifactId id) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.deleteProductType(id, this.branch);
    }

    public String uploadBlockApplicability(InputStream zip) {
        return this.ops.uploadBlockApplicability(zip);
    }

    public XResultData applyBlockVisibilityOnServer(String blockApplicId, BlockApplicabilityStageRequest data) {
        return this.ops.applyBlockVisibilityOnServer(blockApplicId, data, this.branch);
    }

    public Response downloadBlockApplicability(String blockApplicId) {
        File serverApplicDir;
        String serverDataPath = System.getProperty("osee.application.server.data");
        if (serverDataPath == null) {
            serverDataPath = System.getProperty("user.home");
        }
        if (!(serverApplicDir = new File(String.valueOf(serverDataPath) + File.separator + "blockApplicability")).isDirectory()) {
            return Response.noContent().build();
        }
        File stagingZip = new File(String.format("%s%s%s%sstaging.zip", serverApplicDir.getPath(), File.separator, blockApplicId, File.separator));
        if (stagingZip.exists()) {
            try {
                return Response.ok((Object)Files.readAllBytes(stagingZip.toPath())).type("application/zip").header("Content-Disposition", (Object)"attachment; filename=\"staging.zip\"").build();
            }
            catch (IOException iOException) {
                return Response.serverError().build();
            }
        }
        return Response.noContent().build();
    }

    public XResultData deleteBlockApplicability(String blockApplicId) {
        return this.ops.deleteBlockApplicability(blockApplicId);
    }

    public Response uploadRunBlockApplicability(Long view, InputStream zip) {
        String id = this.ops.uploadRunBlockApplicability(view, zip, this.branch);
        return this.downloadBlockApplicability(id);
    }

    public XResultData addApplicabilityConstraint(ApplicabilityId applicability1, ApplicabilityId applicability2) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.addApplicabilityConstraint(applicability1, applicability2, this.branch);
    }

    public XResultData removeApplicabilityConstraint(ApplicabilityId applicability1, ApplicabilityId applicability2) {
        XResultData access = this.isAccess();
        if (access.isErrors()) {
            return access;
        }
        return this.ops.removeApplicabilityConstraint(applicability1, applicability2, this.branch);
    }

    public List<ApplicabilityTokenWithConstraints> getApplicabilityWithConstraints() {
        return this.ops.getApplicabilityWithConstraints(this.branch);
    }

    public List<String> getApplicabilityConstraintConflicts(ApplicabilityId childApplic, ApplicabilityId parentApplic) {
        return this.ops.getApplicabilityConstraintConflicts(childApplic, parentApplic, this.branch);
    }

    public String getBazelFeatures() {
        return this.ops.getFeatureBazelFile(this.branch, (Collection)this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).asArtifacts());
    }

    public String getBazelPlatformConfigurations() {
        return this.ops.getConfigurationPlatformBazelFile(this.branch, (Collection)this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifacts(), (Collection)this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).follow(CoreRelationTypes.PlConfigurationGroup_BranchView).asArtifacts(), (Collection)this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).asArtifacts());
    }

    public String getBazelPlatformConfigurationGroups() {
        return this.ops.getConfigurationGroupBazelFile(this.branch, (Collection)this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).follow(CoreRelationTypes.PlConfigurationGroup_BranchView).asArtifacts(), (Collection)this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).asArtifacts());
    }

    public String getBazelConfigurations() {
        return this.ops.getConfigurationBazelFile(this.branch, (Collection)this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).follow(CoreRelationTypes.PlConfigurationGroup_BranchView).asArtifacts(), (Collection)this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifacts());
    }

    public Response getBazelZip(String productType) {
        ByteArrayOutputStream byteArrayOutputStream;
        block16: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            try {
                try {
                    byte[] valueToWrite;
                    ObjectMapper mapper;
                    Collection batConfigFile;
                    ZipEntry batFile;
                    QueryBuilder featureQuery = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature});
                    if (!productType.isEmpty()) {
                        featureQuery = featureQuery.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.ProductApplicability, productType);
                    }
                    List features = featureQuery.asArtifacts();
                    QueryBuilder configurationQuery = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView});
                    if (!productType.isEmpty()) {
                        configurationQuery = configurationQuery.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.ProductApplicability, productType);
                    }
                    List configurations = configurationQuery.follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifacts();
                    QueryBuilder configurationGroupQuery = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder);
                    if (!productType.isEmpty()) {
                        configurationGroupQuery = configurationGroupQuery.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.ProductApplicability, productType);
                    }
                    List configurationGroups = configurationGroupQuery.follow(CoreRelationTypes.PlConfigurationGroup_BranchView).asArtifacts();
                    ZipEntry configurationFile = new ZipEntry("config/BUILD.bazel");
                    configurationFile.setTime(0L);
                    zipOutputStream.putNextEntry(configurationFile);
                    zipOutputStream.write(this.ops.getConfigurationBazelFile(this.branch, (Collection)configurationGroups, (Collection)configurations).getBytes());
                    zipOutputStream.closeEntry();
                    ZipEntry configurationPlatformFile = new ZipEntry("platforms/configurations/BUILD.bazel");
                    configurationPlatformFile.setTime(0L);
                    zipOutputStream.putNextEntry(configurationPlatformFile);
                    zipOutputStream.write(this.ops.getConfigurationPlatformBazelFile(this.branch, (Collection)configurations, (Collection)configurationGroups, (Collection)features).getBytes());
                    zipOutputStream.closeEntry();
                    ZipEntry configurationGroupPlatformFile = new ZipEntry("platforms/configuration-groups/BUILD.bazel");
                    configurationGroupPlatformFile.setTime(0L);
                    zipOutputStream.putNextEntry(configurationGroupPlatformFile);
                    zipOutputStream.write(this.ops.getConfigurationGroupBazelFile(this.branch, (Collection)configurationGroups, (Collection)features).getBytes());
                    zipOutputStream.closeEntry();
                    ZipEntry buildFile = new ZipEntry("BUILD.bazel");
                    buildFile.setTime(0L);
                    zipOutputStream.putNextEntry(buildFile);
                    zipOutputStream.write(this.ops.getBazelBuildFile().getBytes());
                    zipOutputStream.closeEntry();
                    ZipEntry workspaceFile = new ZipEntry("WORKSPACE");
                    workspaceFile.setTime(0L);
                    zipOutputStream.putNextEntry(workspaceFile);
                    zipOutputStream.write(this.ops.getBazelWorkspaceFile().getBytes());
                    zipOutputStream.closeEntry();
                    ZipEntry moduleFile = new ZipEntry("MODULE.bazel");
                    moduleFile.setTime(0L);
                    zipOutputStream.putNextEntry(moduleFile);
                    zipOutputStream.write(this.ops.getBazelModuleFile().getBytes());
                    zipOutputStream.closeEntry();
                    ZipEntry featureFile = new ZipEntry("feature/BUILD.bazel");
                    featureFile.setTime(0L);
                    zipOutputStream.putNextEntry(featureFile);
                    zipOutputStream.write(this.ops.getFeatureBazelFile(this.branch, (Collection)features).getBytes());
                    zipOutputStream.closeEntry();
                    for (ArtifactReadable configuration : configurations) {
                        batFile = new ZipEntry("config_files/" + configuration.getName().replace(" ", "_") + ".json");
                        batFile.setTime(0L);
                        zipOutputStream.putNextEntry(batFile);
                        batConfigFile = this.ops.getBatConfigurationFile(this.branch, configuration, features);
                        mapper = new ObjectMapper();
                        valueToWrite = mapper.writeValueAsBytes((Object)batConfigFile);
                        zipOutputStream.write(valueToWrite);
                        zipOutputStream.closeEntry();
                    }
                    for (ArtifactReadable configurationGroup : configurationGroups) {
                        batFile = new ZipEntry("config_files/" + configurationGroup.getName().replace(" ", "_") + ".json");
                        batFile.setTime(0L);
                        zipOutputStream.putNextEntry(batFile);
                        batConfigFile = this.ops.getBatConfigurationGroupFile(this.branch, configurationGroup, features);
                        mapper = new ObjectMapper();
                        valueToWrite = mapper.writeValueAsBytes((Object)batConfigFile);
                        zipOutputStream.write(valueToWrite);
                        zipOutputStream.closeEntry();
                    }
                    configurations.addAll(configurationGroups);
                    ZipEntry batBuildFile = new ZipEntry("config_files/BUILD.bazel");
                    batBuildFile.setTime(0L);
                    zipOutputStream.putNextEntry(batBuildFile);
                    zipOutputStream.write(this.ops.getBazelConfigFileBuildFile(configurations).getBytes());
                    zipOutputStream.closeEntry();
                    ZipEntry batDefsFile = new ZipEntry("config_files/defs.bzl");
                    batDefsFile.setTime(0L);
                    zipOutputStream.putNextEntry(batDefsFile);
                    zipOutputStream.write(this.ops.getBazelConfigFileDefsFile(configurations).getBytes());
                    zipOutputStream.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        zipOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return Response.ok((Object)byteArrayOutputStream.toByteArray()).type("application/zip").header("Content-Disposition", (Object)"attachment; filename=\"bazel.zip\"").build();
    }

    public Response getRepositoryZip(String productType) {
        ByteArrayOutputStream byteArrayOutputStream;
        block18: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            try {
                try {
                    byte[] valueToWrite;
                    ObjectMapper mapper;
                    Collection batConfigFile;
                    ZipEntry batFile;
                    QueryBuilder featureQuery = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature});
                    if (!productType.isEmpty()) {
                        featureQuery = featureQuery.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.ProductApplicability, productType);
                    }
                    List features = featureQuery.asArtifacts();
                    QueryBuilder configurationQuery = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView});
                    if (!productType.isEmpty()) {
                        configurationQuery = configurationQuery.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.ProductApplicability, productType);
                    }
                    List configurations = configurationQuery.follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifacts();
                    QueryBuilder configurationGroupQuery = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder);
                    if (!productType.isEmpty()) {
                        configurationGroupQuery = configurationGroupQuery.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.ProductApplicability, productType);
                    }
                    List configurationGroups = configurationGroupQuery.follow(CoreRelationTypes.PlConfigurationGroup_BranchView).asArtifacts();
                    for (ArtifactReadable configuration : configurations) {
                        batFile = new ZipEntry("bat/" + configuration.getName().replace(" ", "_") + ".json");
                        batFile.setTime(0L);
                        zipOutputStream.putNextEntry(batFile);
                        batConfigFile = this.ops.getBatConfigurationFile(this.branch, configuration, features);
                        mapper = new ObjectMapper();
                        valueToWrite = mapper.writeValueAsBytes((Object)batConfigFile);
                        zipOutputStream.write(valueToWrite);
                        zipOutputStream.closeEntry();
                    }
                    for (ArtifactReadable configurationGroup : configurationGroups) {
                        batFile = new ZipEntry("bat/" + configurationGroup.getName().replace(" ", "_") + ".json");
                        batFile.setTime(0L);
                        zipOutputStream.putNextEntry(batFile);
                        batConfigFile = this.ops.getBatConfigurationGroupFile(this.branch, configurationGroup, features);
                        mapper = new ObjectMapper();
                        valueToWrite = mapper.writeValueAsBytes((Object)batConfigFile);
                        zipOutputStream.write(valueToWrite);
                        zipOutputStream.closeEntry();
                    }
                    for (ArtifactReadable configuration : configurations) {
                        batFile = new ZipEntry(String.valueOf(configuration.getName().replace(" ", "_")) + ".json");
                        batFile.setTime(0L);
                        zipOutputStream.putNextEntry(batFile);
                        batConfigFile = this.ops.getPatConfigurationFile(this.branch, configuration, features);
                        mapper = new ObjectMapper();
                        valueToWrite = mapper.writeValueAsBytes((Object)batConfigFile);
                        zipOutputStream.write(valueToWrite);
                        zipOutputStream.closeEntry();
                    }
                    for (ArtifactReadable configurationGroup : configurationGroups) {
                        batFile = new ZipEntry(String.valueOf(configurationGroup.getName().replace(" ", "_")) + ".json");
                        batFile.setTime(0L);
                        zipOutputStream.putNextEntry(batFile);
                        batConfigFile = this.ops.getPatConfigurationGroupFile(this.branch, configurationGroup, features);
                        mapper = new ObjectMapper();
                        valueToWrite = mapper.writeValueAsBytes((Object)batConfigFile);
                        zipOutputStream.write(valueToWrite);
                        zipOutputStream.closeEntry();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        zipOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return Response.ok((Object)byteArrayOutputStream.toByteArray()).type("application/zip").header("Content-Disposition", (Object)"attachment; filename=\"repository.zip\"").build();
    }

    public Collection<BatFile> getBlockApplicabilityToolConfiguration(String productType) {
        QueryBuilder featureQuery = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature});
        if (!productType.isEmpty()) {
            featureQuery = featureQuery.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.ProductApplicability, productType);
        }
        List features = featureQuery.asArtifacts();
        QueryBuilder configurationQuery = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView});
        if (!productType.isEmpty()) {
            configurationQuery = configurationQuery.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.ProductApplicability, productType);
        }
        List configurations = configurationQuery.follow(CoreRelationTypes.PlConfigurationGroup_Group).asArtifacts();
        QueryBuilder configurationGroupQuery = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder);
        if (!productType.isEmpty()) {
            configurationGroupQuery = configurationGroupQuery.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.ProductApplicability, productType);
        }
        List configurationGroups = configurationGroupQuery.follow(CoreRelationTypes.PlConfigurationGroup_BranchView).asArtifacts();
        Collection groupFiles = configurationGroups.stream().flatMap(group -> this.ops.getBatConfigurationGroupFile(this.branch, group, features).stream()).collect(Collectors.toList());
        Collection configFiles = configurations.stream().flatMap(configuration -> this.ops.getBatConfigurationFile(this.branch, configuration, features).stream()).collect(Collectors.toList());
        groupFiles.addAll(configFiles);
        return groupFiles;
    }
}

