/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Zip;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.rest.internal.TransactionEndpointImpl;
import org.eclipse.osee.orcs.rest.model.transaction.BranchLocation;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderData;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionTransferManifest;
import org.eclipse.osee.orcs.rest.model.transaction.TransferBranch;
import org.eclipse.osee.orcs.rest.model.transaction.TransferOpType;
import org.eclipse.osee.orcs.rest.model.transaction.TransferTransaction;
import org.eclipse.osee.orcs.rest.model.transaction.TransferTupleTypes;
import org.eclipse.osee.orcs.search.Operator;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class TransferDataStoreImpl {
    private final OrcsApi orcsApi;
    private final TupleQuery tupleQuery;
    private final TransactionEndpointImpl transEndpoint;
    private final TransactionTransferManifest transferManifest = new TransactionTransferManifest();
    private final TransactionTransferManifest regenTransferManifest = new TransactionTransferManifest();
    private final HashMap<TransactionId, TransactionId> regenMap = new HashMap();
    public static String transferDir = "transfers";
    StringBuilder strdebug = new StringBuilder("");

    public TransferDataStoreImpl(TransactionEndpointImpl transEndpoint, OrcsApi orcsApi) {
        this.transEndpoint = transEndpoint;
        this.orcsApi = orcsApi;
        this.tupleQuery = orcsApi.getQueryFactory().tupleQuery();
    }

    public final XResultData transferTransactions(TransactionId exportId, XResultData results, boolean regen, String mode) {
        List<TransactionReadable> txrs = new ArrayList();
        List<BranchLocation> branchLocations = this.branchLocations(exportId);
        String currentTransferDirectory = this.transferDirectoryHelper(exportId);
        TransactionId maxTransactionNum = TransactionId.SENTINEL;
        if (regen && (results = this.readRegenFile(exportId)).isFailed()) {
            return results;
        }
        if (!branchLocations.isEmpty()) {
            for (BranchLocation branchLoc : branchLocations) {
                BranchId branchId = branchLoc.getBranchId();
                Object txId = branchLoc.getBaseTxId();
                if (regen) {
                    TransferBranch branch = this.regenTransferManifest.getTransferBranch(branchId);
                    txId = branch.getPrevTx();
                    if (txId != TransactionId.SENTINEL) {
                        branchLoc.setBaseTxId((TransactionId)txId);
                        branchLoc.setUniqueTxId(branch.getUniqueTx());
                    } else {
                        results.error("Failed to read prev tx from manifest file. ");
                        break;
                    }
                }
                int iniTxId = txId.getIdIntValue();
                txrs = ((TransactionQuery)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andBranch(new BranchId[]{branchId})).andTxId(Operator.GREATER_THAN, iniTxId)).getResults().getList();
                if (txrs.size() < 1) {
                    results.error("Not enough transactions to generate transfer files; Nothing has been updated since the last file was generated.");
                    break;
                }
                maxTransactionNum = (TransactionId)txrs.get(txrs.size() - 1);
                if (maxTransactionNum == txId || maxTransactionNum == TransactionId.SENTINEL) {
                    results.error("During generating transfer files, ending (max) transaction is empty or equivalent to starting (base) transaction");
                    break;
                }
                this.applyTransactions(txrs, branchLoc, results, branchId, currentTransferDirectory, maxTransactionNum);
            }
        }
        if (results.getErrorCount() == 0) {
            this.strdebug.append("Begin attempt to add data to tuple table.");
            try {
                boolean docommit = false;
                TransactionBuilder txTupleTransfer = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, "Adding transfer tuples");
                for (TransferBranch tb : this.transferManifest.getTransferBranches()) {
                    for (TransferTransaction transTx : tb.getTxList()) {
                        if (this.regenMap.get(transTx.getSourceTransId()) != null) continue;
                        txTupleTransfer.addTuple4(TransferTupleTypes.TransferFile, (Object)tb.getBranchId(), (Object)transTx.getTransferOp(), (Object)transTx.getSourceTransId(), (Object)transTx.getSourceUniqueTrans());
                        docommit = true;
                    }
                }
                if (docommit) {
                    txTupleTransfer.commit();
                }
                this.strdebug.append("Tuple Table Data Added!");
                String buildId = "10000";
                this.buildManifestFileHelper(currentTransferDirectory, buildId, exportId, results, maxTransactionNum);
                try {
                    String osee = String.valueOf(this.orcsApi.getSystemProperties().getValue("osee.application.server.data")) + File.separator + transferDir + File.separator;
                    File directoryPath = new File(currentTransferDirectory);
                    Path pathTest = Paths.get(currentTransferDirectory, new String[0]);
                    String zipTarget = String.valueOf(osee) + currentTransferDirectory.replace(osee, "").replace("\\", "") + ".zip";
                    this.strdebug.append("Attemtping to compress files to location: " + zipTarget + " File(s)/Directory(ies) from: " + directoryPath.toString());
                    if (Files.exists(pathTest, new LinkOption[0])) {
                        Zip.compressDirectory((File)directoryPath, (String)zipTarget, (boolean)true);
                        String filename = zipTarget.split(transferDir)[zipTarget.split(transferDir).length - 1].replace("\\", "");
                        results.log(String.format("Transfer file %s is successfully generated.", filename));
                    }
                }
                catch (Exception e) {
                    results.error("Transfer file generation content could not be compressed error: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                results.errorf("%s", new Object[]{"Error in addding tuples exception: ", ex.getMessage()});
            }
        }
        if (mode != null && mode.toLowerCase().contains("debug")) {
            System.out.println("\nFinal Results Log:\n" + results.toString());
            System.out.println(this.strdebug.toString());
        }
        return results;
    }

    private XResultData applyTransactions(List<TransactionReadable> txrs, BranchLocation branchLoc, XResultData results, BranchId branchId, String currentTransferDirectory, TransactionId endTrans) {
        Collections.sort(txrs, new TransactionIdComparator());
        if (!txrs.isEmpty() && endTrans != TransactionId.SENTINEL) {
            try {
                this.buildJSONExportDataHelper(txrs, branchLoc, endTrans, branchId, currentTransferDirectory, results);
            }
            catch (JsonProcessingException ex) {
                results.errorf("%s", new Object[]{String.format("Error in JSON Build: ", ex.getMessage())});
            }
        }
        return results;
    }

    private final List<BranchLocation> branchLocations(TransactionId exportId) {
        ArrayList<BranchLocation> branchLocations = new ArrayList<BranchLocation>();
        ArrayList transferTypes = new ArrayList();
        this.tupleQuery.getTuple4E2E3E4FromE1(TransferTupleTypes.ExportedBranch, (BranchId)CoreBranches.COMMON, (Object)exportId, (E2, E3, E4) -> {
            BranchLocation bl = new BranchLocation();
            bl.setBranchId(E2);
            bl.setBaseTxId(E3);
            bl.setUniqueTxId(E3);
            branchLocations.add(bl);
            transferTypes.add(E4);
        });
        return this.getMaxBranchLocations(branchLocations);
    }

    private final List<BranchLocation> getMaxBranchLocations(List<BranchLocation> branchLocations) {
        ArrayList<BranchLocation> bLocs = new ArrayList<BranchLocation>();
        HashMap<BranchId, Pair> Hmap = new HashMap<BranchId, Pair>();
        for (BranchLocation branchLocation : branchLocations) {
            if (Hmap.containsKey(branchLocation.getBranchId())) {
                TransactionId test = (TransactionId)((Pair)Hmap.get(branchLocation.getBranchId())).getFirst();
                if (test.isLessThan((Id)branchLocation.getBaseTxId())) {
                    Hmap.replace(branchLocation.getBranchId(), new Pair((Object)branchLocation.getBaseTxId(), (Object)branchLocation.getUniqueTxId()));
                }
            } else {
                Hmap.put(branchLocation.getBranchId(), new Pair((Object)branchLocation.getBaseTxId(), (Object)branchLocation.getUniqueTxId()));
            }
            ArrayList fileBranchLocs = new ArrayList();
            this.tupleQuery.getTuple4E2E3E4FromE1(TransferTupleTypes.TransferFile, (BranchId)CoreBranches.COMMON, (Object)branchLocation.getBranchId(), (E2, E3, E4) -> {
                BranchLocation bl = new BranchLocation();
                bl.setBranchId(branchLoc.getBranchId());
                bl.setBaseTxId(E3);
                bl.setUniqueTxId(E4);
                fileBranchLocs.add(bl);
            });
            for (BranchLocation bl : fileBranchLocs) {
                if (Hmap.containsKey(bl.getBranchId())) {
                    TransactionId test = (TransactionId)((Pair)Hmap.get(bl.getBranchId())).getFirst();
                    if (!test.isLessThan((Id)bl.getBaseTxId())) continue;
                    Hmap.replace(bl.getBranchId(), new Pair((Object)bl.getBaseTxId(), (Object)bl.getUniqueTxId()));
                    continue;
                }
                Hmap.put(bl.getBranchId(), new Pair((Object)bl.getBaseTxId(), (Object)bl.getUniqueTxId()));
            }
        }
        for (Map.Entry entry : Hmap.entrySet()) {
            BranchLocation bl = new BranchLocation();
            bl.setBranchId((BranchId)entry.getKey());
            bl.setBaseTxId((TransactionId)((Pair)entry.getValue()).getFirst());
            bl.setUniqueTxId((TransactionId)((Pair)entry.getValue()).getSecond());
            bLocs.add(bl);
        }
        return bLocs;
    }

    private boolean verifyValidTransactionToTransferHelper(String transactionComment) {
        String[] commentsToCheckAgainst = new String[]{"Adding transfer tuples", "User - Save Settings (IDE)", "Workflow Editor - Save", "Adding exportId to Tuple2Table", "Delete tuple", "Adding tuple for transfer init"};
        int i = 0;
        while (i <= commentsToCheckAgainst.length - 1) {
            if (commentsToCheckAgainst[i].equalsIgnoreCase(transactionComment.strip())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String transferDirectoryHelper(TransactionId exportId) {
        Random rand = new Random();
        String randomFour = String.format("%04d", rand.nextInt(10000));
        SimpleDateFormat formatter = new SimpleDateFormat("YYYYMMddHHmmss");
        Date transferDateAndTime = new Date();
        String osee = String.valueOf(this.orcsApi.getSystemProperties().getValue("osee.application.server.data")) + File.separator + transferDir + File.separator;
        return String.valueOf(osee) + "OSEETransfer-" + exportId.toString() + "-" + formatter.format(transferDateAndTime) + "-" + randomFour + File.separator;
    }

    private XResultData buildJSONExportDataHelper(List<TransactionReadable> txrs, BranchLocation branchLoc, TransactionId lastTx, BranchId branchId, String transferDirectory, XResultData results) throws JsonProcessingException {
        TransactionBuilderData tbd = null;
        String json = null;
        TransferBranch tb = new TransferBranch(branchId);
        tb.setPrevTx(branchLoc.getBaseTxId());
        tb.setUniqueTx(branchLoc.getUniqueTxId());
        TransactionId txInProcess = tb.getPrevTx();
        for (TransactionReadable tx : txrs) {
            boolean validTxToProcess = this.verifyValidTransactionToTransferHelper(tx.getComment());
            TransactionId uniqueTx = this.regenMap.get(TransactionId.valueOf((Long)tx.getId()));
            if (uniqueTx == null) {
                uniqueTx = TransactionId.valueOf((Long)Lib.generateUuid());
            }
            String fileName = String.valueOf(tx.getIdString()) + ".json";
            String path = String.valueOf(transferDirectory) + branchId + File.separator + fileName;
            if (!validTxToProcess) continue;
            TransferTransaction transTx = new TransferTransaction(branchId, (TransactionId)tx, uniqueTx, TransferOpType.EMPTY);
            try {
                tbd = this.transEndpoint.exportTxsDiff(txInProcess, (TransactionId)tx);
                txInProcess = tx;
            }
            catch (OseeCoreException ex) {
                results.error(ex.getLocalizedMessage());
                tb.addTransferTransaction(transTx);
                continue;
            }
            if (tbd != null && !tbd.isFailed()) {
                ObjectMapper mapper = new ObjectMapper();
                json = mapper.writeValueAsString((Object)tbd);
                try {
                    File file;
                    Path directoryPath = Paths.get(String.valueOf(transferDirectory) + branchId + File.separator, new String[0]);
                    if (!Files.exists(directoryPath, new LinkOption[0])) {
                        Files.createDirectories(directoryPath, new FileAttribute[0]);
                    }
                    if (!(file = new File(path)).exists()) {
                        file.createNewFile();
                    }
                    Lib.writeStringToFile((String)json, (File)file);
                    transTx.setTransferOp(TransferOpType.ADD);
                    tb.addTransferTransaction(transTx);
                }
                catch (Exception ex) {
                    results.errorf("%s", new Object[]{String.format("Error in writing file: ", String.valueOf(ex.getMessage()) + " location: " + path)});
                }
                continue;
            }
            if (tbd != null && tbd.isFailed()) {
                results.setWarningCount(results.getWarningCount() + 1);
                results.log(tbd.getResults());
                results.log(tbd.getMessage());
            }
            tb.addTransferTransaction(transTx);
            txInProcess = tx;
        }
        this.transferManifest.addTransferBranch(tb);
        return results;
    }

    private XResultData buildManifestFileHelper(String transferDirectory, String buildId, TransactionId exportId, XResultData results, TransactionId maxTransaction) {
        HashMap Hmap = new HashMap();
        StringBuilder fileOutput = new StringBuilder();
        String newLine = "\n";
        String markdownPipe = " | ";
        String markdownSeparator = "| ------------- |:-----------------:| ------------------:| :-----:|";
        String filePath = String.valueOf(transferDirectory) + "manifest.md";
        String dirName = "";
        String fileName = "";
        String opType = "";
        if (buildId != null) {
            fileOutput.append("BuildID: ").append(buildId).append(newLine);
            fileOutput.append("ExportID: ").append(exportId.toString()).append(newLine);
            List transBranches = this.transferManifest.getTransferBranches();
            if (transBranches.size() > 0) {
                fileOutput.append("| BranchId").append(markdownPipe).append("LocalTX").append(markdownPipe).append("UniqueTX").append(markdownPipe).append("Op").append(markdownPipe).append(newLine).append(markdownSeparator).append(newLine);
                for (TransferBranch tb : transBranches) {
                    fileOutput.append(markdownPipe).append(tb.getBranchId()).append(markdownPipe).append(tb.getPrevTx().getIdString()).append(markdownPipe).append(tb.getUniqueTx().getIdString()).append(markdownPipe).append(TransferOpType.PREV_TX.toString()).append(markdownPipe).append(newLine);
                    for (TransferTransaction transTx : tb.getTxList()) {
                        opType = transTx.getTransferOp().toString();
                        fileOutput.append(markdownPipe).append(tb.getBranchId()).append(markdownPipe).append(transTx.getSourceTransId().getIdString()).append(markdownPipe).append(transTx.getSourceUniqueTrans().getIdString()).append(markdownPipe).append(opType).append(markdownPipe).append(newLine);
                        dirName = tb.getBranchId().toString();
                        fileName = String.valueOf(transTx.getSourceTransId().getIdString()) + ".json";
                        if (Hmap.containsKey(dirName)) {
                            ((ArrayList)Hmap.get(dirName)).add(fileName);
                            continue;
                        }
                        Hmap.put(dirName, new ArrayList());
                        ((ArrayList)Hmap.get(dirName)).add(fileName);
                    }
                }
            }
            fileOutput.append("\nList of Directories/Contents\n");
            for (Map.Entry entry : Hmap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                fileOutput.append(newLine).append(" * ").append((String)entry.getKey()).append(newLine);
                String files = String.join((CharSequence)",", ((ArrayList)entry.getValue()).toString());
                try {
                    files = "\n \t * " + files.replaceAll(",", "\n \t *");
                    files = files.replaceAll("[\\[\\](){}]", "");
                }
                catch (Exception ex) {
                    results.errorf("%s", new Object[]{"Error in string replace. Exception: ", ex.getMessage()});
                }
                fileOutput.append(files).append(newLine);
            }
            try {
                File file;
                Path directoryPath = Paths.get(transferDirectory, new String[0]);
                if (!Files.exists(directoryPath, new LinkOption[0])) {
                    Files.createDirectories(directoryPath, new FileAttribute[0]);
                }
                if (!(file = new File(filePath)).exists()) {
                    file.createNewFile();
                }
                Lib.writeStringToFile((String)fileOutput.toString(), (File)file);
            }
            catch (Exception ex) {
                results.errorf("%s", new Object[]{"Error in writting manifest file. Exception: ", ex.getMessage()});
            }
        }
        return results;
    }

    public List<String> getFileList(final String strexportId, String path) {
        try {
            File directoryPath = new File(path);
            FilenameFilter filefilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String lowercaseName = name.toLowerCase();
                    if (!lowercaseName.endsWith(".zip")) {
                        return false;
                    }
                    if (strexportId == null) {
                        return true;
                    }
                    return lowercaseName.contains(strexportId);
                }
            };
            return Arrays.asList(directoryPath.list(filefilter));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public XResultData getTransferFileList(String strexportId) {
        XResultData results = new XResultData();
        try {
            String transferPath = String.valueOf(this.orcsApi.getSystemProperties().getValue("osee.application.server.data")) + File.separator + transferDir + File.separator;
            List<String> filelist = this.getFileList(strexportId, transferPath);
            if (filelist.size() > 0) {
                results.setInfoCount(filelist.size());
                results.setIds(filelist);
            }
        }
        catch (Exception ex) {
            results.error(ex.getMessage());
        }
        return results;
    }

    public String getLatestTransferFile(String strexportId) {
        String transferPath = String.valueOf(this.orcsApi.getSystemProperties().getValue("osee.application.server.data")) + File.separator + transferDir;
        List<String> filelist = this.getFileList(strexportId, transferPath);
        ArrayList<File> files = new ArrayList<File>();
        for (String str : filelist) {
            files.add(new File(String.valueOf(transferPath) + File.separator + str));
        }
        Collections.sort(files, Comparator.comparing(File::lastModified).reversed());
        if (files.size() > 0) {
            return ((File)files.get(0)).getAbsolutePath().replace(".zip", "");
        }
        return null;
    }

    private XResultData readRegenFile(TransactionId exportId) {
        XResultData results = new XResultData();
        String filepath = this.getLatestTransferFile(exportId.getIdString());
        try {
            results = this.regenTransferManifest.parse(filepath);
            if (results.isFailed()) {
                return results;
            }
            this.regenTransferManifest.getTransactionMapping(this.regenMap);
        }
        catch (Exception ex) {
            results.errorf("%s", new Object[]{String.format("Error during reading latest export transfer file: ", ex.getMessage())});
        }
        return results;
    }

    private static final class TransactionIdComparator
    implements Comparator<TransactionId> {
        private TransactionIdComparator() {
        }

        @Override
        public int compare(TransactionId arg0, TransactionId arg1) {
            return arg0.getId().compareTo(arg1.getId());
        }
    }
}

