/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsMetaData;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;
import org.eclipse.osee.orcs.rest.model.DatastoreInfo;

public class DatastoreEndpointImpl
implements DatastoreEndpoint {
    @Context
    private UriInfo uriInfo;
    private final ActivityLog activityLog;
    private final OrcsAdmin adminOps;
    private final UserService userService;
    private final JdbcService jdbcService;
    private final String GAMMA_IN_TXS_EXISTS = "SELECT count(*) FROM DUAL WHERE EXISTS (SELECT 1 FROM osee_txs WHERE gamma_id = ?)";
    private final String GAMMA_IN_TXS_ARCHIVED_EXISTS = "SELECT count(*) FROM DUAL WHERE EXISTS (SELECT 1 FROM osee_txs_archived WHERE gamma_id = ?)";

    public DatastoreEndpointImpl(OrcsApi orcsApi, ActivityLog activityLog, JdbcService jdbcService) {
        this.activityLog = activityLog;
        this.jdbcService = jdbcService;
        this.adminOps = orcsApi.getAdminOps();
        this.userService = orcsApi.userService();
    }

    protected void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public List<String> getUnusedGammas(String ids) {
        File fileList = new File("PUT_OSEE_SERVER_DATA_PATH_HERE");
        try {
            String[] split = Lib.fileToString((File)fileList).split("\n");
            int x = 1;
            int size = split.length;
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String zipFile = stringArray[n2];
                System.err.print(String.format("Processing %s/%s", x++, size));
                String gammaId = zipFile;
                gammaId = gammaId.replaceFirst("/[0-9A-Za-z\\\\+_=]+.zip$", "");
                gammaId = gammaId.replaceFirst("^\\./", "");
                gammaId = gammaId.replaceAll("/", "");
                List<String> unUsed = this.getUnusedGammaById(gammaId);
                if (!unUsed.isEmpty()) {
                    System.err.println(String.format(" - Not Found %s from %s", gammaId, zipFile));
                } else {
                    System.err.println(" ");
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            System.err.println(Lib.exceptionToString((Exception)ex));
        }
        return Collections.emptyList();
    }

    public List<String> getUnusedGammaById(String ids) {
        ArrayList<String> unUsedIds = new ArrayList<String>();
        String[] stringArray = ids.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                String id = stringArray[n2];
                try (JdbcStatement chStmt = this.jdbcService.getClient().getStatement();){
                    chStmt.runPreparedQuery("SELECT count(*) FROM DUAL WHERE EXISTS (SELECT 1 FROM osee_txs WHERE gamma_id = ?)", new Object[]{id});
                    chStmt.next();
                    int int1 = chStmt.getInt(1);
                    if (int1 != 0) break block14;
                    Throwable throwable = null;
                    Object var10_11 = null;
                    try (JdbcStatement chStmt2 = this.jdbcService.getClient().getStatement();){
                        chStmt2.runPreparedQuery("SELECT count(*) FROM DUAL WHERE EXISTS (SELECT 1 FROM osee_txs_archived WHERE gamma_id = ?)", new Object[]{id});
                        chStmt2.next();
                        int int2 = chStmt2.getInt(1);
                        if (int2 == 0) {
                            unUsedIds.add(id);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            ++n2;
        }
        return unUsedIds;
    }

    public DatastoreInfo getInfo() {
        Callable callable = this.adminOps.createFetchOrcsMetaData();
        OrcsMetaData metaData = (OrcsMetaData)OrcsRestUtil.executeCallable(callable);
        return this.asDatastoreInfo(metaData);
    }

    public TransactionId initialize(UserToken superUser) {
        TransactionId txId = this.adminOps.createDatastoreAndSystemBranches(superUser);
        this.adminOps.createDemoBranches();
        return txId;
    }

    public void synonyms() {
        this.activityLog.setEnabled(false);
        this.adminOps.createSynonymsAndGrants();
        this.activityLog.setEnabled(true);
    }

    private DatastoreInfo asDatastoreInfo(OrcsMetaData metaData) {
        DatastoreInfo info = new DatastoreInfo();
        info.setProperties(metaData.getProperties());
        return info;
    }

    public TransactionId createUsers(Iterable<UserToken> users) {
        return this.userService.createUsers(users, "Create Users via Rest");
    }

    public UserToken getUserInfo(HttpHeaders headers, String userId, String authHeader) {
        String authHeaderHard = headers.getHeaderString("Authorization");
        this.activityLog.createEntry(CoreActivityTypes.JAXRS_METHOD_CALL, new Object[]{"userId " + userId + " authHeader " + authHeader + " authHeaderHard " + authHeaderHard});
        UserToken user = this.userService.getUser();
        if (user.isInvalid()) {
            if (userId != null) {
                user = this.userService.getUserByUserId(userId);
            }
            if (user.isInvalid() && (user = this.testAuthHeader(authHeaderHard)).isInvalid()) {
                user = this.testAuthHeader(authHeader);
            }
        }
        return user;
    }

    private UserToken testAuthHeader(String authHeader) {
        if (Strings.isInValid((String)authHeader)) {
            return UserToken.SENTINEL;
        }
        String userId = authHeader.startsWith("Basic ") ? authHeader.substring("Basic ".length()) : authHeader;
        return this.userService.getUserByUserId(userId);
    }

    public void clearUserCache() {
        this.userService.clearCaches();
    }
}

