/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.logger.slf4j.internal;

import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Slf4jLogListener
implements LogListener {
    private static final Logger logger = LoggerFactory.getLogger(Slf4jLogListener.class);
    private static final String[] remapMessages = new String[]{"Bundle Event", "Service Event"};

    public void logged(LogEntry entry) {
        try {
            String symbolicName = entry.getBundle().getSymbolicName();
            Logger logger = LoggerFactory.getLogger((String)symbolicName);
            Marker marker = MarkerFactory.getMarker((String)symbolicName);
            this.logLogEntry(logger, entry.getLevel(), marker, entry.getMessage(), entry.getException());
        }
        catch (Exception ex) {
            logger.error("Error during log listening", (Throwable)ex);
        }
    }

    private void logLogEntry(Logger logger, int level, Marker marker, String message, Throwable throwable) {
        int theLevel = level;
        if (throwable == null || this.isOSGIMessage(message)) {
            theLevel = 4;
        }
        String originalName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("Osgi Log Service");
            switch (theLevel) {
                case 4: {
                    logger.debug(marker, message, throwable);
                    break;
                }
                case 1: {
                    logger.error(marker, message, throwable);
                    break;
                }
                case 2: {
                    logger.warn(marker, message, throwable);
                    break;
                }
                case 3: {
                    logger.info(marker, message, throwable);
                    break;
                }
                default: {
                    logger.trace(marker, message, throwable);
                    break;
                }
            }
        }
        finally {
            Thread.currentThread().setName(originalName);
        }
    }

    private boolean isOSGIMessage(String message) {
        String[] stringArray = remapMessages;
        int n = remapMessages.length;
        int n2 = 0;
        while (n2 < n) {
            String toCheck = stringArray[n2];
            if (message.startsWith(toCheck)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

