/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import java.util.concurrent.Callable;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.jaxrs.server.database.AbstractDatabaseStorage;
import org.eclipse.osee.jaxrs.server.security.OAuthToken;
import org.eclipse.osee.jaxrs.server.security.OAuthTokenType;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;

public class TokenStorage
extends AbstractDatabaseStorage<OAuthToken> {
    private static final long NULL_PARENT_ID = -1L;
    private static final String SELECT_TOKEN_BY_PARENT_TOKEN = "WITH parent_token (id, refresh_key) AS (SELECT id, token_key FROM osee_oauth_token WHERE token_key = ? AND type_id = ?)SELECT tk1.*, parent_token.refresh_key FROM osee_oauth_token tk1, parent_token WHERE tk1.parent_token_id = parent_token.id AND tk1.type_id = ?";
    private static final String SELECT_TOKEN_BY_CLIENT_ID_SUBJECT_ID_AND_GRANT_TYPE = "SELECT t1.*, t2.token_key AS refresh_key FROM osee_oauth_token t1 LEFT OUTER JOIN osee_oauth_token t2 ON t2.id = t1.parent_token_id WHERE t1.client_id = ? AND t1.subject_id = ? AND t1.grant_type = ?";
    private static final String INSERT_TOKEN = "INSERT INTO osee_oauth_token (id, client_id, subject_id, issued_at, expires_in, token_key, token_type, grant_type, audience, parent_token_id, type_id) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    private static final String DELETE_TOKEN_BY_ID = "DELETE FROM osee_oauth_token WHERE id = ?";
    private static final String DELETE_TOKEN_BY_TOKEN_KEY = "DELETE FROM osee_oauth_token WHERE token_key = ?";
    private static final String UPDATE_TOKEN_PARENT_BY_ID = "UPDATE osee_oauth_token SET parent_token_id = ? WHERE id = ?";

    public TokenStorage(Log logger, JdbcClient jdbcClient) {
        super(logger, jdbcClient);
    }

    protected Object[] asInsert(OAuthToken data) {
        OAuthTokenType type = data.getType();
        return new Object[]{data.getUuid(), data.getClientId(), data.getSubjectId(), data.getIssuedAt(), data.getExpiresIn(), data.getTokenKey(), data.getTokenType(), data.getGrantType(), this.asVarcharOrNull(data.getAudience()), -1L, type.getValue()};
    }

    protected Object[] asUpdate(OAuthToken data) {
        return new Object[]{data.getUuid()};
    }

    protected Object[] asDelete(OAuthToken data) {
        return new Object[]{data.getUuid()};
    }

    public OAuthToken getPreauthorizedToken(long clientUuid, long subjectUuid, String grantType) {
        return (OAuthToken)this.selectOneOrNull(SELECT_TOKEN_BY_CLIENT_ID_SUBJECT_ID_AND_GRANT_TYPE, new Object[]{clientUuid, subjectUuid, grantType});
    }

    public ResultSet<OAuthToken> getAccessTokenByRefreshToken(String tokenKey) {
        return this.selectItems(SELECT_TOKEN_BY_PARENT_TOKEN, new Object[]{tokenKey, OAuthTokenType.REFRESH_TOKEN.getValue(), OAuthTokenType.BEARER_TOKEN.getValue()});
    }

    public void insertTokens(OAuthToken ... tokens) {
        this.insertItems(INSERT_TOKEN, tokens);
    }

    public void relateTokens(OAuthToken parentToken, OAuthToken childToken) {
        Object[] data = new Object[]{parentToken.getUuid(), childToken.getUuid()};
        this.execute((Callable)new AbstractDatabaseStorage.AbstractCallable<Object[], Void>((AbstractDatabaseStorage)this, UPDATE_TOKEN_PARENT_BY_ID, data){

            protected Void innerCall() throws Exception {
                this.getJdbcClient().runPreparedUpdate(this.query, (Object[])this.data);
                return null;
            }
        });
    }

    public void deleteToken(Iterable<OAuthToken> datas) {
        this.deleteItems(DELETE_TOKEN_BY_ID, datas);
    }

    public void deleteTokenByKey(final String tokenKey) {
        this.execute((Callable)new AbstractDatabaseStorage.AbstractCallable<String, Void>((AbstractDatabaseStorage)this, DELETE_TOKEN_BY_TOKEN_KEY, tokenKey){

            protected Void innerCall() throws Exception {
                this.getJdbcClient().runPreparedUpdate(TokenStorage.DELETE_TOKEN_BY_TOKEN_KEY, new Object[]{tokenKey});
                return null;
            }
        });
    }

    protected OAuthToken readData(JdbcStatement chStmt) {
        final long uuid = chStmt.getLong("id");
        final long clientId = chStmt.getLong("client_id");
        final long subjectId = chStmt.getLong("subject_id");
        final long issuedAt = chStmt.getLong("issued_at");
        final long expiresIn = chStmt.getLong("expires_in");
        final String tokenKey = chStmt.getString("token_key");
        final String tokenType = chStmt.getString("token_type");
        final String grantType = chStmt.getString("grant_type");
        final String audience = chStmt.getString("audience");
        final OAuthTokenType type = OAuthTokenType.fromValue((int)chStmt.getInt("type_id"));
        final String refreshToken = chStmt.getString("refresh_key");
        return new OAuthToken(){

            public long getUuid() {
                return uuid;
            }

            public long getSubjectId() {
                return subjectId;
            }

            public long getClientId() {
                return clientId;
            }

            public long getIssuedAt() {
                return issuedAt;
            }

            public long getExpiresIn() {
                return expiresIn;
            }

            public String getTokenKey() {
                return tokenKey;
            }

            public String getTokenType() {
                return tokenType;
            }

            public String getGrantType() {
                return grantType;
            }

            public String getAudience() {
                return audience;
            }

            public OAuthTokenType getType() {
                return type;
            }

            public String getRefreshToken() {
                return refreshToken;
            }
        };
    }
}

