/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.client.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.osee.account.rest.client.AccountClient;
import org.eclipse.osee.account.rest.model.AccountActiveData;
import org.eclipse.osee.account.rest.model.AccountDetailsData;
import org.eclipse.osee.account.rest.model.AccountInfoData;
import org.eclipse.osee.account.rest.model.AccountInput;
import org.eclipse.osee.account.rest.model.AccountLoginData;
import org.eclipse.osee.account.rest.model.AccountPreferencesData;
import org.eclipse.osee.account.rest.model.AccountPreferencesInput;
import org.eclipse.osee.account.rest.model.AccountSessionData;
import org.eclipse.osee.account.rest.model.AccountSessionDetailsData;
import org.eclipse.osee.account.rest.model.AccountWebPreferences;
import org.eclipse.osee.account.rest.model.SubscriptionData;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;

public class AccountClientImpl
implements AccountClient {
    private URI baseUri;
    private JaxRsApi jaxRsApi;

    public void bindJaxRsApi(JaxRsApi jaxRsApi) {
        this.jaxRsApi = jaxRsApi;
    }

    public void start(Map<String, Object> properties) {
        String address;
        String string = address = properties != null ? (String)properties.get("osee.application.server") : null;
        if (address == null) {
            address = System.getProperty("osee.application.server", "");
        }
        this.baseUri = UriBuilder.fromUri((String)address).build(new Object[0]);
    }

    @Override
    public AccountSessionData login(String scheme, String username, String password) {
        AccountLoginData data = new AccountLoginData();
        data.setUsername(username);
        data.setPassword(password);
        data.setScheme(scheme);
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", "login"});
        return (AccountSessionData)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)data), AccountSessionData.class);
    }

    @Override
    public boolean logout(AccountSessionData session) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", "logout"});
        Response response = target.request().post(Entity.json((Object)session));
        return Response.Status.OK.getStatusCode() == response.getStatus();
    }

    @Override
    public AccountInfoData createAccount(String userName, AccountInput input) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", userName});
        return (AccountInfoData)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)input), AccountInfoData.class);
    }

    @Override
    public boolean deleteAccount(Long accountId) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", accountId.toString()});
        Response response = target.request().delete();
        return Response.Status.OK.getStatusCode() == response.getStatus();
    }

    @Override
    public ResultSet<AccountSessionDetailsData> getAccountSessionDataByUniqueField(String accountId) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", accountId, "sessions"});
        Object[] data = (AccountSessionDetailsData[])target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountSessionDetailsData[].class);
        return ResultSets.newResultSet((Object[])data);
    }

    @Override
    public ResultSet<AccountInfoData> getAllAccounts() {
        WebTarget target = this.jaxRsApi.newTarget("accounts");
        Object[] accounts = (AccountInfoData[])target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountInfoData[].class);
        return ResultSets.newResultSet((Object[])accounts);
    }

    @Override
    public AccountDetailsData getAccountDetailsById(Long accountId) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", accountId.toString()});
        return (AccountDetailsData)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountDetailsData.class);
    }

    @Override
    public AccountPreferencesData getAccountPreferencesById(Long accountId) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", accountId.toString(), "preferences"});
        return (AccountPreferencesData)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountPreferencesData.class);
    }

    @Override
    public AccountWebPreferences getAccountWebPreferencesByUniqueField(ArtifactId accountId) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", "preferences", accountId.getIdString()});
        return (AccountWebPreferences)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountWebPreferences.class);
    }

    @Override
    public boolean setAccountActive(Long accountId, boolean active) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", accountId.toString(), "active"});
        Response response = active ? target.request().put(null) : target.request().delete();
        return Response.Status.OK.getStatusCode() == response.getStatus();
    }

    @Override
    public boolean isAccountActive(Long accountId) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", accountId.toString(), "active"});
        AccountActiveData data = (AccountActiveData)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(AccountActiveData.class);
        return data.isActive();
    }

    @Override
    public boolean setAccountPreferences(Long accountId, Map<String, String> preferences) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"accounts", accountId.toString(), "preferences"});
        AccountPreferencesInput input = new AccountPreferencesInput();
        input.setMap(preferences);
        Response response = target.request().put(Entity.json((Object)input));
        return Response.Status.OK.getStatusCode() == response.getStatus();
    }

    private ResultSet<SubscriptionData> getSubscriptionsForAccount(Long accountId) {
        WebTarget target = this.jaxRsApi.newTarget(new String[]{"subscriptions", "for-account", accountId.toString()});
        Object[] data = (SubscriptionData[])target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(SubscriptionData[].class);
        return ResultSets.newResultSet((Object[])data);
    }

    @Override
    public ResultSet<AccountClient.UnsubscribeInfo> getUnsubscribeUris(Long accountId, Collection<String> groupNames) {
        ResultSet toReturn = ResultSets.emptyResultSet();
        ResultSet<SubscriptionData> results = this.getSubscriptionsForAccount(accountId);
        if (!results.isEmpty()) {
            ArrayList<AccountClient.UnsubscribeInfo> infos = new ArrayList<AccountClient.UnsubscribeInfo>();
            UriBuilder builder = UriBuilder.fromUri((URI)this.baseUri).path("unsubscribe").path("ui").path("{subscription-uuid}");
            for (SubscriptionData subscription : results) {
                if (!subscription.isActive() || !groupNames.contains(subscription.getName())) continue;
                String name = subscription.getName();
                URI unsubscribeUri = builder.build(new Object[]{subscription.getGuid()});
                infos.add(this.newUnsubscribeInfo(name, unsubscribeUri));
            }
            toReturn = ResultSets.newResultSet(infos);
        }
        return ResultSets.newResultSet((Iterable)toReturn);
    }

    private AccountClient.UnsubscribeInfo newUnsubscribeInfo(final String subscriptionName, final URI unsubscribeUri) {
        return new AccountClient.UnsubscribeInfo(){

            @Override
            public String getName() {
                return subscriptionName;
            }

            @Override
            public URI getUnsubscribeUri() {
                return unsubscribeUri;
            }
        };
    }
}

