/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.server.ide;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.osee.framework.core.data.OseeServerContext;
import org.eclipse.osee.framework.core.server.ISession;
import org.eclipse.osee.framework.core.server.ISessionManager;
import org.eclipse.osee.framework.core.server.UnsecuredOseeHttpServlet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class SessionClientLoopbackServlet
extends UnsecuredOseeHttpServlet {
    private static final long serialVersionUID = 6402608843937837246L;
    private final ISessionManager sessionManager;

    public SessionClientLoopbackServlet(Log logger, ISessionManager sessionManager) {
        super(logger);
        this.sessionManager = sessionManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            try {
                ISession session = this.getSessionFromRequest(request);
                String url = null;
                if (session != null) {
                    this.getLogger().info("Session found - redirect to client;\n\t url=[%s]", new Object[]{url});
                    url = String.format("%s%s", this.getRemoteHostUrl(session), this.getLoopbackPostfix(request));
                } else {
                    this.getLogger().info("No session found - redirect to web browser request handler;\n\t url=[%s]", new Object[]{url});
                    url = String.format("http://%s:%s/%s?%s", this.getNormalizedAddress(request.getLocalAddr()), request.getLocalPort(), OseeServerContext.ARTIFACT_CONTEXT, request.getQueryString());
                }
                response.setContentType("text/plain");
                response.sendRedirect(url);
            }
            catch (Exception exception) {
                response.sendError(500, String.format("Error processing request [%s]", request.getQueryString()));
                response.flushBuffer();
            }
        }
        finally {
            response.flushBuffer();
        }
    }

    private String getRemoteHostUrl(ISession session) {
        String clientAddress = session.getClientAddress();
        try {
            if (Arrays.equals(InetAddress.getByName(clientAddress).getAddress(), InetAddress.getLocalHost().getAddress())) {
                clientAddress = "localhost";
            }
        }
        catch (UnknownHostException ex) {
            this.getLogger().error((Throwable)ex, "Error resolving host for clientAddress [%s]", new Object[]{clientAddress});
        }
        return String.format("http://%s:%s/", clientAddress, session.getClientPort());
    }

    private String getLoopbackPostfix(HttpServletRequest request) throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        String context = "";
        Enumeration enumeration = request.getParameterNames();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            String value;
            String key;
            Object object = enumeration.nextElement();
            if (!(object instanceof String) || (key = (String)object).equals("sessionId") || !Strings.isValid((String)(value = request.getParameter(key)))) continue;
            if (key.equals("context")) {
                context = value;
                if (!context.startsWith("/")) continue;
                context = context.substring(1, context.length());
                continue;
            }
            if (count != 0) {
                buffer.append("&");
            }
            buffer.append(key);
            buffer.append("=");
            buffer.append(URLEncoder.encode(value, "UTF-8"));
            ++count;
        }
        if (buffer.length() > 0) {
            buffer.insert(0, '?');
        }
        return String.format("%s%s", context, buffer.toString());
    }

    private boolean canConnect(String urlString) throws IOException {
        boolean canConnect = false;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            canConnect = true;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return canConnect;
    }

    private String getNormalizedAddress(String remoteAddress) throws UnknownHostException {
        if (remoteAddress.equals("127.0.0.1") || remoteAddress.equals("localhost")) {
            remoteAddress = InetAddress.getLocalHost().getHostAddress();
        }
        return remoteAddress;
    }

    private boolean isSessionValid(ISession session) {
        boolean result = false;
        try {
            String urlString = this.getRemoteHostUrl(session);
            result = this.canConnect(urlString);
        }
        catch (Exception ex) {
            this.getLogger().warn((Throwable)ex, "Session failed to validate connect to %s", new Object[]{result});
        }
        return result;
    }

    private ISession getSessionFromRequest(HttpServletRequest request) {
        boolean isSessionValid;
        ISession session = null;
        String sessionId = request.getParameter("sessionId");
        if (Strings.isValid((String)sessionId) && !(isSessionValid = this.isSessionValid(session = this.sessionManager.getSessionById(sessionId)))) {
            session = null;
        }
        return session;
    }
}

