/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.importing;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.rest.api.importing.BlockField;
import org.eclipse.osee.define.rest.api.importing.BlockFieldToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class BlockFieldText
extends BlockField {
    private static final String BLOCK_ATTR_REGEX = "^[^:]+:\\s*(.*)";

    public BlockFieldText(BlockFieldToken bft) {
        super(bft);
    }

    @Override
    public BlockField fillContent(String content) {
        Conditions.assertNotNullOrEmpty((String)content, (String)"null content in add content to block", (Object[])new Object[0]);
        Matcher valueMatcher = Pattern.compile(BLOCK_ATTR_REGEX).matcher(content.replaceAll("<[^>]+>", ""));
        if (valueMatcher.find()) {
            String objectText = valueMatcher.group(1);
            if (Strings.isValid((String)objectText)) {
                Matcher contentMatcher = this.bft.contentRegex.matcher(content);
                if (contentMatcher.find()) {
                    String paragraph = contentMatcher.group(1);
                    String text = contentMatcher.group(3);
                    this.data = String.valueOf(paragraph) + text.replaceFirst("<w:r><w:t> :  ", "<w:r><w:t>");
                    this.setMatch(true);
                }
            } else {
                this.data = "";
            }
        }
        return this;
    }
}

