/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.TransactionData;
import org.eclipse.osee.orcs.core.ds.TransactionResult;
import org.eclipse.osee.orcs.core.ds.TxDataStore;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataManager;

public class TxCallableFactory {
    private final Log logger;
    private final TxDataStore txDataStore;
    private final TxDataManager txManager;

    public TxCallableFactory(Log logger, TxDataStore txDataStore, TxDataManager txManager) {
        this.logger = logger;
        this.txDataStore = txDataStore;
        this.txManager = txManager;
    }

    public CancellableCallable<Integer> purgeTransactions(OrcsSession session, final Collection<? extends TransactionId> transactions) {
        return new AbstractTxCallable<Integer>(this, "PurgeTransactions", session){

            @Override
            protected Integer innerCall() throws Exception {
                return txDataStore.purgeTransactions(this.getSession(), transactions).call();
            }
        };
    }

    public Callable<Void> setTransactionComment(OrcsSession session, final TransactionId transaction, final String comment) {
        return new AbstractTxCallable<Void>(this, "SetTxComment", session){

            @Override
            protected Void innerCall() throws Exception {
                return txDataStore.setTransactionComment(this.getSession(), transaction, comment).call();
            }
        };
    }

    public CancellableCallable<TransactionToken> createTx(final TxData txData) {
        return new AbstractTxCallable<TransactionToken>(this, "CommitTransaction", txData.getSession()){

            @Override
            protected TransactionToken innerCall() throws Exception {
                TransactionToken transaction = TransactionToken.SENTINEL;
                try {
                    try {
                        txManager.startTx(txData);
                        TransactionResult result = this.doCommit();
                        txManager.txCommitSuccess(txData);
                        if (result != null) {
                            transaction = result.getTransaction();
                        }
                    }
                    catch (Exception ex) {
                        block12: {
                            Throwable toThrow = ex;
                            try {
                                try {
                                    txManager.rollbackTx(txData);
                                }
                                catch (Exception exception) {
                                    toThrow = new OseeCoreException("Exception during rollback and commit", (Throwable)ex);
                                    OseeCoreException.wrapAndThrow((Throwable)toThrow);
                                    break block12;
                                }
                            }
                            catch (Throwable throwable) {
                                OseeCoreException.wrapAndThrow((Throwable)toThrow);
                                throw throwable;
                            }
                            OseeCoreException.wrapAndThrow((Throwable)toThrow);
                        }
                        txManager.endTx(txData);
                    }
                }
                finally {
                    txManager.endTx(txData);
                }
                return transaction;
            }

            private TransactionResult doCommit() throws Exception {
                TransactionData changes = txManager.createChangeData(txData);
                Callable<TransactionResult> callable = txDataStore.commitTransaction(this.getSession(), changes);
                return callable.call();
            }
        };
    }

    public void setTransactionCommitArtifact(OrcsSession session, TransactionId trans, ArtifactId commitArt) {
        this.txDataStore.setTransactionCommitArtifact(session, trans, commitArt);
    }

    private abstract class AbstractTxCallable<T>
    extends CancellableCallable<T> {
        private final String opName;
        private final OrcsSession session;

        public AbstractTxCallable(String opName, OrcsSession session) {
            this.opName = opName;
            this.session = session;
        }

        protected OrcsSession getSession() {
            return this.session;
        }

        public final T call() throws Exception {
            long startTime;
            long endTime = startTime = System.currentTimeMillis();
            T result = null;
            try {
                if (TxCallableFactory.this.logger.isTraceEnabled()) {
                    TxCallableFactory.this.logger.trace("%s [start] ", new Object[]{this.opName});
                }
                result = this.innerCall();
            }
            finally {
                endTime = System.currentTimeMillis() - startTime;
            }
            if (TxCallableFactory.this.logger.isTraceEnabled()) {
                TxCallableFactory.this.logger.trace("%s [%s] - completed", new Object[]{this.opName, Lib.asTimeString((long)endTime)});
            }
            return result;
        }

        protected abstract T innerCall() throws Exception;
    }
}

